/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondOrderModel;
import cms.tmx.bond.views.XBondTypeCell;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.ObSingleOrderXBond;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.utils.SideCell;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XBondOrderPart
extends MxPagePart<SingleOrder, ObSingleOrderXBond> {
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private TableColumn<ObSingleOrderXBond, String> ordCategory;
    @FXML
    private TableColumn<ObSingleOrderXBond, MxNode> side;
    @FXML
    private TableColumn<ObSingleOrderXBond, String> errInfo;
    @Inject
    private XBondOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private MEventService es;
    public static List<String> ORDER_STATUS = Arrays.asList("48", "49", "54");

    protected boolean predicate(SingleOrder data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getOrderId();
        boolean bTxt = code.contains(text) || orderId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        String sourceId = data.getSourceId().toUpperCase();
        String source = data.getSource().trim().toUpperCase();
        boolean bStrategy = sourceId.contains(txtStrategy) || source.contains(txtStrategy);
        String txtTrader = this.searchTextTrader.getText().trim().toUpperCase();
        String traderId = data.getTraderId().toUpperCase();
        boolean bTrader = traderId.contains(txtTrader);
        return bTxt && bStrategy && bTrader;
    }

    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.searchTextStrategy.textProperty().removeListener(this.listenerSearch);
        this.searchTextTrader.textProperty().removeListener(this.listenerSearch);
    }

    @FXML
    protected void initialize() {
        super.initialize();
        this.searchTextStrategy.textProperty().addListener(this.listenerSearch);
        this.searchTextTrader.textProperty().addListener(this.listenerSearch);
    }

    @FXML
    protected void refresh() {
        this.mxList.setBeginIndex(0);
        this.model.query();
    }

    protected List<SingleOrder> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.ordCategory.setCellFactory(cell -> new XBondTypeCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderXBond, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderXBond)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    @FXML
    private void rightCancel() {
        ObservableList list = FxUtils.newList();
        ObSingleOrderXBond selectedItem = (ObSingleOrderXBond)this.tableView.getSelectionModel().getSelectedItem();
        SingleOrder order = new SingleOrder();
        for (SingleOrder singleOrder : this.mxList.getList()) {
            if (!singleOrder.getOrderId().equals(selectedItem.getOrderId())) continue;
            order.update((Object)singleOrder);
        }
        list.add((Object)order);
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u64a4\u9500" + selectedItem.getOrderId())) {
            return;
        }
        if (!ORDER_STATUS.contains(selectedItem.getOrdStatus().getRaw())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6b64\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u64a4\u5355");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("xbond.cancel.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u8ba2\u5355\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }
}

