/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondDealModel;
import cms.tmx.bond.views.XBondTypeCell;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.entity.trade.ObExecutionXBond;
import cms.tmx.entity.trade.ObSingleOrderXBond;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.SideCell;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XBondDealPart
extends MxPagePart<Execution, ObExecutionXBond> {
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private TableColumn<ObSingleOrderXBond, String> ordCategory;
    @FXML
    private TableColumn<ObExecutionXBond, MxNode> side;
    @FXML
    private TableColumn<ObExecutionXBond, String> chName;
    @FXML
    private TableColumn<ObExecutionXBond, String> counterTraderId;
    @Inject
    private XBondDealModel model;
    @Inject
    private MxAlert alert;
    protected MxList<Execution> mlistSum = new MxList();
    @FXML
    private RadioButton radioDetail;
    @FXML
    private RadioButton radioStrategy;
    @FXML
    private RadioButton radioCode;
    @FXML
    private RadioButton radioTrader;
    @FXML
    private TableView<Execution> tableViewStrategy;
    @FXML
    private TableColumn<Execution, String> sourceStrategy;
    @FXML
    private TableColumn<Execution, String> securityIdStrategy;
    @FXML
    private TableColumn<Execution, String> securityNameStrategy;
    @FXML
    private TableColumn<Execution, MxNode> sideStrategy;
    @FXML
    private TableColumn<Execution, MxNode> settlTypeStrategy;
    @FXML
    private TableColumn<Execution, Number> ytmStrategy;
    @FXML
    private TableColumn<Execution, Number> lastQtyStrategy;
    @FXML
    private TableColumn<Execution, Number> lastPxStrategy;
    @FXML
    private TableColumn<Execution, String> traderIdStrategy;
    protected ToggleGroup group = new ToggleGroup();

    private void createSumTable() {
        this.sourceStrategy.setCellValueFactory(cell -> new SimpleStringProperty(((Execution)cell.getValue()).getSource()));
        this.securityIdStrategy.setCellValueFactory(cell -> new SimpleStringProperty(((Execution)cell.getValue()).getInstrument().getSecurityId()));
        this.securityNameStrategy.setCellValueFactory(cell -> new SimpleStringProperty(((Execution)cell.getValue()).getInstrument().getSymbol()));
        this.sideStrategy.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("xbond_side", ((Execution)cell.getValue()).getSide().getValue())));
        this.sideStrategy.setCellFactory(cell -> new SideCell());
        this.settlTypeStrategy.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("settl_type", String.valueOf(((Execution)cell.getValue()).getSettlType().ordinal()))));
        this.ytmStrategy.setCellValueFactory(cell -> new SimpleObjectProperty((Object)((Execution)cell.getValue()).getYtm()));
        this.ytmStrategy.setCellValueFactory(cell -> {
            DecimalFormat df = new DecimalFormat("#.####");
            String ytm = df.format(((Execution)cell.getValue()).getYtm());
            return new SimpleDoubleProperty(Double.valueOf(ytm).doubleValue());
        });
        this.lastPxStrategy.setCellValueFactory(cell -> {
            DecimalFormat df = new DecimalFormat("#.####");
            String price = df.format(((Execution)cell.getValue()).getLastPx());
            return new SimpleDoubleProperty(Double.valueOf(price).doubleValue());
        });
        this.lastQtyStrategy.setCellValueFactory(cell -> new SimpleDoubleProperty(((Execution)cell.getValue()).getLastQty()));
        this.traderIdStrategy.setCellValueFactory(cell -> new SimpleStringProperty(((Execution)cell.getValue()).getSelfParty().getTraderId()));
        this.tableViewStrategy.setPlaceholder((Node)new Label());
        this.mlistSum.getList().sort((o1, o2) -> o2.getSecurityId().compareTo(o1.getSecurityId()));
        this.tableViewStrategy.setItems(this.mlistSum.getList());
    }

    protected MxModel getModel() {
        return this.model;
    }

    @FXML
    public void initialize() {
        this.searchTextStrategy.textProperty().addListener(this.listenerSearch);
        this.searchTextTrader.textProperty().addListener(this.listenerSearch);
        super.initialize();
        this.initRadio();
        this.createSumTable();
    }

    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.searchTextStrategy.textProperty().removeListener(this.listenerSearch);
        this.searchTextTrader.textProperty().removeListener(this.listenerSearch);
    }

    protected void initRadio() {
        TooltipUtil.bind((RadioButton)this.radioDetail);
        TooltipUtil.bind((RadioButton)this.radioStrategy);
        TooltipUtil.bind((RadioButton)this.radioCode);
        TooltipUtil.bind((RadioButton)this.radioTrader);
        this.radioDetail.setToggleGroup(this.group);
        this.radioStrategy.setToggleGroup(this.group);
        this.radioCode.setToggleGroup(this.group);
        this.radioTrader.setToggleGroup(this.group);
        this.radioDetail.setSelected(true);
        this.tableViewStrategy.visibleProperty().bind((ObservableValue)this.radioDetail.selectedProperty().not());
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            this.sourceStrategy.setVisible(false);
            this.traderIdStrategy.setVisible(false);
            if (this.radioStrategy.equals(now)) {
                this.sourceStrategy.setVisible(true);
            } else if (this.radioTrader.equals(now)) {
                this.traderIdStrategy.setVisible(true);
            }
        });
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            if (!this.radioDetail.isSelected()) {
                List<Execution> createSumList = this.calcSumList(this.model.getList());
                this.mlistSum.update(createSumList, this.pd);
            }
        });
    }

    protected void refreshList() {
        super.refreshList();
        List<Execution> sumList = this.calcSumList(this.model.getList());
        this.mlistSum.update(sumList, this.pd);
    }

    protected List<Execution> calcSumList(List<Execution> newList) {
        HashMap<String, Execution> map = new HashMap<String, Execution>();
        LinkedList<Execution> list = new LinkedList<Execution>();
        int i = 0;
        while (i < newList.size()) {
            Execution deal = new Execution();
            deal.update((Object)newList.get(i));
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                list.add(deal);
                map.put(key, deal);
            } else {
                Execution oldDeal = (Execution)map.get(key);
                double qty = deal.getLastQty();
                double px = deal.getLastPx();
                double ytm = deal.getYtm();
                double oldQty = oldDeal.getLastQty();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastPx((oldDeal.getLastPx() * oldQty + px * qty) / oldDeal.getLastQty());
                oldDeal.setYtm((oldDeal.getYtm() * oldQty + ytm * qty) / oldDeal.getLastQty());
            }
            ++i;
        }
        return list;
    }

    protected String getKey(Execution deal) {
        String extend = "";
        if (this.radioStrategy.isSelected()) {
            extend = deal.getSource();
        } else if (this.radioTrader.isSelected()) {
            extend = deal.getSelfParty().getTraderId();
        }
        String key = String.valueOf(extend) + deal.getInstrument().getSecurityId() + deal.getSide() + deal.getSettlType();
        return key;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.ordCategory.setCellFactory(cell -> new XBondTypeCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getExecId().compareTo(o1.getExecId()));
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.getColumns().remove(this.chName);
        this.tableView.getColumns().remove(this.counterTraderId);
    }

    @FXML
    protected void refresh() {
        this.mxList.setBeginIndex(0);
        this.model.query();
    }

    protected boolean predicate(Execution exec) {
        String traderId;
        String txtTrader;
        boolean bTrader;
        String text = this.searchText.getText().trim().toUpperCase();
        String code = exec.getInstrument().getSecurityId().toUpperCase();
        String name = exec.getInstrument().getSymbol().toUpperCase();
        String execId = exec.getExecId();
        boolean bTxt = code.contains(text) || execId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        boolean bStrategy = txtStrategy.isEmpty();
        if (!bStrategy && exec.getExecMode() != null) {
            String sourceId = String.valueOf(exec.getExecMode().getEmId());
            String source = exec.getSource().trim().toUpperCase();
            if (sourceId.contains(txtStrategy) || source.contains(txtStrategy)) {
                bStrategy = true;
            }
        }
        if (!(bTrader = (txtTrader = this.searchTextTrader.getText().trim().toUpperCase()).isEmpty()) && exec.getSelfParty() != null && (traderId = exec.getSelfParty().getTraderId().toUpperCase()).contains(txtTrader)) {
            bTrader = true;
        }
        return bTxt && bStrategy && bTrader;
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listExec, (String)"\u6210\u4ea4\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
    }

    @FXML
    protected void copyStrategy() {
        TableUtils.copyContentWithHead(this.tableViewStrategy);
    }

    @FXML
    protected void refreshStrategy() {
        List<Execution> createSumList = this.calcSumList(this.model.getList());
        this.mlistSum.update(createSumList, this.pd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcelStrategy() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mlistSum.getList();
        synchronized (observableList) {
            listExec.addAll(this.mlistSum.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableViewStrategy, (String)"\u6210\u4ea4\u67e5\u8be2\u6c47\u603b");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }
}

