/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondDealMarketModel;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.XBondDealMarketItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XBondDealMarketPart
extends MxPart {
    @FXML
    private TextField searchText;
    MxList<XBondDealMarketItem> mlist = new MxList();
    @FXML
    private TableView<XBondDealMarketItem> tableDealMarket;
    @Inject
    private XBondDealMarketModel model;
    private Predicate<XBondDealMarketItem> pd = t -> {
        String txt;
        String code = t.getCode();
        return code.contains(txt = this.searchText.getText().toUpperCase());
    };
    @Inject
    private MScheduler scheduler;
    private InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        ArrayList<XBondDealMarketItem> newList = new ArrayList<XBondDealMarketItem>();
        List<XBondDealMarketItem> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.filter(newList, this.pd);
            this.tableDealMarket.refresh();
        });
    });
    private InvalidationListener lstnModel = ob -> {
        ArrayList<XBondDealMarketItem> newList = new ArrayList<XBondDealMarketItem>();
        List<XBondDealMarketItem> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.update(newList, this.pd);
            this.tableDealMarket.refresh();
        });
    };

    @FXML
    private void initialize() {
        this.createTableView();
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.subscribe("*");
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableDealMarket);
        this.tableDealMarket.setPlaceholder((Node)new Label());
        this.tableDealMarket.setItems(this.mlist.getList());
    }
}

