/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class XBondConfirmDialog
extends DialogObj {
    @FXML
    private TableView<CcsSingleEntrust> tableItems;
    @FXML
    private TableColumn<CcsSingleEntrust, String> index;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colCode;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colName;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colMkt;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colDirection;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colCount;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colUnit;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colPrice;
    @FXML
    private TableColumn<CcsSingleEntrust, Number> colAmt;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colAcc;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colSecAcc;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colMatchType;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colSettlType;
    @FXML
    private TableColumn<CcsSingleEntrust, String> colYield;
    private ObservableList<CcsSingleEntrust> list = FxUtils.newList();
    public long totalCount = 0L;
    public boolean triggered = false;
    private RefItem refItem;
    private String type = "";
    private static int PAR_VALUE = 100;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String unit = "";
    private boolean showWarning = true;

    @FXML
    public void initialize() {
        this.createTable();
    }

    protected void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).secProperty());
        this.colName.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).secNameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((CcsSingleEntrust)m.getValue()).getMarket()).getValue()));
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).sideProperty());
        this.colCount.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(m -> {
            ((CcsSingleEntrust)m.getValue()).setUnit(this.unit);
            return ((CcsSingleEntrust)m.getValue()).unitProperty();
        });
        if (!this.priceIsEmpty()) {
            this.colPrice.setCellFactory(cell -> new ItemPriceCell());
            this.colPrice.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).priceProperty());
        }
        if (!this.AmtIsEmpty()) {
            this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
            this.colAmt.setCellValueFactory(m -> new SimpleDoubleProperty(this.getMoney((CcsSingleEntrust)m.getValue())));
        }
        this.colAcc.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((CcsSingleEntrust)m.getValue()).investorSecIdProperty());
        this.colMatchType.setCellValueFactory(data -> ((CcsSingleEntrust)data.getValue()).instructionIdProperty());
        this.colSettlType.setCellValueFactory(data -> ((CcsSingleEntrust)data.getValue()).resourceIdProperty());
        this.colYield.setCellValueFactory(data -> ((CcsSingleEntrust)data.getValue()).tipProperty());
        this.tableItems.getColumns().remove(this.colUnit);
        this.tableItems.setItems(this.list);
    }

    private int getParValue(CcsSingleEntrust item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(CcsSingleEntrust item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getQuantity() * (long)this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
            return (double)item.getQuantity().longValue() * item.getPrice() * 10.0 * 100.0;
        }
        return (double)item.getQuantity().longValue() * item.getPrice() * 100.0;
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setList(List<CcsSingleEntrust> list) {
        this.list.setAll(list);
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean AmtIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<CcsSingleEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            CcsSingleEntrust item = (CcsSingleEntrust)CcsSingleEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            this.pseudoClassStateChanged(this.MARKET_PRICE, false);
            double unit = XBondConfirmDialog.this.getRefItem() != null ? XBondConfirmDialog.this.getRefItem().getPriceUnit() : 0.01;
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
            this.setText(text);
        }
    }

    private class SideCell
    extends TableCell<CcsSingleEntrust, Number> {
        private Label label = new Label();
        private MxNode sideNode;

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            this.sideNode = MxNodeFactory.create((String)"side", (String)"");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = value.intValue();
            this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

