/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.views.StdBondForwardDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.strategy.StdBondForward;
import cms.tmx.http.api.OpStatus;
import cms.tmx.javafx.MxNode;
import java.text.DecimalFormat;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class UpdateStdBondForwardDialog
extends StdBondForwardDialog {
    public StdBondForward strategy = null;

    public UpdateStdBondForwardDialog() {
        this.fxml = "StdBondForwardDialog.fxml";
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.fillDialog();
    }

    public void fillDialog() {
        this.txtSecurity.setText(this.strategy.getInstSecId());
        this.txtSecurity.setDisable(true);
        this.txtActiveSecurity.setDisable(true);
        this.txtInactiveSecurity.setDisable(true);
        this.txtSecurity.setEditable(false);
        this.txtActiveSecurity.setEditable(false);
        this.txtInactiveSecurity.setEditable(false);
        for (MxNode node : this.cmbMode.getItems()) {
            if (!this.strategy.getExecMode().name().equals(node.getRaw())) continue;
            this.cmbMode.getSelectionModel().select((Object)node);
        }
        DecimalFormat df = new DecimalFormat("#.####");
        this.spnMove.getEditor().setText(df.format(this.strategy.getSlip()));
        String qtyBid = String.valueOf(this.strategy.getQtyBid() / 10000000);
        if (this.strategy.getQtyBidMax() > 0) {
            qtyBid = String.valueOf(qtyBid) + "/" + String.valueOf(this.strategy.getQtyBidMax() / 10000000);
        }
        this.spnQtyBid.getEditor().setText(qtyBid);
        String qtyOfr = String.valueOf(this.strategy.getQtyOfr() / 10000000);
        if (this.strategy.getQtyOfrMax() > 0) {
            qtyOfr = String.valueOf(qtyOfr) + "/" + String.valueOf(this.strategy.getQtyOfrMax() / 10000000);
        }
        this.spnQtyOfr.getEditor().setText(qtyOfr);
        this.spnIrr.getEditor().setText(df.format(this.strategy.getIrr()));
        if (this.strategy.getActiveBidYield() > 0.0) {
            this.cmbActiveBidYtm.getEditor().setText(String.valueOf(this.strategy.getActiveBidYield()));
        } else {
            this.cmbActiveBidYtm.getEditor().setText(this.strategy.getActiveBidSource());
        }
        if (this.strategy.getActiveOfferYield() > 0.0) {
            this.cmbActiveOfferYtm.getEditor().setText(String.valueOf(this.strategy.getActiveOfferYield()));
        } else {
            this.cmbActiveOfferYtm.getEditor().setText(this.strategy.getActiveOfferSource());
        }
        if (this.strategy.getInactiveBidYield() > 0.0) {
            this.cmbInactiveBidYtm.getEditor().setText(String.valueOf(this.strategy.getInactiveBidYield()));
        } else {
            this.cmbInactiveBidYtm.getEditor().setText(this.strategy.getInactiveBidSource());
        }
        if (this.strategy.getInactiveOfferYield() > 0.0) {
            this.cmbInactiveOfferYtm.getEditor().setText(String.valueOf(this.strategy.getInactiveOfferYield()));
        } else {
            this.cmbInactiveOfferYtm.getEditor().setText(this.strategy.getInactiveOfferSource());
        }
        this.spnDiff.getEditor().setText(String.valueOf(this.strategy.getSpread()));
        this.spnCleanBid.getEditor().setText(df.format(this.strategy.getCleanBid()));
        this.spnCleanOfr.getEditor().setText(df.format(this.strategy.getCleanOfr()));
    }

    public boolean isOK(ButtonType type) {
        StdBondForward params = this.getParams();
        try {
            params.setContextId(this.strategy.getContextId());
            params.setPricingJobId(this.strategy.getPricingJobId());
            OpStatus status = this.model.update(params);
            MEvent event = new MEvent();
            event.put((Object)"id", (Object)status.getData());
            this.es.postEvent("last.id", event);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4fee\u6539\u6210\u529f");
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

