/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.views.BondForwardDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.strategy.BondStrategy;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class UpdateBondForwardDialog
extends BondForwardDialog {
    public BondStrategy strategy = null;

    UpdateBondForwardDialog() {
        this.fxml = "BondForwardDialog.fxml";
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.fillDialog();
    }

    public void fillDialog() {
        this.txtSecurity.setText(this.strategy.getInstSecId());
        this.txtSecurity.setDisable(true);
        this.txtActiveSecurity.setText(this.strategy.getActiveSecId());
        this.txtActiveSecurity.setDisable(true);
        this.txtInactiveSecurity.setText(this.strategy.getInactiveSecId());
        this.txtInactiveSecurity.setDisable(true);
        this.spnIrr.getEditor().setText(String.valueOf(this.strategy.getIrr()));
        if (this.strategy.getActiveBidYield() > 0.0) {
            this.cmbActiveBidYtm.getEditor().setText(String.valueOf(this.strategy.getActiveBidYield()));
        } else {
            this.cmbActiveBidYtm.getEditor().setText(this.strategy.getActiveBidSource());
        }
        if (this.strategy.getActiveOfferYield() > 0.0) {
            this.cmbActiveOfferYtm.getEditor().setText(String.valueOf(this.strategy.getActiveOfferYield()));
        } else {
            this.cmbActiveOfferYtm.getEditor().setText(this.strategy.getActiveOfferSource());
        }
        if (this.strategy.getInactiveBidYield() > 0.0) {
            this.cmbInactiveBidYtm.getEditor().setText(String.valueOf(this.strategy.getInactiveBidYield()));
        } else {
            this.cmbInactiveBidYtm.getEditor().setText(this.strategy.getInactiveBidSource());
        }
        if (this.strategy.getInactiveOfferYield() > 0.0) {
            this.cmbInactiveOfferYtm.getEditor().setText(String.valueOf(this.strategy.getInactiveOfferYield()));
        } else {
            this.cmbInactiveOfferYtm.getEditor().setText(this.strategy.getInactiveOfferSource());
        }
        this.spnDiff.getEditor().setText(String.valueOf(this.strategy.getSpread()));
    }

    protected boolean isOK(ButtonType bt) {
        BondStrategy params = new BondStrategy();
        try {
            params.setContextId(this.strategy.getContextId());
            params.setInstSecId(this.txtSecurity.getText());
            params.setActiveSecId(this.txtActiveSecurity.getText());
            params.setInactiveSecId(this.txtInactiveSecurity.getText());
            params.setIrr(Double.parseDouble(this.spnIrr.getEditor().getText()));
            if (this.lbPercentActiveBid.isVisible()) {
                params.setActiveBidYield(Double.parseDouble(this.cmbActiveBidYtm.getEditor().getText()));
            }
            if (this.lbPercentActiveOffer.isVisible()) {
                params.setActiveOfferYield(Double.parseDouble(this.cmbActiveOfferYtm.getEditor().getText()));
            }
            if (this.lbPercentInactiveBid.isVisible()) {
                params.setInactiveBidYield(Double.parseDouble(this.cmbInactiveBidYtm.getEditor().getText()));
            }
            if (this.lbPercentInactiveOffer.isVisible()) {
                params.setInactiveOfferYield(Double.parseDouble(this.cmbInactiveOfferYtm.getEditor().getText()));
            }
            params.setActiveBidSource(this.cmbActiveBidYtm.getEditor().getText());
            params.setActiveOfferSource(this.cmbActiveOfferYtm.getEditor().getText());
            params.setInactiveBidSource(this.cmbInactiveBidYtm.getEditor().getText());
            params.setInactiveOfferSource(this.cmbInactiveOfferYtm.getEditor().getText());
            params.setSpread(Double.parseDouble(this.spnDiff.getEditor().getText()));
            this.priceModel.update(params);
            MEvent event = new MEvent();
            event.put((Object)"id", (Object)this.strategy.getContextId());
            this.es.postEvent("last.id", event);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4fee\u6539\u6210\u529f");
            this.priceModel.start(this.strategy.getContextId());
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

