/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.StdBondForwardOrderModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StdBondUnfinishedOrderPart
extends MxPart {
    private final Logger logger = LogManager.getLogger(StdBondUnfinishedOrderPart.class);
    protected MxList<SingleOrder> mxList = new MxList();
    @FXML
    private TableView<SingleOrder> tableStdOrder;
    @FXML
    private TableColumn<SingleOrder, Boolean> selected;
    @FXML
    private TableColumn<SingleOrder, Number> contextId;
    @FXML
    private TableColumn<SingleOrder, String> code;
    @FXML
    private TableColumn<SingleOrder, Number> price;
    @FXML
    private TableColumn<SingleOrder, MxNode> side;
    @FXML
    private TableColumn<SingleOrder, Number> leavesQty;
    @FXML
    private TableColumn<SingleOrder, Number> orderQty;
    @FXML
    private TableColumn<SingleOrder, MxNode> status;
    @FXML
    private TableColumn<SingleOrder, MxNode> type;
    @FXML
    private TableColumn<SingleOrder, String> id;
    @FXML
    private TableColumn<SingleOrder, String> ordTime;
    @FXML
    private TableColumn<SingleOrder, String> info;
    @FXML
    private Button btnAllOrderCancel;
    @FXML
    private TextField searchText;
    @Inject
    private StdBondForwardOrderModel model;
    @Inject
    private MxAlert alert;
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("48", "49", "90", "54");
    private Predicate<SingleOrder> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        if (!CAN_CANCEL_STATUS.contains(t.getOrdStatus().getValue())) {
            return false;
        }
        return code.contains(text);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener listenerSearch = ob -> {
        List<SingleOrder> list = this.model.getList();
        synchronized (list) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
        this.tableStdOrder.refresh();
    };
    protected CheckBox checkBox = new CheckBox();
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private MEventService es;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<SingleOrder> newList = new ArrayList<SingleOrder>();
        List<SingleOrder> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> this.mxList.update(newList, this.pd));
    }

    @FXML
    private void initialize() {
        long start = System.currentTimeMillis();
        this.searchText.textProperty().addListener(this.listenerSearch);
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.createTableView();
        this.refresh();
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getList();
            synchronized (observableList) {
                this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
        System.err.println("order part init" + (System.currentTimeMillis() - start));
    }

    @FXML
    private void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("stdbond.cancel.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    @FXML
    private void allOrderCancel() {
        ObservableList list = this.mxList.getList();
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("stdbond.cancel.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    private void createTableView() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((SingleOrder)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.contextId.setCellValueFactory(cell -> new SimpleIntegerProperty(((SingleOrder)cell.getValue()).getExecMode().getEmId()));
        this.contextId.setCellFactory(cell -> new IdCell());
        this.code.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getInstrument().getSecurityId()));
        this.side.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("side", ((SingleOrder)cell.getValue()).getSide().getValue())));
        this.side.setCellFactory(cell -> new SideCell());
        this.status.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("ord_status", ((SingleOrder)cell.getValue()).getOrdStatus().getValue())));
        this.type.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("price_type", ((SingleOrder)cell.getValue()).getOrdType().getValue())));
        this.price.setCellValueFactory(cell -> {
            DecimalFormat df = new DecimalFormat("#.####");
            String price = df.format(((SingleOrder)cell.getValue()).getPrice());
            return new SimpleDoubleProperty(Double.valueOf(price).doubleValue());
        });
        this.leavesQty.setCellValueFactory(cell -> new SimpleDoubleProperty(((SingleOrder)cell.getValue()).getLeavesQty() / 1.0E7));
        this.orderQty.setCellValueFactory(cell -> new SimpleDoubleProperty(((SingleOrder)cell.getValue()).getOrderQty() / 1.0E7));
        this.id.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getOrderId()));
        this.info.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getErrInfo()));
        this.ordTime.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getOrdTime()));
        this.tableStdOrder.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableStdOrder.setItems(this.mxList.getList());
    }

    @FXML
    private void refresh() {
        this.exe.execute(() -> {
            try {
                this.model.query();
            }
            catch (MException | IOException e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                e.printStackTrace();
                this.logger.error(e.getMessage(), e);
            }
        });
    }

    public class IdCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                if (value.longValue() == 0L) {
                    this.label.setText("");
                } else {
                    this.label.setText(value.toString());
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                StdBondUnfinishedOrderPart.this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }
}

