/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.SecFormatter;
import cms.tmx.bond.models.StdBondForwardTradeModel;
import cms.tmx.bond.views.StdSecSuggest;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.Formatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.trade.models.UserPreCtrl;
import cms.tmx.trade.views.StdBondEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StdBondForwardTradePart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(StdBondForwardTradePart.class);
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private TextField txtTime;
    @FXML
    private RadioButton buyRadio;
    @FXML
    private RadioButton sellRadio;
    @FXML
    private TextField txtPrice;
    @FXML
    private TextField txtQty;
    @FXML
    private Button btnOrder;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    private StdBondForwardTradeModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    protected IRefDataMng ref;
    @Inject
    protected MEventService es;
    @Inject
    protected MObjFactory of;
    private StdSecSuggest suggest = new StdSecSuggest();
    private Collection<RefItem> codeList = new ArrayList<RefItem>();
    @Inject
    protected UserPreCtrl preModel;
    @Inject
    protected DialogFactory df;

    @FXML
    private void initialize() {
        this.initControls();
        this.keyEvent();
    }

    private void initControls() {
        this.initSecurity();
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.setSelected(true);
        this.txtTime.textProperty().bindBidirectional((Property)this.model.timeProperty());
        MxBindings.bindSD((Property)this.txtPrice.textProperty(), (Property)this.model.priceProperty());
        MxBindings.bindSD((Property)this.txtQty.textProperty(), (Property)this.model.countProperty());
        this.txtPrice.setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.txtPrice.setText("");
        this.txtQty.setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$", 10));
        this.txtQty.setText("");
        this.txtTime.setText("19:00");
        this.txtTime.setTextFormatter((TextFormatter)new Formatter("^[0-9:\uff1a]{0,5}$", 5));
        this.txtTime.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                String txt = this.txtTime.getText();
                if (!StringUtils.patternCheck((String)"^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3])):(([0-9]{0,1})|([0-5][0-9]))$", (String)(txt = txt.replace("\uff1a", ":")))) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u6709\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e, \u4f8b 19:00");
                    return;
                }
                int hour = Integer.valueOf(txt.substring(0, txt.indexOf(":")));
                int minute = Integer.valueOf(txt.substring(txt.indexOf(":") + 1, txt.length()));
                String hourStr = String.valueOf(hour);
                if (hour < 10) {
                    hourStr = "0" + hourStr;
                }
                String minuteStr = String.valueOf(minute);
                if (minute < 10) {
                    minuteStr = "0" + minuteStr;
                }
                this.txtTime.setText(String.valueOf(hourStr) + ":" + minuteStr);
            }
        });
    }

    private void keyEvent() {
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtQty.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.qtyKeyPress((KeyEvent)event));
        this.txtTime.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.timeKeyPress((KeyEvent)event));
        this.txtPrice.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.txtTime.requestFocus();
            key.consume();
        }
    }

    private void timeKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.txtPrice.requestFocus();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.txtQty.requestFocus();
            key.consume();
        }
    }

    private void qtyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    public static void main(String[] args) {
        String txt = "09:02";
        int hour = Integer.valueOf(txt.substring(0, txt.indexOf(":")));
        int minute = Integer.valueOf(txt.substring(txt.indexOf(":") + 1, txt.length()));
        System.out.println(hour);
        System.out.println(minute);
    }

    private void initSecurity() {
        Collection refs = this.ref.getItems(new String[]{"FORWARD"});
        if (refs.isEmpty()) {
            refs = this.ref.getItems(new String[]{"SBFWD"});
        }
        for (RefItem ref : refs) {
            StdBondForward std;
            if (!(ref instanceof StdBondForward) || !(std = (StdBondForward)ref).getStatus().equals("B")) continue;
            this.codeList.add(ref);
        }
        this.suggest.addPossibleSuggestions(this.codeList);
        AutoCompletion auto = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.suggest, (StringConverter)((StringConverter)this.of.create(SecConverter.class)));
        auto.setPrefWidth(350.0);
        auto.changedProperty().addListener((ob, old, now) -> {
            this.model.refItem = (StdBondForward)this.txtCode.getUserData();
        });
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
    }

    protected void onBSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText("\u4e70\u5165");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText("\u5356\u51fa");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.model.setBuy(now);
    }

    @FXML
    public void order() {
        if (!StringUtils.patternCheck((String)"^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3])):(([0-9]{0,1})|([0-5][0-9]))$", (String)this.txtTime.getText())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6709\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e, \u4f8b 19:00");
            return;
        }
        if (Double.valueOf(this.txtQty.getText()) > 99.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u5356\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc799(\u5343\u4e07)");
            return;
        }
        if (this.preModel.isPopBeforeOrder()) {
            StdBondEntrustConfirmDialog obj = (StdBondEntrustConfirmDialog)this.of.create(StdBondEntrustConfirmDialog.class);
            obj.setRefItem((RefItem)this.model.refItem);
            obj.setUnit("\u5143");
            obj.setList(this.model.getEntrustList());
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
            if (dialog.launch() != ButtonType.OK) {
                return;
            }
        }
        try {
            this.model.submit();
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4e0b\u5355\u6210\u529f");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

