/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.StdBondForwardPositionModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import java.io.IOException;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StdBondForwardPositionPart
extends MxPart {
    private final Logger logger = LogManager.getLogger(StdBondForwardPositionPart.class);
    private MxList<Position> list = new MxList();
    @FXML
    private TableView<Position> tablePosition;
    @FXML
    private TableColumn<Position, String> code;
    @FXML
    private TableColumn<Position, String> side;
    @FXML
    private TableColumn<Position, Number> position;
    @FXML
    private TableColumn<Position, Number> available;
    @FXML
    private TextField searchText;
    @Inject
    private StdBondForwardPositionModel model;
    @Inject
    private MxAlert alert;
    private Predicate<Position> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        return code.contains(text);
    };
    private InvalidationListener listenerSearch = ob -> this.list.filter(this.model.getList(), this.pd);

    @FXML
    private void initialize() {
        this.searchText.textProperty().addListener(this.listenerSearch);
        this.model.changedProperty().addListener((ob, old, now) -> {
            this.list.update(this.model.getList(), this.pd);
            this.list.getList().sort((o1, o2) -> o1.getInstrument().getSecurityId().compareTo(o2.getInstrument().getSecurityId()));
            this.tablePosition.refresh();
        });
        this.createTable();
        this.refresh();
    }

    private void createTable() {
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((Position)data.getValue()).getInstrument().getSecurityId()));
        this.position.setCellValueFactory(data -> new SimpleDoubleProperty(((Position)data.getValue()).getSodQty() + ((Position)data.getValue()).getIntraDayQty()));
        this.available.setCellValueFactory(data -> new SimpleDoubleProperty(((Position)data.getValue()).getSodQty() + ((Position)data.getValue()).getIntraDayQty() - ((Position)data.getValue()).getFrozenQty()));
        this.tablePosition.setPlaceholder((Node)new Label());
        this.list.getList().sort((o1, o2) -> o1.getInstrument().getSecurityId().compareTo(o2.getInstrument().getSecurityId()));
        this.tablePosition.setItems(this.list.getList());
    }

    @FXML
    public void refresh() {
        try {
            this.model.query();
        }
        catch (MException | IOException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
        }
    }
}

