/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.BondUtils;
import cms.tmx.bond.models.BondForwardPricingModel;
import cms.tmx.bond.models.StdBondForwardModel;
import cms.tmx.bond.views.AddStdBondForwardDialog;
import cms.tmx.bond.views.BondForwardPart;
import cms.tmx.bond.views.UpdateStdBondForwardDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.EditTreeTableCellString;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.strategy.StdBondForward;
import cms.tmx.http.api.OpStatus;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StdBondForwardPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BondForwardPart.class);
    @FXML
    private TreeTableView<StdBondForward> treetableBond;
    private MxList<StdBondForward> mxList = new MxList();
    @FXML
    private TreeTableColumn<StdBondForward, Boolean> selected;
    @FXML
    private TreeTableColumn<StdBondForward, String> contextId;
    @FXML
    private TreeTableColumn<StdBondForward, String> securityId;
    @FXML
    private TreeTableColumn<StdBondForward, MxNode> mode;
    @FXML
    private TreeTableColumn<StdBondForward, MxNode> status;
    @FXML
    private TreeTableColumn<StdBondForward, Object> operate;
    @FXML
    private TreeTableColumn<StdBondForward, Number> bidQty;
    @FXML
    private TreeTableColumn<StdBondForward, Number> bidYield;
    @FXML
    private TreeTableColumn<StdBondForward, String> bidClean;
    @FXML
    private TreeTableColumn<StdBondForward, String> refBidPx;
    @FXML
    private TreeTableColumn<StdBondForward, String> refOfferPx;
    @FXML
    private TreeTableColumn<StdBondForward, String> irr;
    @FXML
    private TreeTableColumn<StdBondForward, String> offerClean;
    @FXML
    private TreeTableColumn<StdBondForward, Number> offerYield;
    @FXML
    private TreeTableColumn<StdBondForward, Number> offerQty;
    @FXML
    private TreeTableColumn<StdBondForward, String> activeSecurity;
    @FXML
    private TreeTableColumn<StdBondForward, String> activeBidYield;
    @FXML
    private TreeTableColumn<StdBondForward, String> activeOfrYield;
    @FXML
    private TreeTableColumn<StdBondForward, Number> activeBidDirtyPx;
    @FXML
    private TreeTableColumn<StdBondForward, Number> activeBidCleanPx;
    @FXML
    private TreeTableColumn<StdBondForward, Number> activeOfrDirtyPx;
    @FXML
    private TreeTableColumn<StdBondForward, Number> activeOfrCleanPx;
    @FXML
    private TreeTableColumn<StdBondForward, Number> activeInterest;
    @FXML
    private TreeTableColumn<StdBondForward, String> inactiveSecurity;
    @FXML
    private TreeTableColumn<StdBondForward, String> inactiveBidYield;
    @FXML
    private TreeTableColumn<StdBondForward, String> inactiveOfrYield;
    @FXML
    private TreeTableColumn<StdBondForward, Number> spread;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveBidDirtyPxA;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveBidCleanPxA;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveOfrDirtyPxA;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveOfrCleanPxA;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveBidDirtyPxB;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveBidCleanPxB;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveOfrDirtyPxB;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveOfrCleanPxB;
    @FXML
    private TreeTableColumn<StdBondForward, Number> inactiveInterest;
    protected static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    protected static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    @Inject
    private StdBondForwardModel model;
    @Inject
    protected MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MEventService es;
    @Inject
    private MxAlert alert;
    SecSuggest.StrSuggest suggestBid = SecSuggest.getStrSuggest();
    SecSuggest.StrSuggest suggestOffer = SecSuggest.getStrSuggest();
    ObservableList<String> listBid = FxUtils.newList();
    ObservableList<String> listOffer = FxUtils.newList();
    private String last = null;
    private MEventHandler handler = event -> {
        this.last = (String)event.get((Object)"id");
    };
    private InvalidationListener listener = ob -> Platform.runLater(() -> {
        this.treetableBond.setRoot(this.model.getRoot());
        this.treetableBond.setShowRoot(false);
        this.treetableBond.sort();
        this.treetableBond.refresh();
    });
    protected Callback<TreeTableColumn<StdBondForward, Boolean>, TreeTableCell<StdBondForward, Boolean>> checkBoxFactory = p -> new TreeTableCell<StdBondForward, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((StdBondForward)this.getTreeTableRow().getItem()).selectedProperty());
                    this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, checkBox.disableProperty().get());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (this.getTreeTableRow().getTreeItem().isLeaf()) {
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((StdBondForward)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                            }
                        });
                    } else {
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((StdBondForward)each.getValue()).setSelected(((StdBondForward)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                } else {
                    this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                }
            }
        }
    };

    @FXML
    public void initialize() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        this.createTableView();
        this.refresh();
        this.es.subscribe("last.id", this.handler);
        this.listBid.add((Object)"BID_\u6700\u4f18");
        this.listBid.add((Object)"BID_\u56fd\u9645");
        this.listBid.add((Object)"BID_\u56fd\u5229");
        this.listBid.add((Object)"BID_\u4fe1\u5510");
        this.listBid.add((Object)"BID_\u4e2d\u8bda");
        this.listBid.add((Object)"BID_\u5e73\u5b89");
        this.suggestBid.addPossibleSuggestions(this.listBid);
        this.listOffer.add((Object)"OFR_\u6700\u4f18");
        this.listOffer.add((Object)"OFR_\u56fd\u9645");
        this.listOffer.add((Object)"OFR_\u56fd\u5229");
        this.listOffer.add((Object)"OFR_\u4fe1\u5510");
        this.listOffer.add((Object)"OFR_\u4e2d\u8bda");
        this.listOffer.add((Object)"OFR_\u5e73\u5b89");
        this.suggestOffer.addPossibleSuggestions(this.listOffer);
    }

    @FXML
    private void refresh() {
        try {
            this.model.get();
        }
        catch (MException | IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void add() {
        AddStdBondForwardDialog bond = (AddStdBondForwardDialog)((Object)this.of.create(AddStdBondForwardDialog.class));
        MxDialog dialog = this.df.create((DialogObj)bond, "\u65b0\u589e\u505a\u5e02\u7b56\u7565");
        dialog.launch();
        this.refresh();
    }

    @FXML
    public void start() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (TreeItem item : this.treetableBond.getRoot().getChildren()) {
            for (TreeItem strategy : item.getChildren()) {
                if (!((StdBondForward)strategy.getValue()).isSelected() || ((StdBondForward)strategy.getValue()).getStatus().getRaw().equals("1")) continue;
                market = ((StdBondForward)strategy.getValue()).getMarket();
                listId.add(((StdBondForward)strategy.getValue()).getContextId());
            }
        }
        try {
            this.model.start(market, listId);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u6267\u884c\u6210\u529f");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6267\u884c\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        this.refresh();
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (TreeItem item : this.treetableBond.getRoot().getChildren()) {
            for (TreeItem strategy : item.getChildren()) {
                if (!((StdBondForward)strategy.getValue()).isSelected() || !((StdBondForward)strategy.getValue()).getStatus().getRaw().equals("1")) continue;
                market = ((StdBondForward)strategy.getValue()).getMarket();
                listId.add(((StdBondForward)strategy.getValue()).getContextId());
            }
        }
        try {
            this.model.stop(market, listId);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u505c\u6b62\u6210\u529f");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u505c\u6b62\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        this.refresh();
    }

    private void createTableView() {
        this.selected.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).selectedProperty());
        this.selected.setCellFactory(this.checkBoxFactory);
        this.selected.setSortable(false);
        this.selected.getTreeTableView().setEditable(true);
        this.operate.setCellValueFactory(data -> this.setOperate((TreeItem<StdBondForward>)data.getValue()));
        this.contextId.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).contextIdProperty());
        this.securityId.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).instSecIdProperty());
        this.status.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).statusProperty());
        this.refBidPx.setCellValueFactory(data -> {
            String str = String.valueOf(((StdBondForward)data.getValue().getValue()).getRefBidPx());
            if (!((StdBondForward)data.getValue().getValue()).getProjectBid().isEmpty()) {
                str = String.valueOf(str) + "(" + ((StdBondForward)data.getValue().getValue()).getProjectBid() + ")";
            }
            return new SimpleStringProperty(str);
        });
        this.refBidPx.setCellFactory(cell -> new PriceCell(true));
        this.refOfferPx.setCellFactory(cell -> new PriceCell(false));
        this.irr.setCellValueFactory(cell -> new SimpleStringProperty(StringUtils.nf.format(((StdBondForward)cell.getValue().getValue()).getIrr())));
        this.refOfferPx.setCellValueFactory(data -> {
            String str = String.valueOf(((StdBondForward)data.getValue().getValue()).getRefOfferPx());
            if (!((StdBondForward)data.getValue().getValue()).getProjectOffer().isEmpty()) {
                str = String.valueOf(str) + "(" + ((StdBondForward)data.getValue().getValue()).getProjectOffer() + ")";
            }
            return new SimpleStringProperty(str);
        });
        this.mode.setCellValueFactory(data -> {
            StdBondForward cfr_ignored_0 = (StdBondForward)data.getValue().getValue();
            MxNode node = new MxNode().load("bondforward_mode", String.valueOf(((StdBondForward)data.getValue().getValue()).getExecMode()));
            return new SimpleObjectProperty((Object)node);
        });
        this.bidClean.setCellValueFactory(data -> new SimpleStringProperty(StringUtils.nf.format(((StdBondForward)data.getValue().getValue()).getCleanBid())));
        this.offerClean.setCellValueFactory(data -> new SimpleStringProperty(StringUtils.nf.format(((StdBondForward)data.getValue().getValue()).getCleanOfr())));
        this.bidQty.setCellValueFactory(data -> new SimpleDoubleProperty((double)(((StdBondForward)data.getValue().getValue()).getQtyBid() / 10000000)));
        this.offerQty.setCellValueFactory(data -> new SimpleDoubleProperty((double)(((StdBondForward)data.getValue().getValue()).getQtyOfr() / 10000000)));
        this.activeSecurity.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).activeSecIdProperty());
        this.activeBidYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((StdBondForward)data.getValue().getValue()).getActiveBidYieldCalc())));
        this.activeOfrYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((StdBondForward)data.getValue().getValue()).getActiveOfferYieldCalc())));
        this.activeBidDirtyPx.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).activeBidDirtyPxProperty());
        this.activeBidCleanPx.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).activeBidCleanPxProperty());
        this.activeOfrDirtyPx.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).activeOfferDirtyPxProperty());
        this.activeOfrCleanPx.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).activeOfferCleanPxProperty());
        this.activeInterest.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).activeInterestProperty());
        this.inactiveSecurity.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveSecIdProperty());
        this.inactiveBidYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((StdBondForward)data.getValue().getValue()).getInactiveBidYieldCalc())));
        this.inactiveOfrYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((StdBondForward)data.getValue().getValue()).getInactiveOfferYieldCalc())));
        this.inactiveBidDirtyPxA.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveBidDirtyPxAProperty());
        this.inactiveBidCleanPxA.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveBidCleanPxAProperty());
        this.inactiveOfrDirtyPxA.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveOfferDirtyPxAProperty());
        this.inactiveOfrCleanPxA.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveOfferCleanPxAProperty());
        this.inactiveBidCleanPxB.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveBidCleanPxBProperty());
        this.inactiveBidDirtyPxB.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveBidDirtyPxBProperty());
        this.inactiveOfrCleanPxB.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveOfferCleanPxBProperty());
        this.inactiveOfrDirtyPxB.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveOfferDirtyPxBProperty());
        this.inactiveInterest.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).inactiveInterestProperty());
        this.spread.setCellValueFactory(data -> ((StdBondForward)data.getValue().getValue()).spreadProperty());
        this.treetableBond.setPlaceholder((Node)new Label());
        this.activeBidYield.setCellFactory(cell -> new YieldSource(true, true));
        this.activeOfrYield.setCellFactory(cell -> new YieldSource(true, false));
        this.inactiveBidYield.setCellFactory(cell -> new YieldSource(false, true));
        this.inactiveOfrYield.setCellFactory(cell -> new YieldSource(false, false));
        this.treetableBond.setEditable(true);
    }

    public ReadOnlyObjectWrapper<Object> setOperate(TreeItem<StdBondForward> ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Button btnStart = new Button("      ");
        btnStart.getStyleClass().add((Object)"btnOperation");
        Button btnUpdate = new Button("\u4fee\u6539");
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        btnUpdate.setOnAction(event -> {
            UpdateStdBondForwardDialog dialog = (UpdateStdBondForwardDialog)((Object)((Object)this.of.create(UpdateStdBondForwardDialog.class)));
            dialog.strategy = (StdBondForward)ap.getValue();
            MxDialog d = this.df.create((DialogObj)dialog, "\u4fee\u6539\u505a\u5e02\u7b56\u7565");
            d.launch();
            this.refresh();
        });
        Button btnDelete = new Button("\u5220\u9664");
        btnDelete.getStyleClass().add((Object)"btnOperation");
        btnDelete.setOnAction(event -> {
            boolean comfirm = this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8981\u5220\u9664" + ((StdBondForward)ap.getValue()).getInstSecId() + "\u5417?");
            if (!comfirm) {
                return;
            }
            try {
                OpStatus status = this.model.delete((StdBondForward)ap.getValue());
                this.refresh();
                if (status.getStatus() == 1) {
                    this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f");
                } else {
                    this.alert.alert(Alert.AlertType.ERROR, "\u5220\u9664\u5931\u8d25\uff1a" + status.getReason());
                }
            }
            catch (MException e) {
                e.printStackTrace();
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
        if (!((StdBondForward)ap.getValue()).getInstSecId().contains("\u52a8")) {
            hBox.getChildren().add(0, (Object)btnUpdate);
            hBox.getChildren().add(1, (Object)btnDelete);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    class EditIrr
    extends EditTreeTableCell<StdBondForward> {
        EditIrr() {
        }

        public void startEdit() {
            BondForwardPricingModel.isEditting = true;
            super.startEdit();
        }

        public void commitEdit(Number item) {
            try {
                try {
                    super.commitEdit(item);
                    StdBondForward bond = (StdBondForward)this.getTreeTableRow().getItem();
                    StdBondForwardPart.this.model.update(bond);
                    StdBondForwardPart.this.last = bond.getContextId();
                    StdBondForwardPart.this.refresh();
                }
                catch (MException | Exception e) {
                    logger.error(e.getMessage());
                    StdBondForwardPart.this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    BondForwardPricingModel.isEditting = false;
                }
            }
            finally {
                BondForwardPricingModel.isEditting = false;
            }
        }
    }

    public class PriceCell
    extends TreeTableCell<StdBondForward, String> {
        private Label label = new Label();
        boolean isBuy = true;

        public PriceCell(boolean isBuy) {
            this.isBuy = isBuy;
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                this.label.setText(value);
                if (this.isBuy) {
                    CssUtils.makeRise((Control)this.label);
                } else {
                    CssUtils.makeFall((Control)this.label);
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    class YieldSource
    extends EditTreeTableCellString<StdBondForward> {
        boolean isActive = true;
        boolean isBid = true;
        String tips = "";

        YieldSource(boolean isActive, boolean isBid) {
            this.isActive = isActive;
            this.isBid = isBid;
        }

        public void startEdit() {
            BondForwardPricingModel.isEditting = true;
            super.startEdit();
            this.textField.setText(this.tips);
            Search.bindAutoCompletion((TextField)this.textField, (Callback)(this.isBid ? StdBondForwardPart.this.suggestBid : StdBondForwardPart.this.suggestOffer));
        }

        protected void loseFocus() {
            try {
                super.loseFocus();
                StdBondForward bond = (StdBondForward)this.getTreeTableRow().getItem();
                String text = this.textField.getText().trim();
                boolean isDouble = BondUtils.isMatch(text);
                if (!isDouble) {
                    if (this.isBid && !StdBondForwardPart.this.listBid.contains((Object)text)) {
                        StdBondForwardPart.this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u5185\u5bb9(" + text + ")\u683c\u5f0f\u4e0d\u5bf9, \u4f8b(0.1, BID_\u6700\u4f18)");
                        return;
                    }
                    if (!this.isBid && !StdBondForwardPart.this.listOffer.contains((Object)text)) {
                        StdBondForwardPart.this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u5185\u5bb9(" + text + ")\u683c\u5f0f\u4e0d\u5bf9, \u4f8b(0.1, OFR_\u6700\u4f18)");
                        return;
                    }
                }
                try {
                    if (this.isActive) {
                        if (this.isBid) {
                            if (isDouble) {
                                double yield = Double.parseDouble(text);
                                bond.setActiveBidYield(yield);
                                bond.setActiveBidSource("");
                            } else {
                                bond.setActiveBidYield(0.0);
                                bond.setActiveBidSource(text);
                            }
                        } else if (isDouble) {
                            double yield = Double.parseDouble(text);
                            bond.setActiveOfferYield(yield);
                            bond.setActiveOfferSource("");
                        } else {
                            bond.setActiveOfferYield(0.0);
                            bond.setActiveOfferSource(text);
                        }
                    } else if (this.isBid) {
                        if (isDouble) {
                            double yield = Double.parseDouble(text);
                            bond.setInactiveBidYield(yield);
                            bond.setInactiveBidSource("");
                        } else {
                            bond.setInactiveBidYield(0.0);
                            bond.setInactiveBidSource(text);
                        }
                    } else if (isDouble) {
                        double yield = Double.parseDouble(text);
                        bond.setInactiveOfferYield(yield);
                        bond.setInactiveOfferSource("");
                    } else {
                        bond.setInactiveOfferYield(0.0);
                        bond.setInactiveOfferSource(text);
                    }
                    StdBondForwardPart.this.model.update(bond);
                    StdBondForwardPart.this.last = bond.getContextId();
                    StdBondForwardPart.this.refresh();
                }
                catch (MException | Exception e) {
                    logger.error(e.getMessage());
                }
            }
            finally {
                BondForwardPricingModel.isEditting = false;
            }
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            StdBondForward bond = (StdBondForward)this.getTreeTableRow().getItem();
            if (bond == null) {
                return;
            }
            if (this.isActive) {
                if (this.isBid) {
                    if (!bond.getActiveBidSource().isEmpty()) {
                        this.tips = bond.getActiveBidSource();
                    }
                    if (bond.getActiveBidYield() > 0.0) {
                        this.tips = String.valueOf(bond.getActiveBidYield());
                    }
                } else {
                    if (!bond.getActiveOfferSource().isEmpty()) {
                        this.tips = bond.getActiveOfferSource();
                    }
                    if (bond.getActiveOfferYield() > 0.0) {
                        this.tips = String.valueOf(bond.getActiveOfferYield());
                    }
                }
            } else if (this.isBid) {
                if (!bond.getInactiveBidSource().isEmpty()) {
                    this.tips = bond.getInactiveBidSource();
                }
                if (bond.getInactiveBidYield() > 0.0) {
                    this.tips = String.valueOf(bond.getInactiveBidYield());
                }
            } else {
                if (!bond.getInactiveOfferSource().isEmpty()) {
                    this.tips = bond.getInactiveOfferSource();
                }
                if (bond.getInactiveOfferYield() > 0.0) {
                    this.tips = String.valueOf(bond.getInactiveOfferYield());
                }
            }
            this.setTooltip(new Tooltip(this.tips));
        }
    }
}

