/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.StdBondForwardOrderModel;
import cms.tmx.bond.views.StdBondForwardDealPart;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderStdBond;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.SideCell;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StdBondForwardOrderPart
extends MxPagePart<SingleOrder, ObSingleOrderStdBond> {
    private final Logger logger = LogManager.getLogger(StdBondForwardDealPart.class);
    @FXML
    private TableColumn<ObSingleOrderStdBond, Number> contextId;
    @FXML
    private TableColumn<ObSingleOrderStdBond, MxNode> side;
    @FXML
    private TableColumn<ObSingleOrderStdBond, Number> leavesQty;
    @FXML
    private TableColumn<ObSingleOrderStdBond, Number> orderQty;
    @Inject
    private StdBondForwardOrderModel model;
    @Inject
    private MxAlert alert;

    StdBondForwardOrderPart() {
    }

    protected List<SingleOrder> getList() {
        return this.model.getList();
    }

    protected boolean predicate(SingleOrder e) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = e.getInstrument().getSecurityId().toUpperCase();
        return code.contains(text);
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (MException | IOException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
        }
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.contextId.setCellFactory(cell -> new IdCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.leavesQty.setCellFactory(cell -> new CountCell());
        this.orderQty.setCellFactory(cell -> new CountCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    public void exportExcel() {
    }

    public void defaultSort() {
    }

    public class CountCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                int i = (int)(value.longValue() / 10000000L);
                this.label.setText(String.valueOf(i));
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                StdBondForwardOrderPart.this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    public class IdCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                if (value.longValue() == 0L) {
                    this.label.setText("");
                } else {
                    this.label.setText(value.toString());
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                StdBondForwardOrderPart.this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }
}

