/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.BondUtils;
import cms.tmx.bond.views.BondForwardDialog;
import cms.tmx.control.formatters.Formatter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.entity.strategy.StdBondForward;
import cms.tmx.http.api.strategy.dto.ExecMode;
import cms.tmx.javafx.MxNode;
import cms.tmx.utils.StringUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextFormatter;

public class StdBondForwardDialog
extends BondForwardDialog {
    @FXML
    protected ComboBox<MxNode> cmbMode;
    @FXML
    protected Spinner<Double> spnCleanBid;
    @FXML
    protected Spinner<Double> spnCleanOfr;
    @FXML
    protected Spinner<Integer> spnQtyBid;
    @FXML
    protected Spinner<Integer> spnQtyOfr;
    @FXML
    protected Spinner<Double> spnMove;
    @FXML
    protected Label lbMoveErr;
    @FXML
    protected Label lbCleanBidErr;
    @FXML
    protected Label lbCleanOfrErr;
    @FXML
    protected Label lbQtyBidErr;
    @FXML
    protected Label lbQtyOfrErr;
    private DoubleSpinnerCtrl ctrlSpnMove = new DoubleSpinnerCtrl(true, 9, 4);
    private DoubleSpinnerCtrl ctrlSpnCleanBid = new DoubleSpinnerCtrl(true, 9, 4);
    private DoubleSpinnerCtrl ctrlSpnCleanOfr = new DoubleSpinnerCtrl(true, 9, 4);
    private IntSpinnerCtrl ctrlSpnQtyBid = new IntSpinnerCtrl(true, 10, 1);
    private IntSpinnerCtrl ctrlSpnQtyOfr = new IntSpinnerCtrl(true, 10, 1);

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.ctrlSpnMove.ctrl(this.spnMove);
        this.ctrlSpnCleanBid.ctrl(this.spnCleanBid);
        this.ctrlSpnCleanOfr.ctrl(this.spnCleanOfr);
        this.ctrlSpnQtyBid.ctrl(this.spnQtyBid);
        this.ctrlSpnQtyOfr.ctrl(this.spnQtyOfr);
        this.cmbMode.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals(ExecMode.kAutoMaticExecMode.name())) {
                this.spnQtyBid.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(/([1-9]{1}\\d*)?)?$", 12));
                this.spnQtyOfr.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(/([1-9]{1}\\d*)?)?$", 12));
                this.spnCleanBid.getEditor().clear();
                this.spnCleanOfr.getEditor().clear();
                this.spnCleanBid.setDisable(true);
                this.spnCleanOfr.setDisable(true);
            } else {
                String txt;
                if (this.spnQtyBid.getEditor().getText().contains("/")) {
                    txt = this.spnQtyBid.getEditor().getText();
                    this.spnQtyBid.getEditor().setText(txt.substring(0, txt.indexOf("/")));
                }
                if (this.spnQtyOfr.getEditor().getText().contains("/")) {
                    txt = this.spnQtyOfr.getEditor().getText();
                    this.spnQtyOfr.getEditor().setText(txt.substring(0, txt.indexOf("/")));
                }
                this.spnQtyBid.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))$", 12));
                this.spnQtyOfr.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))$", 12));
                this.spnCleanBid.setDisable(false);
                this.spnCleanOfr.setDisable(false);
            }
        });
        MxNode node = new MxNode().load("bondforward_mode", "kAutoMaticExecMode");
        this.cmbMode.setItems(node.getNodes());
        this.cmbMode.setValue((Object)node);
    }

    @Override
    protected void registerCheck() {
        super.registerCheck();
        this.registerCheck((Node)this.lbCleanBidErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            MxNode node = (MxNode)this.cmbMode.getSelectionModel().getSelectedItem();
            if (node == null) {
                return false;
            }
            if (ExecMode.kAutoMaticExecMode.name().equals(node.getRaw())) {
                return true;
            }
            return !this.spnCleanBid.getEditor().getText().isEmpty();
        }, (Observable[])new Observable[]{this.cmbMode.valueProperty(), this.spnCleanBid.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbCleanOfrErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            MxNode node = (MxNode)this.cmbMode.getSelectionModel().getSelectedItem();
            if (node == null) {
                return false;
            }
            if (ExecMode.kAutoMaticExecMode.name().equals(node.getRaw())) {
                return true;
            }
            return !this.spnCleanOfr.getEditor().getText().isEmpty();
        }, (Observable[])new Observable[]{this.cmbMode.valueProperty(), this.spnCleanOfr.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbQtyBidErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int limit;
            int qty;
            String txt = this.spnQtyBid.getEditor().getText();
            if (txt.isEmpty()) {
                this.lbQtyBidErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u6570\u91cf");
                return false;
            }
            if (!StringUtils.patternCheck((String)"^(([1-9]{1}\\d*)|([0]{1}))(/([1-9]{1}\\d*))?$", (String)txt)) {
                this.lbQtyBidErr.setText("\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                return false;
            }
            if (txt.contains("/") && (qty = Integer.valueOf(txt.substring(0, txt.indexOf("/"))).intValue()) > (limit = Integer.valueOf(txt.substring(txt.indexOf("/") + 1, txt.length())).intValue())) {
                this.lbQtyBidErr.setText("\u4e70\u5165\u6570\u91cf\u5e94\u5c0f\u4e8e\u6700\u5927\u6210\u4ea4\u6570\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyBid.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbQtyOfrErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int limit;
            int qty;
            String txt = this.spnQtyOfr.getEditor().getText();
            if (txt.isEmpty()) {
                this.lbQtyOfrErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u6570\u91cf");
                return false;
            }
            if (!StringUtils.patternCheck((String)"^(([1-9]{1}\\d*)|([0]{1}))(/([1-9]{1}\\d*))?$", (String)txt)) {
                this.lbQtyOfrErr.setText("\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                return false;
            }
            if (txt.contains("/") && (qty = Integer.valueOf(txt.substring(0, txt.indexOf("/"))).intValue()) > (limit = Integer.valueOf(txt.substring(txt.indexOf("/") + 1, txt.length())).intValue())) {
                this.lbQtyOfrErr.setText("\u5356\u51fa\u6570\u91cf\u5e94\u5c0f\u4e8e\u6700\u5927\u6210\u4ea4\u6570\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyOfr.getEditor().textProperty()}));
    }

    public StdBondForward getParams() {
        StdBondForward params = new StdBondForward();
        params.setMarket(this.refItem.getMarket());
        params.setInstSecId(this.txtSecurity.getText());
        if (ExecMode.kAutoMaticExecMode.name().equals(((MxNode)this.cmbMode.getSelectionModel().getSelectedItem()).getRaw())) {
            params.setExecMode(ExecMode.kAutoMaticExecMode);
        } else {
            params.setExecMode(ExecMode.kManualExecMode);
        }
        if (!this.spnCleanBid.getEditor().getText().isEmpty()) {
            params.setCleanBid(Double.valueOf(this.spnCleanBid.getEditor().getText()).doubleValue());
        }
        if (!this.spnCleanOfr.getEditor().getText().isEmpty()) {
            params.setCleanOfr(Double.valueOf(this.spnCleanOfr.getEditor().getText()).doubleValue());
        }
        String txt = this.spnQtyBid.getEditor().getText();
        int qty = 0;
        int limit = 0;
        if (txt.contains("/")) {
            qty = Integer.valueOf(txt.substring(0, txt.indexOf("/")));
            limit = Integer.valueOf(txt.substring(txt.indexOf("/") + 1, txt.length()));
            params.setQtyBidMax(limit * 10000000);
        } else {
            qty = Integer.valueOf(txt);
        }
        params.setQtyBid(qty * 10000000);
        txt = this.spnQtyOfr.getEditor().getText();
        if (txt.contains("/")) {
            qty = Integer.valueOf(txt.substring(0, txt.indexOf("/")));
            limit = Integer.valueOf(txt.substring(txt.indexOf("/") + 1, txt.length()));
            params.setQtyOfrMax(limit * 10000000);
        } else {
            qty = Integer.valueOf(txt);
        }
        params.setQtyOfr(qty * 10000000);
        params.setSlip(Double.valueOf(this.spnMove.getEditor().getText()).doubleValue());
        params.setActiveSecId(this.txtActiveSecurity.getText());
        params.setInactiveSecId(this.txtInactiveSecurity.getText());
        params.setIrr(Double.parseDouble(this.spnIrr.getEditor().getText()));
        if (this.lbPercentActiveBid.isVisible()) {
            params.setActiveBidYield(Double.parseDouble(this.cmbActiveBidYtm.getEditor().getText()));
        }
        if (this.lbPercentActiveOffer.isVisible()) {
            params.setActiveOfferYield(Double.parseDouble(this.cmbActiveOfferYtm.getEditor().getText()));
        }
        if (this.lbPercentInactiveBid.isVisible()) {
            params.setInactiveBidYield(Double.parseDouble(this.cmbInactiveBidYtm.getEditor().getText()));
        }
        if (this.lbPercentInactiveOffer.isVisible()) {
            params.setInactiveOfferYield(Double.parseDouble(this.cmbInactiveOfferYtm.getEditor().getText()));
        }
        params.setActiveBidSource(BondUtils.getSource(this.cmbActiveBidYtm.getEditor().getText()));
        params.setActiveOfferSource(BondUtils.getSource(this.cmbActiveOfferYtm.getEditor().getText()));
        params.setActiveMarket(this.activeMarket);
        params.setInactiveBidSource(BondUtils.getSource(this.cmbInactiveBidYtm.getEditor().getText()));
        params.setInactiveOfferSource(BondUtils.getSource(this.cmbInactiveOfferYtm.getEditor().getText()));
        params.setInactiveMarket(this.inactiveMarket);
        params.setSpread(Double.parseDouble(this.spnDiff.getEditor().getText()));
        return params;
    }
}

