/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.StdBondForwardDealModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObExecutionStdBond;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.SideCell;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class StdBondForwardDealPart
extends MxPagePart<Execution, ObExecutionStdBond> {
    @FXML
    private TableColumn<Execution, String> contextId;
    @FXML
    private TableColumn<Execution, MxNode> side;
    @Inject
    private StdBondForwardDealModel model;
    @Inject
    private MxAlert alert;

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.side.setCellFactory(cell -> new SideCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getPageList());
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (MException | IOException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
        }
    }

    protected boolean predicate(Execution t) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        return code.contains(text) || t.getInstrument().getSymbol().contains(text);
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    public void exportExcel() {
    }

    public void defaultSort() {
    }
}

