/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.PledgeRepoModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.trade.models.CcsTradeModel;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.trade.views.CcsTradePart;
import java.math.BigDecimal;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.annotation.PreDestroy;

public class PledgeRepoPart
extends CcsTradePart {
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> maxNumberCol;
    private PledgeRepoModel repoModel;
    private volatile Boolean addColumns = false;
    private InvalidationListener distChange = ob -> {
        if (ob instanceof ObjectProperty) {
            ObjectProperty node = (ObjectProperty)ObjectProperty.class.cast(ob);
            MxNode cast = (MxNode)MxNode.class.cast(node.getValue());
            if ("6".equals(cast.getRaw())) {
                if (!this.addColumns.booleanValue()) {
                    this.addColumns = true;
                    this.acctTreeTable.getColumns().add(6, this.maxNumberCol);
                }
            } else {
                this.addColumns = false;
                this.acctTreeTable.getColumns().remove(this.maxNumberCol);
            }
        }
    };
    private static final int COUNT_MAX_SH = 10000;
    private static final int COUNT_MAX_SZ = 1000000;

    @FXML
    public void initialize() {
        super.initialize();
        this.lbSide.setText("\u65b9\u5411");
        this.buyRadio.setText("\u6b63\u56de\u8d2d");
        this.sellRadio.setText("\u9006\u56de\u8d2d");
        this.lbUpLimit.setVisible(false);
        this.lbDownLimit.setVisible(false);
        this.cmbDist.valueProperty().addListener(this.distChange);
    }

    protected void acctTreeSupplement() {
        this.ctrlCount.setUnit(1);
        this.countStg.setItems(this.repoModel.getCountStg().getNodes());
        this.countStg.setPrefWidth(135.0);
        this.acctTreeTable.getColumns().remove((Object)this.availableCol);
        this.acctTreeTable.getColumns().add(4, (Object)this.availableCol);
        this.canBuyCol.setText("\u53ef\u7528\u6807\u51c6\u5238");
        this.acctTreeTable.getColumns().remove((Object)this.canBuyCol);
        this.acctTreeTable.getColumns().add(5, (Object)this.canBuyCol);
        this.acctTreeTable.getColumns().remove((Object)this.canSellCol);
        TableUtils.orgnizeClmWidth((TreeTableView)this.acctTreeTable);
        this.acctTreeTable.getColumns().remove(this.maxNumberCol);
        this.maxNumberCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).maxNumberProperty());
        this.maxNumberCol.setCellFactory(p -> new MoneyCell(2));
        this.repoModel.countStgProperty().addListener(ob -> {
            if (this.repoModel.distStgIsDisable()) {
                ((MxNode)this.cmbDist.getValue()).addNode("4");
                this.cmbDist.getSelectionModel().selectLast();
                this.cmbDist.setDisable(true);
            } else {
                this.repoModel.onBsChange();
                this.cmbDist.setDisable(false);
            }
        });
    }

    protected void onBSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText("\u6b63\u56de\u8d2d");
            this.lbCan.setText("\u53ef\u6b63\u56de\u8d2d\u6570");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText("\u9006\u56de\u8d2d");
            this.lbCan.setText("\u53ef\u9006\u56de\u8d2d\u6570");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
    }

    protected void onSecurityChange(String newText) {
        Platform.runLater(() -> {
            super.onSecurityChange(newText);
            if (this.repoModel.isValidRef()) {
                if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                    this.lbUnit.setText("\u624b");
                    this.ctrlCount.setUnit(100);
                    this.ctrlPrice.getVF().setUnit(0.005);
                } else {
                    this.lbUnit.setText("\u5f20");
                    this.ctrlCount.setUnit(10);
                    this.ctrlPrice.getVF().setUnit(0.001);
                }
            }
        });
    }

    public CcsTradeModel createModel() {
        this.repoModel = (PledgeRepoModel)((Object)this.of.create(PledgeRepoModel.class));
        return this.repoModel;
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder("");
        StringBuilder warn = new StringBuilder("");
        for (CcsAccountDistribution acc : this.ccsModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
            String str = this.countCheck(acc.getCount());
            if (warn.toString().contains(str)) continue;
            warn.append(str);
        }
        this.priceCheck(warn);
        return info.insert(0, warn).toString();
    }

    private String countCheck(double count) {
        StringBuilder warn = new StringBuilder();
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            if (count % (double)this.ctrlCount.getVF().getUnit() != 0.0) {
                warn.append("\u4ea4\u6613\u6570\u91cf\u5e94\u4e3a100\u624b\u7684\u6574\u6570\u500d\n");
            }
            if (count > 10000.0) {
                warn.append("\u5355\u7b14\u7533\u62a5\u5e94\u4e0d\u8d85\u8fc71\u4e07\u624b\n");
            }
        } else {
            if (count % (double)this.ctrlCount.getVF().getUnit() != 0.0) {
                warn.append("\u4ea4\u6613\u6570\u91cf\u5e94\u4e3a10\u5f20\u7684\u6574\u6570\u500d\n");
            }
            if (count > 1000000.0) {
                warn.append("\u5355\u7b14\u7533\u62a5\u5e94\u4e0d\u8d85\u8fc7100\u4e07\u5f20\n");
            }
        }
        return warn.toString();
    }

    private void priceCheck(StringBuilder warn) {
        String price = this.priceSpn.getEditor().getText().replaceAll(",", "");
        BigDecimal bigPrice = BigDecimal.valueOf(Double.parseDouble(price));
        double unit = this.ctrlPrice.getVF().getUnit();
        BigDecimal bigUnit = BigDecimal.valueOf(unit);
        BigDecimal[] result = bigPrice.divideAndRemainder(bigUnit);
        if (unit != 0.001 && result[1].doubleValue() != 0.0) {
            warn.append("\u6700\u5c0f\u53d8\u52a8\u5355\u4f4d\u4e3a0.005\u5143\u6216\u5176\u6574\u6570\u500d\n");
        }
        if (!warn.toString().isEmpty()) {
            warn.insert(0, "\n\u8b66\u544a: ");
        }
    }

    @FXML
    public void order() {
        this.ccsModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            if (this.preModel.isPopBeforeOrder()) {
                CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
                obj.setRefItem(this.mktItem.getRefItem());
                obj.setPriceStg(this.ccsModel.getPriceStg());
                obj.setUnit(this.lbUnit.getText());
                obj.setList(this.ccsModel.getEntrustList());
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
                if (dialog.launch() == ButtonType.OK) {
                    this.submitOrder();
                }
            } else {
                this.submitOrder();
            }
        }
    }

    @PreDestroy
    protected void close() {
        super.close();
        this.cmbDist.valueProperty().removeListener(this.distChange);
    }

    public void submitOrder() {
        try {
            String result = this.repoModel.submit();
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, result);
        }
        catch (MException e) {
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
        }
        this.clearCountCheck();
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(this.accountCol.getText()).append("\t");
        clipboardString.append(this.accNameCol.getText()).append("\t");
        clipboardString.append(this.secAcctCol.getText()).append("\t");
        clipboardString.append(this.availableCol.getText()).append("\t");
        if (this.sellRadio.isSelected() && "6".equals(((MxNode)this.cmbDist.getValue()).getRaw())) {
            clipboardString.append(this.maxNumberCol.getText()).append("\t");
        }
        clipboardString.append(this.assetCol.getText()).append("\t");
        clipboardString.append(this.weightCol.getText()).append("\t");
        clipboardString.append(this.amountCol.getText()).append("\t");
        clipboardString.append(this.canBuyCol.getText()).append("\t");
        clipboardString.append(this.canSellCol.getText()).append("\t");
        clipboardString.append(this.productCol.getText()).append("\n");
        for (TreeItem item : this.ccsModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc()).append("\t");
            clipboardString.append(accDis.getAccntName()).append("\t");
            clipboardString.append("\t");
            clipboardString.append(accDis.getAcc().getAvailable()).append("\t");
            if (this.sellRadio.isSelected() && "6".equals(((MxNode)this.cmbDist.getValue()).getRaw())) {
                clipboardString.append(accDis.getMaxNumber()).append("\t");
            }
            clipboardString.append(accDis.getAcc().getAssetAmt()).append("\t");
            clipboardString.append(accDis.getWeight()).append("\t");
            clipboardString.append(accDis.getCount()).append("\t");
            clipboardString.append(accDis.getCanBuy()).append("\t");
            clipboardString.append(accDis.getCanSell()).append("\t");
            clipboardString.append(accDis.getAcc().getProductName()).append("\n");
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t");
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getSecAcc()).append("\t");
                clipboardString.append("\t");
                if (this.sellRadio.isSelected() && "6".equals(((MxNode)this.cmbDist.getValue()).getRaw())) {
                    clipboardString.append(secAccDis.getMaxNumber()).append("\t");
                }
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getWeight()).append("\t");
                clipboardString.append(secAccDis.getCount()).append("\t");
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getCanSell()).append("\t");
                clipboardString.append("\n");
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }
}

