/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.PledgeOutInTradeModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.PledgeAcctDist;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class PledgeOutInTradePart
extends MxPart {
    @FXML
    private TextField txtCode;
    @FXML
    private GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    private RadioButton buyRadio;
    @FXML
    private RadioButton sellRadio;
    @FXML
    private ComboBox<MxNode> countStg;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Label lbUnit1;
    @FXML
    private Spinner<Integer> spnQty;
    @FXML
    private CheckBox checkAuto;
    @FXML
    private Spinner<Integer> spnSingleQty;
    @FXML
    private Label lbPer;
    @FXML
    private ComboBox<MxNode> cmbDist;
    @FXML
    private TreeTableView<PledgeAcctDist> acctTreeTable;
    @FXML
    private TreeTableColumn<PledgeAcctDist, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, SecAccount> secAcctCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, Number> weightCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, Number> amountCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, Number> totalCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, Number> canInCol;
    @FXML
    private TreeTableColumn<PledgeAcctDist, Number> canOutCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Label lbOftenOne;
    @FXML
    private Label lbOftenTwo;
    @FXML
    private Label lbOftenThree;
    @FXML
    private Label lbOftenFour;
    @FXML
    private HBox hboxCounts;
    @FXML
    private HBox hboxOften;
    @FXML
    private Label lbCan;
    @FXML
    private Label lbCanCount;
    @FXML
    private Button btnOrder;
    @FXML
    private ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private HBox hboxPer;
    @FXML
    private TextField txtPerCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    private TextField txtSearch;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected PledgeOutInTradeModel ccsModel;
    @Inject
    protected DialogFactory df;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private SecConverter secCvt;
    private MEvent pstEvent = new MEvent();
    private boolean isPstEvent = false;
    @Inject
    private UserPreOrderTips setTips;
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 10);
    protected IntSpinnerCtrl ctrlSingleCount = new IntSpinnerCtrl(true, 9, 10);
    private SecSuggest spCode = new SecSuggest();
    private MEventHandler hSetCode = event -> {
        this.txtCode.requestFocus();
        this.pstEvent = event;
        this.isPstEvent = true;
        if (this.txtCode.getText().equals(event.getStr("sec_code"))) {
            this.onSecurityChange();
        } else {
            this.txtCode.setText(event.getStr("sec_code"));
        }
    };
    private InvalidationListener listener = ob -> {
        Collection list = this.refMng.getItems(new String[]{this.ccsModel.getTradeType()});
        this.spCode.setAllSuggestions(list);
    };
    private ListChangeListener<TreeItem<PledgeAcctDist>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<PledgeAcctDist>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<PledgeAcctDist, Boolean>, TreeTableCell<PledgeAcctDist, Boolean>> checkBoxFactory = p -> new TreeTableCell<PledgeAcctDist, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((PledgeAcctDist)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(PledgeOutInTradePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((PledgeAcctDist)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> PledgeOutInTradePart.this.doCheckChildrenSelected((TreeItem<PledgeAcctDist>)treeItem));
                        PledgeOutInTradePart.this.doCheckChildrenSelected((TreeItem<PledgeAcctDist>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((PledgeAcctDist)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                PledgeOutInTradePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> PledgeOutInTradePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((PledgeAcctDist)each.getValue()).setSelected(((PledgeAcctDist)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((PledgeAcctDist)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };

    @Inject
    public PledgeOutInTradePart() {
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("trade.panel.set.code.pledge", this.hSetCode);
    }

    @FXML
    public void initialize() {
        this.refMng.changedProperty().addListener(this.listener);
        this.initControls();
        this.createAcctTree();
        this.es.subscribe("trade.panel.set.code.pledge", this.hSetCode);
    }

    private void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{this.ccsModel.getTradeType()}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> {
            this.onSecurityChange();
            this.acctTreeTable.refresh();
        });
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.ccsModel.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.ccsModel.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.selectedProperty().bindBidirectional((Property)this.ccsModel.outProperty());
        this.checkAuto.selectedProperty().bindBidirectional((Property)this.ccsModel.autoProperty());
        this.lbCan.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.ccsModel.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.spnQty);
        this.spnQty.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        MxBindings.bindSI((Property)this.spnQty.getEditor().textProperty(), (Property)this.ccsModel.countProperty());
        this.spnQty.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.spnQty.getEditor().setOnMouseClicked(event -> this.spnQty.getEditor().selectAll());
        this.spnQty.getEditor().setText("");
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.percentKeyPress((KeyEvent)event));
        this.spnQty.getEditor().textProperty().addListener((ob, old, now) -> {
            if (now.equals("") || Integer.valueOf(now.replaceAll(",", "")) < 1000000) {
                this.checkAuto.setSelected(false);
                this.spnSingleQty.getEditor().clear();
            } else {
                this.checkAuto.setSelected(true);
                this.spnSingleQty.getEditor().setText("1000000");
            }
        });
        this.checkAuto.selectedProperty().addListener((ob, old, now) -> this.spnSingleQty.setDisable(now == false));
        this.ctrlSingleCount.ctrl(this.spnSingleQty);
        MxBindings.bindSI((Property)this.spnSingleQty.getEditor().textProperty(), (Property)this.ccsModel.singleCountProperty());
        this.spnSingleQty.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.singleQtyKeyPress((KeyEvent)event));
        this.spnSingleQty.getEditor().setOnMouseClicked(event -> this.spnSingleQty.getEditor().selectAll());
        this.spnSingleQty.getEditor().setText("");
        this.countStg.setItems(this.ccsModel.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange((MxNode)now));
        this.countStg.valueProperty().bindBidirectional(this.ccsModel.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        TradeBindings.bindBigNumToInt((StringProperty)this.lbCountOne.textProperty(), (ObservableNumberValue)new SimpleIntegerProperty(100000));
        TradeBindings.bindBigNumToInt((StringProperty)this.lbCountTwo.textProperty(), (ObservableNumberValue)new SimpleIntegerProperty(50000));
        TradeBindings.bindBigNumToInt((StringProperty)this.lbCountThree.textProperty(), (ObservableNumberValue)new SimpleIntegerProperty(20000));
        TradeBindings.bindBigNumToInt((StringProperty)this.lbCountFour.textProperty(), (ObservableNumberValue)new SimpleIntegerProperty(10000));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().is("3") || this.ccsModel.getCountStg().is("2"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.ccsModel.countPerProperty());
        this.hboxOften.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getCountStg().getRaw().equals("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        SpinnerUtils.arrowsStyle(this.spnQty);
        SpinnerUtils.arrowsStyle(this.spnSingleQty);
    }

    private void createAcctTree() {
        this.cmbDist.setItems(this.ccsModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.ccsModel.distStgProperty());
        this.cmbAccFilter.setItems(this.ccsModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.ccsModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.ccsModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.ccsModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.ccsModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).secAccProperty());
        this.totalCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).totalProperty());
        this.canInCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).canInProperty());
        this.canOutCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).canOutProperty());
        this.weightCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((PledgeAcctDist)data.getValue().getValue()).countProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.ccsModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.ccsModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
    }

    private void onBSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText("\u51fa\u5e93");
            this.lbCan.setText("\u53ef\u51fa\u5e93");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText("\u5165\u5e93");
            this.lbCan.setText("\u53ef\u5165\u5e93");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
    }

    private void onCountStgChange(MxNode now) {
        String stg = now.getRaw();
        if (stg.equals("1")) {
            this.ccsModel.getDistStg().removeNode("4");
            this.cmbDist.getSelectionModel().selectFirst();
            this.cmbDist.setDisable(false);
            return;
        }
        if (stg.equals("3")) {
            TradeBindings.bindToMoney((StringProperty)this.lbOftenOne.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(100.0));
            TradeBindings.bindToMoney((StringProperty)this.lbOftenTwo.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(50.0));
            TradeBindings.bindToMoney((StringProperty)this.lbOftenThree.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(33.33));
            TradeBindings.bindToMoney((StringProperty)this.lbOftenFour.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(25.0));
        } else if (stg.equals("2")) {
            TradeBindings.bindToMoney((StringProperty)this.lbOftenOne.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(100.0));
            TradeBindings.bindToMoney((StringProperty)this.lbOftenTwo.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(50.0));
            TradeBindings.bindToMoney((StringProperty)this.lbOftenThree.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(33.33));
            TradeBindings.bindToMoney((StringProperty)this.lbOftenFour.textProperty(), (ObservableNumberValue)new SimpleDoubleProperty(25.0));
        }
        this.ccsModel.getDistStg().addNode("4");
        this.cmbDist.getSelectionModel().selectLast();
        this.cmbDist.setDisable(true);
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange() {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        if (refItem == null) {
            if (this.txtCode.getText().length() >= 6) {
                this.ccsModel.setName(INVALID_CODE);
            } else {
                this.ccsModel.setName("");
            }
        }
        this.ccsModel.setPledge(refItem);
        this.ccsModel.onSecChange();
        this.spnQty.getEditor().setText("");
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (this.isPstEvent) {
            this.isPstEvent = false;
            this.spnQty.getEditor().setText(String.valueOf(this.pstEvent.getInt("count")));
            this.sellRadio.setSelected(this.pstEvent.getBool("side_sell"));
            this.ccsModel.setPstAcct(this.pstEvent.getStr("secAccount"), this.pstEvent.getStr("tMarket"));
        }
        if (this.ccsModel.isValidRef()) {
            if (this.ccsModel.getPledge().getMarket().equals("XSHG")) {
                this.lbUnit.setText("\u624b");
                this.lbUnit1.setText("\u624b");
                this.ctrlCount.setUnit(1);
                this.ctrlSingleCount.setUnit(1);
            } else {
                this.lbUnit.setText("\u5f20");
                this.lbUnit1.setText("\u5f20");
                this.ctrlCount.setUnit(10);
                this.ctrlSingleCount.setUnit(10);
            }
        }
    }

    private void check() {
        PledgeInfo pledge = this.ccsModel.getPledge();
        if (pledge == null || pledge.getName().equals("")) {
            this.lbName.setText(INVALID_CODE);
        }
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.ccsModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.ccsModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.ccsModel.getCount() >= 0L && this.ccsModel.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u5355\u7b14\u6570\u91cf\u4e0d\u5408\u6cd5";
        return !this.checkAuto.isSelected() || this.alert.check(this.ccsModel.getSingleCount() > 0L, Alert.AlertType.WARNING, tip6);
    }

    @FXML
    public void order() {
        this.ccsModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
            obj.setRefItem(this.ccsModel.getValidRef());
            obj.setPriceStg(null);
            obj.setUnit(this.lbUnit.getText());
            obj.setList(this.ccsModel.getEntrustList());
            obj.setType("PLEDGE");
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                String result = this.ccsModel.submit();
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, result);
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.spnQty.requestFocus();
                this.spnQty.getEditor().selectAll();
            } else if (this.checkAuto.isSelected()) {
                this.spnSingleQty.requestFocus();
                this.spnSingleQty.getEditor().selectAll();
            } else {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            }
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.txtCode.requestFocus();
            this.order();
            key.consume();
        }
    }

    private void percentKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.txtCode.requestFocus();
            this.order();
            key.consume();
        }
    }

    private void singleQtyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.txtCode.requestFocus();
                this.txtCode.selectAll();
                key.consume();
            } else {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
                key.consume();
            }
        } else if (KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.order();
                this.txtCode.requestFocus();
                key.consume();
            } else {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
                key.consume();
            }
        }
    }

    private void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + '\n');
        for (TreeItem item : this.ccsModel.getAccDisModel().getRoot().getChildren()) {
            PledgeAcctDist accDis = (PledgeAcctDist)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + accDis.getSecAcc() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                PledgeAcctDist secAccDis = (PledgeAcctDist)subItem.getValue();
                clipboardString.append(secAccDis.getAcc() + "\t" + secAccDis.getSecAcc() + "\t" + secAccDis.getAcc().getAssetAmt() + "\t" + secAccDis.getAcc().getAvailable() + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<PledgeAcctDist> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((PledgeAcctDist)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((PledgeAcctDist)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    private void onOften(int i) {
        String stg = this.ccsModel.getCountStg().getRaw();
        if (stg.equals("3")) {
            switch (i) {
                case 0: {
                    this.ccsModel.countPerProperty().set(100.0);
                    break;
                }
                case 1: {
                    this.ccsModel.countPerProperty().set(50.0);
                    break;
                }
                case 2: {
                    this.ccsModel.countPerProperty().set(33.33);
                    break;
                }
                default: {
                    this.ccsModel.countPerProperty().set(25.0);
                    break;
                }
            }
        } else if (stg.equals("2")) {
            switch (i) {
                case 0: {
                    this.ccsModel.countPerProperty().set(100.0);
                    break;
                }
                case 1: {
                    this.ccsModel.countPerProperty().set(50.0);
                    break;
                }
                case 2: {
                    this.ccsModel.countPerProperty().set(33.33);
                    break;
                }
                default: {
                    this.ccsModel.countPerProperty().set(25.0);
                }
            }
        }
    }

    @FXML
    private void onOftenOne() {
        this.onOften(0);
    }

    @FXML
    private void onOftenTwo() {
        this.onOften(1);
    }

    @FXML
    private void onOftenThree() {
        this.onOften(2);
    }

    @FXML
    private void onOftenFour() {
        this.onOften(3);
    }

    @FXML
    public void onCountOne() {
        this.ccsModel.setCount(100000L);
    }

    @FXML
    public void onCountTwo() {
        this.ccsModel.setCount(50000L);
    }

    @FXML
    public void onCountThree() {
        this.ccsModel.setCount(20000L);
    }

    @FXML
    public void onCountFour() {
        this.ccsModel.setCount(10000L);
    }

    public TreeTableView<PledgeAcctDist> getAccTreeTable() {
        return this.acctTreeTable;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<PledgeAcctDist> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((PledgeAcctDist)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

