/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.FormulaModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.LocalFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.MatchConverter;
import cms.tmx.control.search.Search;
import cms.tmx.control.search.localSuggest;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.ActiveBenchmarkPricingSettings;
import cms.tmx.utils.StringUtils;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class InitiativeBenchmarkDialog
extends DialogObj {
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtPosCost;
    @FXML
    private Label lbPosCostErr;
    @FXML
    private Label lbDeliver1;
    @FXML
    private Label lbDeliver2;
    @FXML
    private TextField txtYtmFormula1;
    @FXML
    private Label lbYtmFormula1Err;
    @FXML
    private TextField txtYtmFormula2;
    @FXML
    private Label lbYtmFormula2Err;
    private MatchConverter matchCt = new MatchConverter();
    private localSuggest spFormula = new localSuggest("].");
    private ActiveBenchmarkPricingSettings activeBenchmark;
    private StdBondForward refItem;

    @FXML
    private void initialize() {
        this.txtPosCost.setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
        this.spFormula.addPossibleSuggestions(new FormulaModel().values("xbond_ytm"));
        Search.bindAutoCompletion((TextField)this.txtYtmFormula1, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        Search.bindAutoCompletion((TextField)this.txtYtmFormula2, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        this.txtYtmFormula1.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtYtmFormula2.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        if (this.refItem != null) {
            this.txtCode.setText(this.refItem.getCode());
        }
        if (this.activeBenchmark != null) {
            String ytmFormula1;
            Instrument deliver2;
            Double posCost = this.activeBenchmark.getCapitalCost();
            this.txtPosCost.setText(posCost != null ? String.valueOf(posCost) : "");
            Instrument deliver1 = this.activeBenchmark.getBond1();
            if (deliver1 != null) {
                this.lbDeliver1.setText("\u3010" + deliver1.getSecurityId() + "\u3011");
            }
            if ((deliver2 = this.activeBenchmark.getBond2()) != null) {
                this.lbDeliver2.setText("\u3010" + deliver2.getSecurityId() + "\u3011");
            }
            this.txtYtmFormula1.setText((ytmFormula1 = this.activeBenchmark.getBond1YtmFormula()) != null ? ytmFormula1 : "");
            String ytmFormula2 = this.activeBenchmark.getBond2YtmFormula();
            this.txtYtmFormula2.setText(ytmFormula2 != null ? ytmFormula2 : "");
        }
        this.registerCheck();
    }

    protected void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbPosCostErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtPosCost.getText().isEmpty()) {
                this.lbPosCostErr.setText("\u8bf7\u8f93\u5165\u6301\u4ed3\u6210\u672c");
                return false;
            }
            if (StringUtils.parseDouble((String)this.txtPosCost.getText()) == 0.0) {
                this.lbPosCostErr.setText("\u6301\u4ed3\u6210\u672c\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtPosCost.textProperty()}));
        this.registerCheck((Node)this.lbYtmFormula1Err, (ObservableBooleanValue)this.txtYtmFormula1.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbYtmFormula2Err, (ObservableBooleanValue)this.txtYtmFormula2.textProperty().isNotEmpty());
    }

    public void setRefItem(StdBondForward refItem, ActiveBenchmarkPricingSettings activeBenchmark) {
        this.refItem = refItem;
        this.activeBenchmark = activeBenchmark;
    }

    protected boolean isOK(ButtonType bt) {
        this.activeBenchmark.setCapitalCost(Double.valueOf(this.txtPosCost.getText()));
        this.activeBenchmark.setBond1YtmFormula(this.txtYtmFormula1.getText());
        this.activeBenchmark.setBond2YtmFormula(this.txtYtmFormula2.getText());
        return true;
    }
}

