/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondStrategyModel;
import cms.tmx.bond.views.CopyStrategyDialog;
import cms.tmx.bond.views.UpdateXBondStrategyDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.XBondStrategy;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import org.apache.logging.log4j.Logger;

public interface IXBondStrategy {
    public MObjFactory getObjFactory();

    public DialogFactory getDialogFactory();

    public MxAlert getAlert();

    public XBondStrategyModel getModel();

    public Logger getLogger();

    public boolean isLibPane();

    public TableView<XBondStrategy> getTable();

    default public ReadOnlyObjectWrapper<Object> setOperate(XBondStrategy ap) {
        HBox hBox = new HBox();
        boolean canUpdate = false;
        canUpdate = this.isLibPane() ? ap.isTemplate() : ap.getStatus().getRaw().equals("2");
        hBox.setAlignment(Pos.CENTER);
        Button btnUpdate = new Button("      ");
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        if (canUpdate) {
            btnUpdate.setText("\u4fee\u6539");
            btnUpdate.setOnAction(event -> this.update(ap));
        }
        Label label = new Label("  ");
        Button btnShow = new Button("\u67e5\u770b");
        btnShow.getStyleClass().add((Object)"btnOperation");
        btnShow.setOnAction(event -> this.show(ap));
        btnUpdate.visibleProperty().bind((ObservableValue)ap.showUpdateBtnProperty());
        hBox.getChildren().add(0, (Object)btnUpdate);
        hBox.getChildren().add(1, (Object)label);
        hBox.getChildren().add(2, (Object)btnShow);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    default public void update(XBondStrategy strategy) {
        UpdateXBondStrategyDialog obj = (UpdateXBondStrategyDialog)((Object)this.getObjFactory().create(UpdateXBondStrategyDialog.class));
        XBondStrategy st = (XBondStrategy)this.getObjFactory().create(XBondStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u4fee\u6539\u7b56\u7565");
        obj.setDialog(dialog);
        dialog.launch();
        this.getTable().getSelectionModel().select((Object)strategy);
    }

    public void refresh();

    default public void show(XBondStrategy strategy) {
        UpdateXBondStrategyDialog obj = (UpdateXBondStrategyDialog)((Object)this.getObjFactory().create(UpdateXBondStrategyDialog.class));
        Platform.runLater(() -> updateXBondStrategyDialog.vboxAll.setDisable(true));
        XBondStrategy st = (XBondStrategy)this.getObjFactory().create(XBondStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u67e5\u770b\u7b56\u7565");
        dialog.launch();
        this.getTable().getSelectionModel().select((Object)strategy);
    }

    default public void copyNew(XBondStrategy strategy) {
        if (strategy == null) {
            this.getAlert().alert(Alert.AlertType.ERROR, "\u672a\u9009\u62e9\u8981\u590d\u5236\u7684\u7b56\u7565\uff01");
            return;
        }
        CopyStrategyDialog obj = (CopyStrategyDialog)((Object)this.getObjFactory().create(CopyStrategyDialog.class));
        obj.template = this.isLibPane();
        XBondStrategy st = (XBondStrategy)this.getObjFactory().create(XBondStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u590d\u5236\u65b0\u589e\u7b56\u7565");
        obj.setDialog(dialog);
        if (dialog.launch() == ButtonType.OK) {
            this.refresh();
        }
    }
}

