/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.HedgeTaskModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.HedgeTask;
import cms.tmx.utils.StringUtils;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HedgeTaskUpdateDialog
extends DialogObj {
    protected Logger logger = LogManager.getLogger(HedgeTaskUpdateDialog.class);
    @Inject
    private HedgeTaskModel model;
    private HedgeTask order;
    private IntSpinnerCtrl ctrlLeavesQty = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlTimeoutFill = new IntSpinnerCtrl(true, 9, 1);
    private DoubleSpinnerCtrl ctrlStoplossFill = new DoubleSpinnerCtrl(true, 6, 2);
    @FXML
    private TextField taskId;
    @FXML
    private TextField strategyName;
    @FXML
    private Spinner<Double> spnOriginalPrice;
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtPriceCustom;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    @FXML
    private Spinner<Integer> hedgeQty;
    @FXML
    private Spinner<Integer> spnLeavesQty;
    @FXML
    private Spinner<Integer> spnTimeoutFill;
    @FXML
    private Spinner<Double> spnStoplossFill;
    @Inject
    protected MxAlert alert;

    @FXML
    private void initialize() {
        this.initControls();
    }

    private void initControls() {
        this.ctrlLeavesQty.ctrl(this.spnLeavesQty);
        this.ctrlStoplossFill.ctrl(this.spnStoplossFill);
        this.ctrlTimeoutFill.ctrl(this.spnTimeoutFill);
        this.taskId.setText(this.order.getTaskId());
        this.strategyName.setText(this.order.getStrategyName());
        this.txtCode.setText(this.order.getCode());
        if (this.order.getHedgeOrdSide().getRaw().equals("49")) {
            this.radioBuy.setSelected(true);
        } else {
            this.radioSell.setSelected(true);
        }
        this.spnOriginalPrice.getEditor().setText(String.valueOf(this.order.getOrigPrice()));
        this.spnLeavesQty.getEditor().setText(String.valueOf(this.order.getLeavesQty()));
        this.hedgeQty.getEditor().setText(String.valueOf(this.order.getHedgeQty()));
        this.txtPriceCustom.setText(this.order.getHedgePriceCustom());
        this.spnTimeoutFill.getEditor().setText(String.valueOf(this.order.getTimeoutFill()));
        this.spnStoplossFill.getEditor().setText(String.valueOf(this.order.getStoplossFill()));
    }

    public boolean isOK(ButtonType bt) {
        if (this.txtPriceCustom.getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u4ef7\u683c\u516c\u5f0f");
            return false;
        }
        if (this.spnLeavesQty.getEditor().getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u672a\u5bf9\u51b2\u6570\u91cf");
            return false;
        }
        if (this.spnTimeoutFill.getEditor().getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u5b9a\u65f6\u8ffd\u5355\u65f6\u95f4");
            return false;
        }
        if (this.spnStoplossFill.getEditor().getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u5b9a\u65f6\u6b62\u635f\u4ef7\u683c");
            return false;
        }
        HedgeTask task = new HedgeTask();
        task.update((Object)this.order);
        task.setHedgePriceCustom(this.txtPriceCustom.getText());
        task.setLeavesQty(StringUtils.parseInt((String)this.spnLeavesQty.getEditor().getText()));
        task.setStoplossFill(StringUtils.parseDouble((String)this.spnStoplossFill.getEditor().getText()));
        task.setTimeoutFill(StringUtils.parseInt((String)this.spnTimeoutFill.getEditor().getText()));
        try {
            this.model.update(task);
        }
        catch (MException | NumberFormatException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public HedgeTask getOrder() {
        return this.order;
    }

    public void setOrder(HedgeTask order) {
        this.order = order;
    }
}

