/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.HedgeTaskModel;
import cms.tmx.bond.views.HedgeTaskUpdateDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.HedgeTask;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class HedgeTaskPart
extends MxPart {
    MxList<HedgeTask> mlist = new MxList();
    @Inject
    private HedgeTaskModel model;
    @FXML
    private CheckBox onlyUnfinished;
    @FXML
    private TableView<HedgeTask> tableHedge;
    @FXML
    private TextField searchText;
    @Inject
    private MxAlert alert;
    @FXML
    private TableColumn<HedgeTask, Object> operate;
    @FXML
    private TableColumn<HedgeTask, Boolean> selected;
    @FXML
    private TableColumn<HedgeTask, MxNode> strategyType;
    @FXML
    private TableColumn<HedgeTask, MxNode> hedgeStatus;
    @FXML
    private TableColumn<HedgeTask, String> extFundAccntId;
    @FXML
    private TableColumn<HedgeTask, String> extSecAccntId;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    private Predicate<HedgeTask> pd = t -> {
        String txt;
        if (this.onlyUnfinished.isSelected() && t.getHedgeStatus().getRaw().equals("3")) {
            return false;
        }
        String name = t.getStrategyName().toUpperCase();
        return name.contains(txt = this.searchText.getText().toUpperCase());
    };
    @Inject
    private MScheduler scheduler;
    private InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        ArrayList<HedgeTask> newList = new ArrayList<HedgeTask>();
        List<HedgeTask> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.filter(newList, this.pd);
            this.tableHedge.refresh();
        });
    });
    private InvalidationListener lstnModel = ob -> {
        ArrayList<HedgeTask> newList = new ArrayList<HedgeTask>();
        List<HedgeTask> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.update(newList, this.pd);
            this.tableHedge.refresh();
        });
    };
    private boolean ctrlPressed = false;
    private boolean shiftPressed = false;
    private int lastIndex = -1;

    @FXML
    public void initialize() {
        this.setKey();
        this.createTableView();
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.onlyUnfinished.selectedProperty().addListener(this.lstnSearch);
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.onlyUnfinished.selectedProperty().addListener(this.lstnSearch);
    }

    protected void createTableView() {
        this.tableHedge.getColumns().remove(this.strategyType);
        this.tableHedge.getColumns().remove(this.extFundAccntId);
        this.tableHedge.getColumns().remove(this.extSecAccntId);
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableHedge.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        this.selected.setSortable(false);
        TableUtils.initValueFactory(this.tableHedge);
        this.hedgeStatus.setCellFactory(data -> new MxCheckBoxTableCell());
        this.operate.setCellValueFactory(data -> this.setOperate((HedgeTask)data.getValue()));
        this.tableHedge.setPlaceholder((Node)new Label());
        this.tableHedge.setItems(this.mlist.getList());
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    public ReadOnlyObjectWrapper<Object> setOperate(HedgeTask task) {
        Button btnStart = new Button("\u542f\u52a8");
        btnStart.setMinWidth(86.0);
        btnStart.getStyleClass().add((Object)"btnOperation");
        btnStart.setOnAction(event -> this.start(task));
        Button btnStop = new Button("\u505c\u6b62");
        btnStop.setMinWidth(86.0);
        btnStop.getStyleClass().add((Object)"btnOperation");
        btnStop.setOnAction(event -> this.stop(task));
        Button btnUpdate = new Button("\u4fee\u6539");
        btnUpdate.setMinWidth(86.0);
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        btnUpdate.setOnAction(event -> this.update(task));
        Button btnFinish = new Button("\u7f6e\u4e3a\u5df2\u5b8c\u6210");
        btnFinish.setMinWidth(130.0);
        btnFinish.getStyleClass().add((Object)"btnOperation");
        btnFinish.setOnAction(event -> this.finish(task));
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER);
        boolean isManual = task.getHedgeType().is("103");
        if (!isManual && task.getHedgeStatus().getRaw().equals("2")) {
            hBox.getChildren().add((Object)btnStart);
            hBox.getChildren().add((Object)btnUpdate);
        }
        if (!isManual && task.getHedgeStatus().getRaw().equals("1")) {
            hBox.getChildren().add((Object)btnStop);
        }
        if (!task.getHedgeStatus().getRaw().equals("3")) {
            hBox.getChildren().add((Object)btnFinish);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public void start(HedgeTask strategy) {
        this.exe.execute(() -> {
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(strategy.getTaskId());
                RespResult result = this.model.start(list);
                if (result.hasFailed()) {
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, result.getDesc("\u542f\u52a8"));
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
                this.logger.error("\u5bf9\u51b2\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage());
            }
        });
    }

    public void stop(HedgeTask task) {
        this.exe.execute(() -> {
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(task.getTaskId());
                RespResult result = this.model.stop(list);
                if (result.hasFailed()) {
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, result.getDesc("\u505c\u6b62"));
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
                this.logger.error("\u5bf9\u51b2\u4efb\u52a1\u505c\u6b62\u5931\u8d25\uff1a" + e.getMessage());
            }
        });
    }

    public void update(HedgeTask strategy) {
        HedgeTaskUpdateDialog obj = (HedgeTaskUpdateDialog)((Object)this.of.create(HedgeTaskUpdateDialog.class));
        obj.setOrder(strategy);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u5bf9\u51b2\u5355");
        dialog.launch();
    }

    public void finish(HedgeTask strategy) {
        boolean bFinish = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5c06 " + strategy.getTaskId() + " \u7f6e\u4e3a\u5b8c\u6210\uff1f");
        if (!bFinish) {
            return;
        }
        try {
            this.model.finish(strategy);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u5bf9\u51b2\u4efb\u52a1\u7f6e\u4e3a\u5df2\u5b8c\u6210\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @FXML
    public void startAll() {
        ArrayList<String> listId = new ArrayList<String>();
        for (HedgeTask strategy : this.tableHedge.getItems()) {
            if (!strategy.isSelected() || !strategy.getHedgeStatus().getRaw().equals("2")) continue;
            listId.add(strategy.getTaskId());
        }
        if (!this.alert.check(!listId.isEmpty(), Alert.AlertType.ERROR, "\u65e0\u6548\u64cd\u4f5c\uff0c\u8bf7\u52fe\u9009\u6709\u6548\uff08\u505c\u6b62\uff09\u7684\u5bf9\u51b2\u4efb\u52a1\uff01")) {
            return;
        }
        this.exe.execute(() -> {
            try {
                RespResult result = this.model.start(listId);
                if (result.hasFailed()) {
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, result.getDesc("\u542f\u52a8"));
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
                this.logger.error("\u5bf9\u51b2\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage());
            }
        });
    }

    public void stopAll() {
        ArrayList<String> listId = new ArrayList<String>();
        for (HedgeTask strategy : this.tableHedge.getItems()) {
            if (!strategy.isSelected() || !strategy.getHedgeStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getTaskId());
        }
        if (!this.alert.check(!listId.isEmpty(), Alert.AlertType.ERROR, "\u65e0\u6548\u64cd\u4f5c\uff0c\u8bf7\u52fe\u9009\u6709\u6548\uff08\u6267\u884c\u4e2d\uff09\u7684\u5bf9\u51b2\u4efb\u52a1\uff01")) {
            return;
        }
        this.exe.execute(() -> {
            try {
                RespResult result = this.model.stop(listId);
                if (result.hasFailed()) {
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, result.getDesc("\u505c\u6b62"));
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
                this.logger.error("\u5bf9\u51b2\u4efb\u52a1\u505c\u6b62\u5931\u8d25\uff1a" + e.getMessage());
            }
        });
    }

    public void finishAll() {
        String info;
        LinkedList<HedgeTask> list = new LinkedList<HedgeTask>();
        for (HedgeTask task : this.tableHedge.getItems()) {
            if (!task.isSelected() || !task.getHedgeStatus().getRaw().equals("2")) continue;
            list.add(task);
        }
        Alert.AlertType type = list.isEmpty() ? Alert.AlertType.ERROR : Alert.AlertType.CONFIRMATION;
        String string = info = list.isEmpty() ? "\u65e0\u6548\u64cd\u4f5c\uff0c\u8bf7\u52fe\u9009\u6709\u6548\uff08\u505c\u6b62\uff09\u7684\u5bf9\u51b2\u4efb\u52a1\uff01" : "\u786e\u8ba4\u5c06\u52fe\u9009\u90e8\u5206\u7f6e\u4e3a\u5b8c\u6210\uff1f";
        if (!this.alert.alert(type, info)) {
            return;
        }
        RespResult result = new RespResult();
        for (HedgeTask strategy : this.tableHedge.getItems()) {
            if (!strategy.isSelected() || strategy.getHedgeStatus().getRaw().equals("3")) continue;
            try {
                this.model.finish(strategy);
                result.incrementSuccessed();
            }
            catch (MException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                result.incrementFailed(String.valueOf(strategy.getTaskId()) + " : " + e.getMessage());
            }
        }
        if (result.hasFailed()) {
            this.alert.alert(Alert.AlertType.ERROR, result.getDesc("\u7f6e\u4e3a\u5df2\u5b8c\u6210"));
        }
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableHedge, (String)"\u5bf9\u51b2\u4efb\u52a1\u67e5\u8be2", (int)1, (int)(this.tableHedge.getColumns().size() - 1));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableHedge, (int)1, (int)0);
    }

    private void setKey() {
        this.tableHedge.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = true;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = true;
                HedgeTask strategy = (HedgeTask)this.tableHedge.getSelectionModel().getSelectedItem();
                if (strategy != null) {
                    this.lastIndex = this.tableHedge.getItems().indexOf((Object)strategy);
                }
            }
        });
        this.tableHedge.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = false;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = false;
            }
        });
        this.tableHedge.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            block8: {
                HedgeTask strategy = (HedgeTask)this.tableHedge.getSelectionModel().getSelectedItem();
                if (strategy == null) break block8;
                boolean isSelect = strategy.isSelected();
                if (this.ctrlPressed) {
                    strategy.setSelected(!isSelect);
                } else {
                    this.tableHedge.getItems().forEach(item -> {
                        if (item.equals((Object)strategy)) {
                            item.setSelected(true);
                        } else {
                            item.setSelected(false);
                        }
                    });
                }
                if (this.shiftPressed) {
                    if (this.lastIndex == -1) {
                        return;
                    }
                    int index = this.tableHedge.getItems().indexOf((Object)strategy);
                    if (index > this.lastIndex) {
                        int i = this.lastIndex;
                        while (i <= index) {
                            ((HedgeTask)this.tableHedge.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    } else {
                        int i = index;
                        while (i <= this.lastIndex) {
                            ((HedgeTask)this.tableHedge.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    }
                }
            }
        });
    }

    private class MxCheckBoxTableCell
    extends TableCell<HedgeTask, MxNode> {
        private final PseudoClass HIGHLIGHT = PseudoClass.getPseudoClass((String)"highlight");

        private MxCheckBoxTableCell() {
        }

        public void updateItem(MxNode item, boolean empty) {
            super.updateItem((Object)item, empty);
            String text = null;
            if (!empty) {
                HedgeTask task = (HedgeTask)HedgeTask.class.cast(this.getTableRow().getItem());
                boolean finish = task.getHedgeStatus().getRaw().equals("3");
                this.getTableRow().pseudoClassStateChanged(this.HIGHLIGHT, !finish);
                text = task.getHedgeStatus().getValue();
            }
            this.setText(text);
        }
    }
}

