/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.FormulaModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.formatters.LocalFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.MatchConverter;
import cms.tmx.control.search.Search;
import cms.tmx.control.search.localSuggest;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.http.api.strategy.dto.HedgeBenchmarkPricingSettings;
import cms.tmx.utils.StringUtils;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class HedgeBenchmarkDialog
extends DialogObj {
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtPosCost;
    @FXML
    private Label lbPosCostErr;
    @FXML
    private TextField txtDealFormula;
    @FXML
    private Label lbDealFormulaErr;
    @FXML
    private Label lbSpread;
    @FXML
    private TextField txtSpread;
    private MatchConverter matchCt = new MatchConverter();
    private localSuggest spFormula = new localSuggest("].");
    private HedgeBenchmarkPricingSettings hedgeBenchmark;
    private RefItem refItem;

    @FXML
    private void initialize() {
        this.txtPosCost.setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
        this.spFormula.addPossibleSuggestions(new FormulaModel().values("xswap"));
        Search.bindAutoCompletion((TextField)this.txtDealFormula, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        this.txtDealFormula.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtSpread.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 3, 2)));
        if (this.refItem != null) {
            this.txtCode.setText(this.refItem.getCode());
        }
        if (this.hedgeBenchmark != null) {
            Double posCost = this.hedgeBenchmark.getCapitalCost();
            this.txtPosCost.setText(posCost != null ? String.valueOf(posCost) : "");
            String dealFormula = this.hedgeBenchmark.getFormula();
            this.txtDealFormula.setText(dealFormula != null ? dealFormula : "");
            String spreadSymbol = this.lbSpread.getText();
            spreadSymbol = spreadSymbol.replace("\u53ef\u4ea4\u5272\u52382", this.hedgeBenchmark.getBond2().getSecurityId());
            spreadSymbol = spreadSymbol.replace("\u53ef\u4ea4\u5272\u52381", this.hedgeBenchmark.getBond1().getSecurityId());
            this.lbSpread.setText(spreadSymbol);
            Double spread = this.hedgeBenchmark.getSpread();
            this.txtSpread.setText(spread != null ? String.valueOf(spread) : "");
        }
        this.registerCheck();
    }

    protected void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbPosCostErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtPosCost.getText().isEmpty()) {
                this.lbPosCostErr.setText("\u8bf7\u8f93\u5165\u6301\u4ed3\u6210\u672c");
                return false;
            }
            if (StringUtils.parseDouble((String)this.txtPosCost.getText()) == 0.0) {
                this.lbPosCostErr.setText("\u6301\u4ed3\u6210\u672c\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtPosCost.textProperty()}));
        this.registerCheck((Node)this.lbDealFormulaErr, (ObservableBooleanValue)this.txtDealFormula.textProperty().isNotEmpty());
    }

    public void setRefItem(StdBondForward refItem, HedgeBenchmarkPricingSettings hedgeBenchmark) {
        this.refItem = refItem;
        this.hedgeBenchmark = hedgeBenchmark;
    }

    protected boolean isOK(ButtonType bt) {
        this.hedgeBenchmark.setCapitalCost(Double.valueOf(StringUtils.parseDouble((String)this.txtPosCost.getText())));
        this.hedgeBenchmark.setFormula(this.txtDealFormula.getText());
        this.hedgeBenchmark.setSpread(Double.valueOf(StringUtils.parseDouble((String)this.txtSpread.getText())));
        return true;
    }
}

