/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.ConvertibleBondTradeModel;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.models.CcsTradeModel;
import cms.tmx.trade.views.CcsTradePart;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javax.inject.Inject;

public class ConvertibleBondTradePart
extends CcsTradePart {
    public static final int SECURITY_TYPE = 1;
    private ConvertibleBondTradeModel model;
    @Inject
    private IRefDataMng refMng;
    @FXML
    private Label lbErrorMsg;
    private double qtyUpperLimit = 0.0;

    @Inject
    public ConvertibleBondTradePart() {
    }

    @FXML
    public void initialize() {
        super.initialize();
        this.lbUpLimit.setVisible(false);
        this.lbDownLimit.setVisible(false);
        this.ctrlCount.setUnit(1);
    }

    @FXML
    public void order() {
        boolean confirm = false;
        for (CcsAccountDistribution acc : this.ccsModel.getAccDisModel().getValidSecAcc()) {
            if (!((double)acc.getCount() > this.qtyUpperLimit)) continue;
            confirm = true;
            break;
        }
        if (confirm && !this.alert.alert(Alert.AlertType.CONFIRMATION, "\u8d85\u8fc7\u5355\u7b14\u59d4\u6258\u4e0a\u9650" + this.qtyUpperLimit + ", \u662f\u5426\u7ee7\u7eed\u7533\u8d2d\uff1f")) {
            return;
        }
        super.order();
    }

    protected Collection<RefItem> getRefItems() {
        ArrayList<RefItem> list = new ArrayList<RefItem>();
        for (RefItem item : this.refMng.getItems(new String[]{"OIS"})) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u53ef\u8f6c\u503a\u7533\u8d2d")) continue;
            list.add((RefItem)((ConvertibleBond)item));
        }
        return list;
    }

    protected void onSecurityChange(String newText) {
        Platform.runLater(() -> {
            super.onSecurityChange(newText);
            if (this.model.isValidRef()) {
                if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                    this.lbUnit.setText("\u624b");
                    this.ctrlCount.setUnit(1);
                } else {
                    this.lbUnit.setText("\u5f20");
                    this.ctrlCount.setUnit(10);
                }
                RefItem item = this.refMng.getItem("OIS", this.model.getMI().getRefItem().getMarket(), this.model.getSecurity());
                if (item != null && item instanceof ConvertibleBond) {
                    ConvertibleBond bond = (ConvertibleBond)ConvertibleBond.class.cast(item);
                    this.qtyUpperLimit = bond.getQtyUpperLimit();
                    this.model.setPrice(bond.getSubPrice());
                }
            }
        });
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("");
    }

    public CcsTradeModel createModel() {
        this.model = (ConvertibleBondTradeModel)((Object)this.of.create(ConvertibleBondTradeModel.class));
        return this.model;
    }

    public ITradeModel getModel() {
        return this.model;
    }
}

