/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.control.table.TableUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cmx.tmx.data.IRefDataMng;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class ConvertibleBondInfoPart
extends MxPart {
    private MxList<RefItem> mxList = new MxList();
    @FXML
    private TableView<RefItem> tableBond;
    @FXML
    private TableColumn<ConvertibleBond, String> code;
    @FXML
    private TableColumn<ConvertibleBond, String> market;
    @FXML
    protected TextField searchText;
    @Inject
    private IRefDataMng refMng;
    private List<RefItem> listInfo = new LinkedList<RefItem>();
    private Predicate<RefItem> pd = en -> {
        String text = this.searchText.getText().trim();
        if (en.getCode().contains(text)) {
            return true;
        }
        return en.getName().contains(text);
    };
    private InvalidationListener lstnSearch = ob -> Platform.runLater(() -> this.mxList.filter(this.listInfo, this.pd));
    private InvalidationListener lstnRefMng = ob -> this.refresh();

    @FXML
    public void initialize() {
        this.refMng.changedProperty().addListener(this.lstnRefMng);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.createTableView();
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.refMng.changedProperty().removeListener(this.lstnRefMng);
    }

    @FXML
    public void refresh() {
        this.listInfo.clear();
        for (RefItem item : this.refMng.getItems(new String[]{"OIS"})) {
            ConvertibleBond bond = (ConvertibleBond)item;
            if (!bond.getSubType().equals("\u53ef\u8f6c\u503a\u7533\u8d2d")) continue;
            this.listInfo.add((RefItem)bond);
        }
        Platform.runLater(() -> Platform.runLater(() -> this.mxList.filter(this.listInfo, this.pd)));
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tableBond);
        this.market.setCellValueFactory(data -> {
            String market = ((ConvertibleBond)data.getValue()).getMarket();
            SimpleStringProperty ssp = new SimpleStringProperty("");
            if (market.equals("XSHG")) {
                ssp.set("\u4e0a\u4ea4\u6240");
            } else if (market.equals("XSHE")) {
                ssp.set("\u6df1\u4ea4\u6240");
            }
            return ssp;
        });
        this.tableBond.setPlaceholder((Node)new Label());
        this.tableBond.setItems(this.mxList.getList());
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableBond);
    }
}

