/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.BondTradeModel;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.core.MEventHandler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.models.CcsTradeModel;
import cms.tmx.trade.views.CcsTradePart;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.fxml.FXML;
import javafx.scene.control.Spinner;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class BondTradePart
extends CcsTradePart {
    public static final int SECURITY_TYPE = 1;
    private BondTradeModel model;
    @FXML
    protected Spinner<Double> parValueSpn;
    protected MEventHandler handler = event -> {
        if (!this.isVisible()) {
            return;
        }
        if (this.autoCompletionNormal == null) {
            return;
        }
        Platform.runLater(() -> {
            String secCode = event.getStr("sec_code");
            String market = event.getStr("tMarket");
            if (!"XSHE".equals(market) && !"XSHG".equals(market)) {
                return;
            }
            this.txtCode.setText(secCode);
            RefItem item = null;
            for (RefItem it : this.getRefItems()) {
                if (!"BOND".equals(it.getType()) && !"REPO".equals(it.getType()) || !it.getCode().equals(secCode) || !it.getMarket().equals(market)) continue;
                item = it;
            }
            this.txtCode.setUserData(item);
            this.autoCompletionNormal.setChange(secCode);
            this.onSecurityChange(event.getStr("sec_code"));
        });
    };

    @Inject
    public BondTradePart() {
    }

    @FXML
    public void initialize() {
        super.initialize();
        this.lbUpLimit.setVisible(false);
        this.lbDownLimit.setVisible(false);
        this.ctrlCount.setUnit(1);
        MxBindings.bindSD((Property)this.parValueSpn.getEditor().textProperty(), (ObservableNumberValue)this.getBondModel().totalParValueProperty(), (int)2);
        this.parValueSpn.disableProperty().bindBidirectional((Property)this.quantitySpn.disableProperty());
        this.parValueSpn.setEditable(false);
        SpinnerUtils.arrowsStyle(this.parValueSpn);
        this.es.subscribe("input.bond.trade", this.handler);
    }

    @PreDestroy
    protected void close() {
        super.close();
        this.es.unSubscribe("input.bond.trade", this.handler);
    }

    protected void onSecurityChange(String newText) {
        super.onSecurityChange(newText);
        if (this.getBondModel().isValidRef()) {
            if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                this.lbUnit.setText("\u624b");
                this.ctrlCount.setUnit(1);
            } else {
                this.lbUnit.setText("\u5f20");
                this.ctrlCount.setUnit(10);
            }
        }
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("");
    }

    public CcsTradeModel createModel() {
        this.model = (BondTradeModel)((Object)this.of.create(BondTradeModel.class));
        return this.model;
    }

    public ITradeModel getModel() {
        return this.model;
    }

    public void initUserPre() {
        this.preModel.setType("3", "200003");
        super.initUserPre();
    }

    protected BondTradeModel getBondModel() {
        return this.model;
    }
}

