/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.BondSpecialTradeModel;
import cms.tmx.bond.models.BondTradeModel;
import cms.tmx.bond.views.BondTradePart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.models.CcsTradeModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Control;

public class BondSpecialTradePart
extends BondTradePart {
    private BondSpecialTradeModel model;

    public BondSpecialTradePart() {
        this.path = "BondTradePart.fxml";
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.cmbAccFilter.setVisible(false);
    }

    @Override
    protected void onSecurityChange(String newText) {
        super.onSecurityChange(newText);
        if (this.model.isValidRef()) {
            if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
                this.lbUnit.setText("\u624b");
                this.ctrlCount.setUnit(1);
            } else {
                this.lbUnit.setText("\u5f20");
                this.ctrlCount.setUnit(10);
            }
            this.model.selectSecAcc();
        }
    }

    protected void onBSChange(Boolean old, Boolean now) {
        Platform.runLater(() -> {
            Date time = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            logger.info(String.valueOf(df.format(time)) + "\u5f00\u59cb\u4e70\u5356\u5207\u6362");
            if (now.booleanValue()) {
                this.btnOrder.setText("\u4e70\u5165");
                this.lbCan.setText("\u53ef\u4e70");
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                logger.info("\u6267\u884c\u4e70");
            } else {
                this.btnOrder.setText("\u5356\u51fa");
                this.lbCan.setText("\u53ef\u5356");
                CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
                logger.info("\u6267\u884c\u5356");
                this.model.getAccDisModel().selectAllSecAcc();
            }
            logger.info("\u6700\u7ec8\u7ed3\u679c\u663e\u793a" + this.btnOrder.getText());
            this.ctTradePanel.layout();
        });
    }

    @Override
    public CcsTradeModel createModel() {
        this.model = (BondSpecialTradeModel)((Object)this.of.create(BondSpecialTradeModel.class));
        return this.model;
    }

    @Override
    public ITradeModel getModel() {
        return this.model;
    }

    @Override
    protected BondTradeModel getBondModel() {
        return this.model;
    }
}

