/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.BondUtils;
import cms.tmx.bond.models.BondForwardPricingModel;
import cms.tmx.bond.views.AddBondForwardDialog;
import cms.tmx.bond.views.UpdateBondForwardDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.EditTableCellString;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.strategy.BondStrategy;
import cms.tmx.http.api.OpStatus;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BondForwardPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BondForwardPart.class);
    @FXML
    private TableView<BondStrategy> tableBond;
    private MxList<BondStrategy> mxList = new MxList();
    @FXML
    private TableColumn<BondStrategy, String> securityId;
    @FXML
    private TableColumn<BondStrategy, MxNode> status;
    @FXML
    private TableColumn<BondStrategy, Object> operate;
    @FXML
    private TableColumn<BondStrategy, String> refBidPx;
    @FXML
    private TableColumn<BondStrategy, String> refOfferPx;
    @FXML
    private TableColumn<BondStrategy, Number> irr;
    @FXML
    private TableColumn<BondStrategy, String> activeSecurity;
    @FXML
    private TableColumn<BondStrategy, String> activeBidYield;
    @FXML
    private TableColumn<BondStrategy, String> activeOfrYield;
    @FXML
    private TableColumn<BondStrategy, Number> activeBidDirtyPx;
    @FXML
    private TableColumn<BondStrategy, Number> activeBidCleanPx;
    @FXML
    private TableColumn<BondStrategy, Number> activeOfrDirtyPx;
    @FXML
    private TableColumn<BondStrategy, Number> activeOfrCleanPx;
    @FXML
    private TableColumn<BondStrategy, Number> activeInterest;
    @FXML
    private TableColumn<BondStrategy, String> inactiveSecurity;
    @FXML
    private TableColumn<BondStrategy, String> inactiveBidYield;
    @FXML
    private TableColumn<BondStrategy, String> inactiveOfrYield;
    @FXML
    private TableColumn<BondStrategy, Number> spread;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveBidDirtyPxA;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveBidCleanPxA;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveOfrDirtyPxA;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveOfrCleanPxA;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveBidDirtyPxB;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveBidCleanPxB;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveOfrDirtyPxB;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveOfrCleanPxB;
    @FXML
    private TableColumn<BondStrategy, Number> inactiveInterest;
    @Inject
    private BondForwardPricingModel model;
    @Inject
    protected MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MEventService es;
    @Inject
    private MxAlert alert;
    SecSuggest.StrSuggest suggestBid = SecSuggest.getStrSuggest();
    SecSuggest.StrSuggest suggestOffer = SecSuggest.getStrSuggest();
    ObservableList<String> listBid = FxUtils.newList();
    ObservableList<String> listOffer = FxUtils.newList();
    private String last = null;
    private MEventHandler handler = event -> {
        this.last = (String)event.get((Object)"id");
    };
    private InvalidationListener listener = ob -> Platform.runLater(() -> {
        this.mxList.update(this.model.getList());
        this.tableBond.refresh();
        if (this.last != null) {
            for (BondStrategy s : this.mxList.getList()) {
                if (!this.last.equals(s.getContextId())) continue;
                this.tableBond.getSelectionModel().select((Object)s);
                break;
            }
        }
    });

    @FXML
    public void initialize() {
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        this.createTableView();
        this.refresh();
        this.es.subscribe("last.id", this.handler);
        this.listBid.add((Object)"BID_\u6700\u4f18");
        this.listBid.add((Object)"BID_\u56fd\u9645");
        this.listBid.add((Object)"BID_\u56fd\u5229");
        this.listBid.add((Object)"BID_\u4fe1\u5510");
        this.listBid.add((Object)"BID_\u4e2d\u8bda");
        this.listBid.add((Object)"BID_\u5e73\u5b89");
        this.suggestBid.addPossibleSuggestions(this.listBid);
        this.listOffer.add((Object)"OFR_\u6700\u4f18");
        this.listOffer.add((Object)"OFR_\u56fd\u9645");
        this.listOffer.add((Object)"OFR_\u56fd\u5229");
        this.listOffer.add((Object)"OFR_\u4fe1\u5510");
        this.listOffer.add((Object)"OFR_\u4e2d\u8bda");
        this.listOffer.add((Object)"OFR_\u5e73\u5b89");
        this.suggestOffer.addPossibleSuggestions(this.listOffer);
    }

    @FXML
    private void refresh() {
        try {
            this.model.query();
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            e.printStackTrace();
        }
    }

    @FXML
    public void add() {
        AddBondForwardDialog bond = (AddBondForwardDialog)((Object)this.of.create(AddBondForwardDialog.class));
        MxDialog dialog = this.df.create((DialogObj)bond, "\u65b0\u589e\u6807\u503a\u8fdc\u671f");
        dialog.launch();
        this.refresh();
    }

    private void createTableView() {
        CheckBox checkBox = new CheckBox();
        checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getList();
            synchronized (observableList) {
                this.mxList.getList().stream().forEach(item -> item.setSelected(now.booleanValue()));
            }
        });
        this.operate.setCellValueFactory(data -> this.setOperate((BondStrategy)data.getValue()));
        this.securityId.setCellValueFactory(data -> ((BondStrategy)data.getValue()).instSecIdProperty());
        this.status.setCellValueFactory(data -> ((BondStrategy)data.getValue()).statusProperty());
        this.refBidPx.setCellValueFactory(data -> {
            String str = String.valueOf(((BondStrategy)data.getValue()).getRefBidPx());
            if (!((BondStrategy)data.getValue()).getProjectBid().isEmpty()) {
                str = String.valueOf(str) + "(" + ((BondStrategy)data.getValue()).getProjectBid() + ")";
            }
            return new SimpleStringProperty(str);
        });
        this.refBidPx.setCellFactory(cell -> new PriceCell(true));
        this.refOfferPx.setCellFactory(cell -> new PriceCell(false));
        this.irr.setCellValueFactory(data -> ((BondStrategy)data.getValue()).irrProperty());
        this.refOfferPx.setCellValueFactory(data -> {
            String str = String.valueOf(((BondStrategy)data.getValue()).getRefOfferPx());
            if (!((BondStrategy)data.getValue()).getProjectOffer().isEmpty()) {
                str = String.valueOf(str) + "(" + ((BondStrategy)data.getValue()).getProjectOffer() + ")";
            }
            return new SimpleStringProperty(str);
        });
        this.activeSecurity.setCellValueFactory(data -> ((BondStrategy)data.getValue()).activeSecIdProperty());
        this.activeBidYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((BondStrategy)data.getValue()).getActiveBidYieldCalc())));
        this.activeOfrYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((BondStrategy)data.getValue()).getActiveOfferYieldCalc())));
        this.activeBidDirtyPx.setCellValueFactory(data -> ((BondStrategy)data.getValue()).activeBidDirtyPxProperty());
        this.activeBidCleanPx.setCellValueFactory(data -> ((BondStrategy)data.getValue()).activeBidCleanPxProperty());
        this.activeOfrDirtyPx.setCellValueFactory(data -> ((BondStrategy)data.getValue()).activeOfferDirtyPxProperty());
        this.activeOfrCleanPx.setCellValueFactory(data -> ((BondStrategy)data.getValue()).activeOfferCleanPxProperty());
        this.activeInterest.setCellValueFactory(data -> ((BondStrategy)data.getValue()).activeInterestProperty());
        this.inactiveSecurity.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveSecIdProperty());
        this.inactiveBidYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((BondStrategy)data.getValue()).getInactiveBidYieldCalc())));
        this.inactiveOfrYield.setCellValueFactory(data -> new SimpleStringProperty(String.valueOf(((BondStrategy)data.getValue()).getInactiveOfferYieldCalc())));
        this.inactiveBidDirtyPxA.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveBidDirtyPxAProperty());
        this.inactiveBidCleanPxA.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveBidCleanPxAProperty());
        this.inactiveOfrDirtyPxA.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveOfferDirtyPxAProperty());
        this.inactiveOfrCleanPxA.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveOfferCleanPxAProperty());
        this.inactiveBidCleanPxB.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveBidCleanPxBProperty());
        this.inactiveBidDirtyPxB.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveBidDirtyPxBProperty());
        this.inactiveOfrCleanPxB.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveOfferCleanPxBProperty());
        this.inactiveOfrDirtyPxB.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveOfferDirtyPxBProperty());
        this.inactiveInterest.setCellValueFactory(data -> ((BondStrategy)data.getValue()).inactiveInterestProperty());
        this.spread.setCellValueFactory(data -> ((BondStrategy)data.getValue()).spreadProperty());
        this.tableBond.setPlaceholder((Node)new Label());
        this.tableBond.setItems(this.mxList.getList());
        this.activeBidYield.setCellFactory(cell -> new YieldSource(true, true));
        this.activeOfrYield.setCellFactory(cell -> new YieldSource(true, false));
        this.inactiveBidYield.setCellFactory(cell -> new YieldSource(false, true));
        this.inactiveOfrYield.setCellFactory(cell -> new YieldSource(false, false));
        this.irr.setCellFactory(cell -> new EditIrr());
        this.tableBond.setEditable(true);
    }

    public ReadOnlyObjectWrapper<Object> setOperate(BondStrategy ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Button btnStart = new Button(" ");
        btnStart.getStyleClass().add((Object)"btnOperation");
        if (!ap.getStatus().getRaw().equals("2")) {
            btnStart.setText("\u6267\u884c");
            btnStart.setOnAction(event -> {
                try {
                    OpStatus status = this.model.start(ap.getContextId());
                    if (status.getStatus() == 1) {
                        this.alert.alert(Alert.AlertType.INFORMATION, "\u6267\u884c\u6210\u529f");
                    } else {
                        this.alert.alert(Alert.AlertType.INFORMATION, "\u6267\u884c\u5931\u8d25\uff1a" + status.getReason());
                    }
                }
                catch (MException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                this.refresh();
            });
        }
        Button btnStop = new Button(" ");
        btnStop.getStyleClass().add((Object)"btnOperation");
        if (ap.getStatus().getRaw().equals("2")) {
            btnStop.setText("\u505c\u6b62");
            btnStop.setOnAction(event -> {
                try {
                    OpStatus status = this.model.stop(ap);
                    if (status.getStatus() == 1) {
                        this.alert.alert(Alert.AlertType.INFORMATION, "\u505c\u6b62\u6210\u529f");
                    } else {
                        this.alert.alert(Alert.AlertType.INFORMATION, "\u505c\u6b62\u5931\u8d25\uff1a" + status.getReason());
                    }
                }
                catch (MException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                this.refresh();
            });
        }
        Button btnUpdate = new Button("\u4fee\u6539");
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        btnUpdate.setOnAction(event -> {
            UpdateBondForwardDialog dialog = (UpdateBondForwardDialog)((Object)((Object)this.of.create(UpdateBondForwardDialog.class)));
            dialog.strategy = ap;
            MxDialog d = this.df.create((DialogObj)dialog, "\u4fee\u6539\u7b56\u7565");
            d.launch();
            this.refresh();
        });
        Button btnDelete = new Button("\u5220\u9664");
        btnDelete.getStyleClass().add((Object)"btnOperation");
        btnDelete.setOnAction(event -> {
            boolean comfirm = this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u8981\u5220\u9664" + ap.getInstSecId() + "\u5417?");
            if (!comfirm) {
                return;
            }
            try {
                OpStatus status = this.model.delete(ap);
                this.refresh();
                if (status.getStatus() == 1) {
                    this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f");
                } else {
                    this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u5931\u8d25\uff1a" + status.getReason());
                }
            }
            catch (MException e) {
                e.printStackTrace();
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
        hBox.getChildren().add(0, (Object)btnStart);
        hBox.getChildren().add(1, (Object)btnStop);
        hBox.getChildren().add(2, (Object)btnUpdate);
        hBox.getChildren().add(3, (Object)btnDelete);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    class EditIrr
    extends EditTableCell<BondStrategy> {
        EditIrr() {
        }

        public void startEdit() {
            BondForwardPricingModel.isEditting = true;
            super.startEdit();
        }

        protected void loseFocus() {
            try {
                try {
                    super.loseFocus();
                    BondStrategy bond = (BondStrategy)this.getTableRow().getItem();
                    BondForwardPart.this.model.update(bond);
                    BondForwardPart.this.last = bond.getContextId();
                    BondForwardPart.this.refresh();
                }
                catch (MException | Exception e) {
                    logger.error(e.getMessage());
                    BondForwardPart.this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    BondForwardPricingModel.isEditting = false;
                }
            }
            finally {
                BondForwardPricingModel.isEditting = false;
            }
        }
    }

    public class PriceCell
    extends TableCell<BondStrategy, String> {
        private Label label = new Label();
        boolean isBuy = true;

        public PriceCell(boolean isBuy) {
            this.isBuy = isBuy;
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                this.label.setText(value);
                if (this.isBuy) {
                    CssUtils.makeRise((Control)this.label);
                } else {
                    CssUtils.makeFall((Control)this.label);
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    class YieldSource
    extends EditTableCellString<BondStrategy> {
        boolean isActive = true;
        boolean isBid = true;
        String tips = "";

        YieldSource(boolean isActive, boolean isBid) {
            this.isActive = isActive;
            this.isBid = isBid;
        }

        public void startEdit() {
            BondForwardPricingModel.isEditting = true;
            super.startEdit();
            this.textField.setText(this.tips);
            Search.bindAutoCompletion((TextField)this.textField, (Callback)(this.isBid ? BondForwardPart.this.suggestBid : BondForwardPart.this.suggestOffer));
        }

        protected void loseFocus() {
            try {
                super.loseFocus();
                BondStrategy bond = (BondStrategy)this.getTableRow().getItem();
                String text = this.textField.getText().trim();
                boolean isDouble = BondUtils.isMatch(text);
                if (!isDouble) {
                    if (this.isBid && !BondForwardPart.this.listBid.contains((Object)text)) {
                        BondForwardPart.this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u5185\u5bb9(" + text + ")\u683c\u5f0f\u4e0d\u5bf9, \u4f8b(0.1, BID_\u6700\u4f18)");
                        return;
                    }
                    if (!this.isBid && !BondForwardPart.this.listOffer.contains((Object)text)) {
                        BondForwardPart.this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u5185\u5bb9(" + text + ")\u683c\u5f0f\u4e0d\u5bf9, \u4f8b(0.1, OFR_\u6700\u4f18)");
                        return;
                    }
                }
                try {
                    if (this.isActive) {
                        if (this.isBid) {
                            if (isDouble) {
                                double yield = Double.parseDouble(text);
                                bond.setActiveBidYield(yield);
                                bond.setActiveBidSource("");
                            } else {
                                bond.setActiveBidYield(0.0);
                                bond.setActiveBidSource(text);
                            }
                        } else if (isDouble) {
                            double yield = Double.parseDouble(text);
                            bond.setActiveOfferYield(yield);
                            bond.setActiveOfferSource("");
                        } else {
                            bond.setActiveOfferYield(0.0);
                            bond.setActiveOfferSource(text);
                        }
                    } else if (this.isBid) {
                        if (isDouble) {
                            double yield = Double.parseDouble(text);
                            bond.setInactiveBidYield(yield);
                            bond.setInactiveBidSource("");
                        } else {
                            bond.setInactiveBidYield(0.0);
                            bond.setInactiveBidSource(text);
                        }
                    } else if (isDouble) {
                        double yield = Double.parseDouble(text);
                        bond.setInactiveOfferYield(yield);
                        bond.setInactiveOfferSource("");
                    } else {
                        bond.setInactiveOfferYield(0.0);
                        bond.setInactiveOfferSource(text);
                    }
                    BondForwardPart.this.model.update(bond);
                    BondForwardPart.this.last = bond.getContextId();
                    BondForwardPart.this.refresh();
                }
                catch (MException | Exception e) {
                    logger.error(e.getMessage());
                }
            }
            finally {
                BondForwardPricingModel.isEditting = false;
            }
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            BondStrategy bond = (BondStrategy)this.getTableRow().getItem();
            if (bond == null) {
                return;
            }
            if (this.isActive) {
                if (this.isBid) {
                    if (!bond.getActiveBidSource().isEmpty()) {
                        this.tips = bond.getActiveBidSource();
                    }
                    if (bond.getActiveBidYield() > 0.0) {
                        this.tips = String.valueOf(bond.getActiveBidYield());
                    }
                } else {
                    if (!bond.getActiveOfferSource().isEmpty()) {
                        this.tips = bond.getActiveOfferSource();
                    }
                    if (bond.getActiveOfferYield() > 0.0) {
                        this.tips = String.valueOf(bond.getActiveOfferYield());
                    }
                }
            } else if (this.isBid) {
                if (!bond.getInactiveBidSource().isEmpty()) {
                    this.tips = bond.getInactiveBidSource();
                }
                if (bond.getInactiveBidYield() > 0.0) {
                    this.tips = String.valueOf(bond.getInactiveBidYield());
                }
            } else {
                if (!bond.getInactiveOfferSource().isEmpty()) {
                    this.tips = bond.getInactiveOfferSource();
                }
                if (bond.getInactiveOfferYield() > 0.0) {
                    this.tips = String.valueOf(bond.getInactiveOfferYield());
                }
            }
            this.setTooltip(new Tooltip(this.tips));
        }
    }
}

