/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.SecFormatter;
import cms.tmx.bond.models.BondForwardPricingModel;
import cms.tmx.bond.models.StdBondForwardModel;
import cms.tmx.bond.views.StdSecSuggest;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.Formatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.javafx.utils.FxUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BondForwardDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(BondForwardDialog.class);
    @FXML
    protected TextField txtSecurity;
    @FXML
    protected Spinner<Double> spnIrr;
    @FXML
    protected TextField txtActiveSecurity;
    @FXML
    protected ComboBox<String> cmbActiveBidYtm;
    @FXML
    protected ComboBox<String> cmbActiveOfferYtm;
    @FXML
    protected TextField txtInactiveSecurity;
    @FXML
    protected ComboBox<String> cmbInactiveBidYtm;
    @FXML
    protected ComboBox<String> cmbInactiveOfferYtm;
    @FXML
    protected Spinner<Double> spnDiff;
    @FXML
    protected Label lbSecurityErr;
    @FXML
    protected Label lbIrrErr;
    @FXML
    protected Label lbActiveBidYtmErr;
    @FXML
    protected Label lbActiveOfferYtmErr;
    @FXML
    protected Label lbInactiveBidYtmErr;
    @FXML
    protected Label lbInactiveOfferYtmErr;
    @FXML
    protected Label lbDiffErr;
    @FXML
    protected Label lbPercentActiveBid;
    @FXML
    protected Label lbPercentInactiveBid;
    @FXML
    protected Label lbPercentActiveOffer;
    @FXML
    protected Label lbPercentInactiveOffer;
    @Inject
    protected BondForwardPricingModel priceModel;
    @Inject
    protected StdBondForwardModel model;
    private SecSuggest.StrSuggest suggestFundBid = SecSuggest.getStrSuggest();
    private SecSuggest.StrSuggest suggestFundOffer = SecSuggest.getStrSuggest();
    @Inject
    protected MxAlert alert;
    @Inject
    protected IRefDataMng ref;
    @Inject
    protected MEventService es;
    @Inject
    protected MObjFactory of;
    private StdSecSuggest suggest = new StdSecSuggest();
    private Collection<RefItem> codeList = new ArrayList<RefItem>();
    protected RefItem refItem = null;
    public Map<String, List<StdBondForwardDeliver>> map = new HashMap<String, List<StdBondForwardDeliver>>();
    public Map<String, StdBondForward> mapStdBond = new HashMap<String, StdBondForward>();
    protected DoubleSpinnerCtrl ctrlSpnIrr = new DoubleSpinnerCtrl(true, 12, 4);
    protected DoubleSpinnerCtrl ctrlSpnDiff = new DoubleSpinnerCtrl(true, 12, 2);
    protected String activeMarket = "";
    protected String inactiveMarket = "";

    @FXML
    public void initialize() {
        this.initSecurity();
        this.initDiliverSecurity();
        this.initYield();
        this.registerCheck();
    }

    private void initSecurity() {
        Collection refs = this.ref.getItems(new String[]{"FORWARD"});
        if (refs.isEmpty()) {
            refs = this.ref.getItems(new String[]{"SBFWD"});
        }
        for (RefItem ref : refs) {
            StdBondForward std;
            if (!(ref instanceof StdBondForward) || !(std = (StdBondForward)ref).getStatus().equals("B")) continue;
            this.codeList.add(ref);
            this.mapStdBond.put(std.getCode(), std);
        }
        this.suggest.addPossibleSuggestions(this.codeList);
        AutoCompletion auto = Search.bindAutoCompletion((TextField)this.txtSecurity, (Callback)this.suggest, (StringConverter)((StringConverter)this.of.create(SecConverter.class)));
        auto.setPrefWidth(350.0);
        this.txtSecurity.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
    }

    private void initDiliverSecurity() {
        Collection delivers = this.ref.getItems(new String[]{"SBFWDDELIVER"});
        for (RefItem item : delivers) {
            if (!(item instanceof StdBondForwardDeliver)) continue;
            StdBondForwardDeliver deliver = (StdBondForwardDeliver)item;
            if (this.map.get(deliver.getSecurityClass()) == null) {
                this.map.put(deliver.getSecurityClass(), new ArrayList());
            }
            this.map.get(deliver.getSecurityClass()).add(deliver);
        }
    }

    private void initYield() {
        ObservableList listBid = FxUtils.newList();
        listBid.add((Object)"BID_\u6700\u4f18");
        listBid.add((Object)"BID_\u56fd\u9645");
        listBid.add((Object)"BID_\u56fd\u5229");
        listBid.add((Object)"BID_\u4fe1\u5510");
        listBid.add((Object)"BID_\u4e2d\u8bda");
        listBid.add((Object)"BID_\u5e73\u5b89");
        ObservableList listOffer = FxUtils.newList();
        listOffer.add((Object)"OFR_\u6700\u4f18");
        listOffer.add((Object)"OFR_\u56fd\u9645");
        listOffer.add((Object)"OFR_\u56fd\u5229");
        listOffer.add((Object)"OFR_\u4fe1\u5510");
        listOffer.add((Object)"OFR_\u4e2d\u8bda");
        listOffer.add((Object)"OFR_\u5e73\u5b89");
        this.cmbActiveBidYtm.setItems(listBid);
        this.cmbInactiveBidYtm.setItems(listBid);
        this.cmbActiveOfferYtm.setItems(listOffer);
        this.cmbInactiveOfferYtm.setItems(listOffer);
        this.suggestFundBid.addPossibleSuggestions((Collection)listBid);
        this.suggestFundOffer.addPossibleSuggestions((Collection)listOffer);
        Search.bindAutoCompletion((TextField)this.cmbActiveBidYtm.getEditor(), (Callback)this.suggestFundBid);
        Search.bindAutoCompletion((TextField)this.cmbActiveOfferYtm.getEditor(), (Callback)this.suggestFundOffer);
        Search.bindAutoCompletion((TextField)this.cmbInactiveBidYtm.getEditor(), (Callback)this.suggestFundBid);
        Search.bindAutoCompletion((TextField)this.cmbInactiveOfferYtm.getEditor(), (Callback)this.suggestFundOffer);
        this.cmbActiveBidYtm.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbActiveBidYtm.getSelectionModel().select(now);
            this.cmbActiveBidYtm.hide();
        });
        this.lbPercentActiveBid.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            String text = this.cmbActiveBidYtm.getEditor().getText();
            if (text.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(text);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbActiveBidYtm.getEditor().textProperty()}));
        this.lbPercentActiveOffer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            String text = this.cmbActiveOfferYtm.getEditor().getText();
            if (text.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(text);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbActiveOfferYtm.getEditor().textProperty()}));
        this.lbPercentInactiveBid.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            String text = this.cmbInactiveBidYtm.getEditor().getText();
            if (text.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(text);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbInactiveBidYtm.getEditor().textProperty()}));
        this.lbPercentInactiveOffer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            String text = this.cmbInactiveOfferYtm.getEditor().getText();
            if (text.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(text);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbInactiveOfferYtm.getEditor().textProperty()}));
        this.cmbActiveBidYtm.getSelectionModel().select(0);
        this.cmbActiveOfferYtm.getSelectionModel().select(0);
        this.cmbInactiveBidYtm.getSelectionModel().select(0);
        this.cmbInactiveOfferYtm.getSelectionModel().select(0);
    }

    protected void registerCheck() {
        this.ctrlSpnIrr.ctrl(this.spnIrr);
        this.cmbActiveBidYtm.getEditor().setTextFormatter((TextFormatter)new Formatter("^((([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?)|([A-Za-z0-9_\u4e00-\u9fa5]*)$", 12));
        this.cmbActiveOfferYtm.getEditor().setTextFormatter((TextFormatter)new Formatter("^((([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?)|([A-Za-z0-9_\u4e00-\u9fa5]*)$", 12));
        this.cmbInactiveBidYtm.getEditor().setTextFormatter((TextFormatter)new Formatter("^((([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?)|([A-Za-z0-9_\u4e00-\u9fa5]*)$", 12));
        this.cmbInactiveBidYtm.getEditor().setTextFormatter((TextFormatter)new Formatter("^((([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?)|([A-Za-z0-9_\u4e00-\u9fa5]*)$", 12));
        this.ctrlSpnDiff.ctrl(this.spnDiff);
        this.registerCheck((Node)this.lbIrrErr, (ObservableBooleanValue)this.spnIrr.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbActiveBidYtmErr, (ObservableBooleanValue)this.cmbActiveBidYtm.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbActiveOfferYtmErr, (ObservableBooleanValue)this.cmbActiveOfferYtm.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbInactiveBidYtmErr, (ObservableBooleanValue)this.cmbInactiveBidYtm.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbInactiveOfferYtmErr, (ObservableBooleanValue)this.cmbInactiveOfferYtm.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbDiffErr, (ObservableBooleanValue)this.spnDiff.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbSecurityErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            this.txtActiveSecurity.clear();
            this.txtInactiveSecurity.clear();
            String security = this.txtSecurity.getText();
            this.refItem = (RefItem)this.mapStdBond.get(security);
            logger.info(security);
            if (security.isEmpty()) {
                this.lbSecurityErr.setText("\u8bf7\u8f93\u5165\u5408\u7ea6\u4ee3\u7801");
                return false;
            }
            if (this.refItem == null) {
                this.lbSecurityErr.setText("\u5408\u7ea6\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            List<StdBondForwardDeliver> des = this.map.get(security);
            if (des == null || des.size() == 0) {
                this.lbSecurityErr.setText("\u8be5\u5408\u7ea6\u672a\u8bbe\u7f6e\u4ea4\u5272\u5238");
                return false;
            }
            int active = 0;
            int inactive = 0;
            for (StdBondForwardDeliver de : des) {
                if (de.getActive() == 1) {
                    ++active;
                    continue;
                }
                ++inactive;
            }
            if (active == 0) {
                this.lbSecurityErr.setText("\u8be5\u5408\u7ea6\u672a\u8bbe\u7f6e\u6d3b\u8dc3\u5238");
                return false;
            }
            if (active > 1) {
                this.lbSecurityErr.setText("\u8be5\u5408\u7ea6\u8bbe\u7f6e\u7684\u6d3b\u8dc3\u5238\u4e0d\u552f\u4e00");
                return false;
            }
            if (inactive == 0) {
                this.lbSecurityErr.setText("\u8be5\u5408\u7ea6\u672a\u8bbe\u7f6e\u975e\u6d3b\u8dc3\u5238");
                return false;
            }
            if (inactive > 1) {
                this.lbSecurityErr.setText("\u8be5\u5408\u7ea6\u8bbe\u7f6e\u7684\u975e\u6d3b\u8dc3\u5238\u4e0d\u552f\u4e00");
                return false;
            }
            for (StdBondForwardDeliver deliver : this.map.get(security)) {
                int index = deliver.getCode().indexOf(".");
                if (deliver.getActive() == 1) {
                    this.txtActiveSecurity.setText(deliver.getCode().substring(index + 1));
                    this.activeMarket = deliver.getMarket();
                    continue;
                }
                this.txtInactiveSecurity.setText(deliver.getCode().substring(index + 1));
                this.inactiveMarket = deliver.getMarket();
            }
            return true;
        }, (Observable[])new Observable[]{this.txtSecurity.textProperty()}));
    }
}

