/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.api.data.IRefApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.BondRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import com.google.protobuf.Any;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BondDataPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(BondDataPart.class);
    @FXML
    private TableView<RefItem> tableBond;
    @FXML
    TableColumn<RefItem, String> shgSecId;
    @FXML
    TableColumn<RefItem, String> sheSecId;
    @FXML
    TableColumn<RefItem, String> cfeSecId;
    @FXML
    TableColumn<RefItem, String> shgSymbol;
    @FXML
    TableColumn<RefItem, String> sheSymbol;
    @FXML
    TableColumn<RefItem, String> cfeSymbol;
    @FXML
    TableColumn<BondRefItem, String> shgStartDate;
    @FXML
    TableColumn<BondRefItem, String> sheStartDate;
    @FXML
    TableColumn<BondRefItem, String> cfeStartDate;
    @FXML
    TableColumn<BondRefItem, Number> issuePrice;
    @FXML
    TableColumn<BondRefItem, String> listDate;
    @FXML
    TableColumn<BondRefItem, String> mtrDate;
    @FXML
    TableColumn<BondRefItem, String> qType;
    @FXML
    TableColumn<BondRefItem, String> securitySubType;
    @FXML
    TableColumn<BondRefItem, String> term;
    @FXML
    TableColumn<BondRefItem, Number> coupon;
    @FXML
    TableColumn<BondRefItem, Number> refRat;
    @FXML
    TableColumn<BondRefItem, Number> refSprd;
    @FXML
    TableColumn<BondRefItem, Number> cashTimes;
    @FXML
    TableColumn<BondRefItem, String> warrantor;
    @FXML
    TableColumn<BondRefItem, String> issuer;
    @FXML
    private TextField searchText;
    private MxList<RefItem> mxList = new MxList();
    private List<RefItem> itemList = new LinkedList<RefItem>();
    private Predicate<RefItem> pd = item -> {
        String text = this.searchText.getText().trim();
        return item.getCode().contains(text) || item.getName().contains(text);
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.update(this.itemList, this.pd);
        this.tableBond.sort();
        this.tableBond.refresh();
    });
    private InvalidationListener lstnSearch = ob -> this.mxList.filter(this.itemList, this.pd);
    @Inject
    private ExecutorService exe;
    @Inject
    private IRefApi refApi;
    public static final int REQ_TYPE_SECTYPE = 1;

    @FXML
    public void initialize() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.createTableView();
        this.load();
    }

    private void createTableView() {
        this.tableBond.setPlaceholder((Node)new Label());
        BondDataPart.initValueFactory(this.tableBond);
        this.shgSecId.setCellValueFactory(data -> this.checkData((TableColumn.CellDataFeatures<RefItem, String>)data, "XSHG", true));
        this.sheSecId.setCellValueFactory(data -> this.checkData((TableColumn.CellDataFeatures<RefItem, String>)data, "XSHE", true));
        this.cfeSecId.setCellValueFactory(data -> this.checkData((TableColumn.CellDataFeatures<RefItem, String>)data, "XCFE", true));
        this.shgSymbol.setCellValueFactory(data -> this.checkData((TableColumn.CellDataFeatures<RefItem, String>)data, "XSHG", false));
        this.sheSymbol.setCellValueFactory(data -> this.checkData((TableColumn.CellDataFeatures<RefItem, String>)data, "XSHE", false));
        this.cfeSymbol.setCellValueFactory(data -> this.checkData((TableColumn.CellDataFeatures<RefItem, String>)data, "XCFE", false));
        this.tableBond.setItems(this.mxList.getList());
    }

    private SimpleStringProperty checkData(TableColumn.CellDataFeatures<RefItem, String> data, String type, boolean isCode) {
        String code = ((RefItem)data.getValue()).getCode();
        String name = ((RefItem)data.getValue()).getName();
        String market = ((RefItem)data.getValue()).getMarket();
        SimpleStringProperty ssp = new SimpleStringProperty("");
        if (market.equals(type)) {
            ssp.set(isCode ? code : name);
        }
        return ssp;
    }

    private static <T> void initValueFactory(TableView<T> table) {
        for (TableColumn tc : table.getColumns()) {
            for (TableColumn column : tc.getColumns()) {
                column.setCellValueFactory((Callback)new PropertyValueFactory(column.getId()));
            }
        }
    }

    @FXML
    private void refresh() {
    }

    public void load() {
        this.exe.execute(() -> {
            logger.info("--------load ref data start: bond");
            try {
                LinkedList<BondRefItem> listItem = new LinkedList<BondRefItem>();
                List list = this.refApi.loadRefData(1, "CCS", "BOND", "", null);
                for (PRefData.SecListItem item : list) {
                    Any any = item.getObject();
                    if (!any.is(PCcsRefdata.RefDataExtraBond.class)) continue;
                    BondRefItem refItem = new BondRefItem();
                    refItem.update((Object)item);
                    listItem.add(refItem);
                }
                this.itemList.addAll(listItem);
                this.lstnModel.invalidated(null);
                logger.info("--------load ref data end: bond");
            }
            catch (MException e) {
                logger.error("--------load ref data failed: bond", (Throwable)e);
            }
        });
    }
}

