/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.views.BondForwardDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.entity.strategy.BondStrategy;
import cms.tmx.http.api.OpStatus;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class AddBondForwardDialog
extends BondForwardDialog {
    AddBondForwardDialog() {
        this.fxml = "BondForwardDialog.fxml";
    }

    protected boolean isOK(ButtonType bt) {
        BondStrategy params = new BondStrategy();
        try {
            params.setMarket(this.refItem.getMarket());
            params.setInstSecId(this.txtSecurity.getText());
            for (StdBondForwardDeliver deliver : (List)this.map.get(this.txtSecurity.getText())) {
                if (deliver.getActive() == 1) {
                    params.setActiveMarket(deliver.getMarket());
                    continue;
                }
                params.setInactiveMarket(deliver.getMarket());
            }
            StdBondForward ref = (StdBondForward)this.txtSecurity.getUserData();
            params.setMarket(ref.getMarket());
            params.setActiveSecId(this.txtActiveSecurity.getText());
            params.setInactiveSecId(this.txtInactiveSecurity.getText());
            params.setIrr(Double.parseDouble(this.spnIrr.getEditor().getText()));
            if (this.lbPercentActiveBid.isVisible()) {
                params.setActiveBidYield(Double.parseDouble(this.cmbActiveBidYtm.getEditor().getText()));
            }
            if (this.lbPercentActiveOffer.isVisible()) {
                params.setActiveOfferYield(Double.parseDouble(this.cmbActiveOfferYtm.getEditor().getText()));
            }
            if (this.lbPercentInactiveBid.isVisible()) {
                params.setInactiveBidYield(Double.parseDouble(this.cmbInactiveBidYtm.getEditor().getText()));
            }
            if (this.lbPercentInactiveOffer.isVisible()) {
                params.setInactiveOfferYield(Double.parseDouble(this.cmbInactiveOfferYtm.getEditor().getText()));
            }
            params.setActiveBidSource(this.cmbActiveBidYtm.getEditor().getText());
            params.setActiveOfferSource(this.cmbActiveOfferYtm.getEditor().getText());
            params.setActiveMarket(this.activeMarket);
            params.setInactiveBidSource(this.cmbInactiveBidYtm.getEditor().getText());
            params.setInactiveOfferSource(this.cmbInactiveOfferYtm.getEditor().getText());
            params.setInactiveMarket(this.inactiveMarket);
            params.setSpread(Double.parseDouble(this.spnDiff.getEditor().getText()));
            OpStatus status = this.priceModel.add(params);
            MEvent event = new MEvent();
            event.put((Object)"id", (Object)status.getData());
            this.es.postEvent("last.id", event);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u65b0\u589e\u6210\u529f");
            if (status.getData().isEmpty()) {
                this.alert.alert(Alert.AlertType.ERROR, "\u7b56\u7565ID\u4e3a\u7a7a");
            } else {
                this.priceModel.start(status.getData());
            }
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

