/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.javafx.utils.CssUtils;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;

public class YieldCell<E extends HandicapInfo>
extends TableCell<HandicapInfo, Number> {
    private MarketItem info;
    private Boolean bs;

    public YieldCell(MarketItem info) {
        CssUtils.priceTag((Control)this);
        this.info = info;
    }

    public YieldCell(MarketItem info, Boolean bs) {
        this(info);
        this.bs = bs;
    }

    public void updateItem(Number item, boolean empty) {
        HandicapInfo handiInfo;
        if (!(empty || item.doubleValue() == 0.0 || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
            double price = item.doubleValue();
            if (this.bs != null && this.bs.booleanValue()) {
                CssUtils.makeFall((Control)this);
            } else if (this.bs != null && !this.bs.booleanValue()) {
                CssUtils.makeRise((Control)this);
            } else {
                CssUtils.checkPrice((Control)this, (double)this.info.getClosePrice(), (double)price);
            }
            if (price > 0.0) {
                String txt = String.format("%.4f", price);
                this.setText(txt);
                return;
            }
        }
        this.setText(null);
    }
}

