/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.XswapHedgeTask;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.StrategyServiceApi;
import cms.tmx.http.api.strategy.dto.EventType;
import cms.tmx.http.api.strategy.dto.GetHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.GetHedgeTasksResp;
import cms.tmx.http.api.strategy.dto.HedgeTaskInfo;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.utils.QueryModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XswapHedgeTaskModel
extends MxModel {
    @Inject
    private StrategyServiceApi api;
    @Inject
    private HttpBaseApi httpBaseApi;
    @Inject
    private QueryModel queryModel;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private MxAlert alert;
    private static final int QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    private MxList<XswapHedgeTask> mlist = new MxList();
    protected Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    public void init() {
        this.sdQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.HedgeTaskEvent", this.handler);
    }

    public void query() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                this.logger.error("xbond hedge task query faild", (Throwable)e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    private void fullQuery() throws MException {
        GetHedgeTasksReq builder = new GetHedgeTasksReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setPage(this.httpBaseApi.getHttpDefPage());
        builder.setServiceType("SBF_MARKET_MAKING");
        GetHedgeTasksResp tasks = this.api.getHedgeTasks(builder);
        this.updateData(tasks.getTaskInfo());
    }

    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson((JsonElement)obj, StrategyEvent.class);
        HedgeTaskInfo taskInfo = (HedgeTaskInfo)this.gson.fromJson(strategyEvent.getDetails(), HedgeTaskInfo.class);
        String secType = taskInfo.getInstrument().getSecurityType();
        if (!secType.contains("SBFWD") && !secType.contains("FORWARD")) {
            return;
        }
        XswapHedgeTask task = new XswapHedgeTask();
        task.update((Object)taskInfo);
        if (strategyEvent.getType().equals((Object)EventType.ADD)) {
            this.mlist.add((MxObject)task);
        } else if (strategyEvent.getType().equals((Object)EventType.UPDATE)) {
            XswapHedgeTask old = (XswapHedgeTask)this.mlist.get((MxObject)task);
            old.update((Object)task);
        } else if (strategyEvent.getType().equals((Object)EventType.DELETE)) {
            this.mlist.remove((MxObject)task);
        }
        this.changed();
    }

    private void updateData(List<HedgeTaskInfo> list) {
        ArrayList<XswapHedgeTask> listTmp = new ArrayList<XswapHedgeTask>();
        if (list != null) {
            for (HedgeTaskInfo info : list) {
                XswapHedgeTask strategy = new XswapHedgeTask();
                strategy.update((Object)info);
                listTmp.add(strategy);
            }
        }
        this.mlist.update(listTmp);
        this.changed();
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public List<XswapHedgeTask> getList() {
        return this.mlist.getList();
    }
}

