/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.XBond;
import cms.tmx.entity.data.XBondDealMarketItem;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.dto.InstrmtMDReq;
import cms.tmx.http.api.marketdata.dto.MDEntry;
import cms.tmx.http.api.marketdata.dto.MarketDataRequest;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.http.api.marketdata.dto.Message;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XswapDealMarketModel
extends MxModel {
    private MxList<XBondDealMarketItem> list = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private IRefDataMng refMng;
    private Gson gson = new Gson();

    public List<XBondDealMarketItem> getList() {
        return this.list.getList();
    }

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.ficc.marketdata", event -> this.onMarketItemPush(event));
        this.es.subscribe("websocket.connected", event -> this.subscribe("*"));
        this.es.subscribe("websocket.connected", event -> this.mdSubscribe("*"));
    }

    private void onMarketItemPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof MarketDataSnapshot)) {
            return;
        }
        MarketDataSnapshot snap = (MarketDataSnapshot)obj;
        if ("BFDDeal".equals(snap.getMdType())) {
            this.updateMarketItems(snap);
        }
    }

    private void updateMarketItems(MarketDataSnapshot snap) {
        String code;
        String market = snap.getInstrument().getMarket();
        RefItem refItem = this.refMng.getItem(market, code = snap.getInstrument().getSecurityId());
        if (refItem == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[market]: no ref item " + code);
            }
            return;
        }
        XBondDealMarketItem mktItem = new XBondDealMarketItem(market, code);
        mktItem.setName(refItem.getName());
        if (refItem instanceof XBond) {
            XBond bond = (XBond)refItem;
            mktItem.setTermToMaturityString(bond.getTermToMaturityString());
            mktItem.setRating(bond.getRatLvl());
        }
        mktItem.update((Object)snap);
        this.afterUpdate(mktItem, snap);
        if (this.list.getListMap().get(mktItem) == null) {
            this.list.add((MxObject)mktItem);
        } else {
            ((XBondDealMarketItem)this.list.get((MxObject)mktItem)).update((Object)mktItem);
        }
        this.changed();
    }

    private void afterUpdate(XBondDealMarketItem mktItem, MarketDataSnapshot snap) {
        for (MDEntry md : snap.getEntry()) {
            if (md.getMdEntryType() != 0 && md.getMdEntryType() != 1 && md.getMdEntryType() != 2) continue;
            mktItem.setNowYield((double)Math.round(md.getMdEntrySize() * 10000.0) / 10000.0 / 1.0E7);
        }
        mktItem.setOpenPrice(snap.getPriceUnit().getOpenPx());
        mktItem.setHighYield(snap.getPriceUnit().getHighestPx());
        mktItem.setLowYield(snap.getPriceUnit().getLowestPx());
        mktItem.setVolume(snap.getPriceUnit().getVolume() / 10000000L);
    }

    public void subscribe(String code) {
        Message message = new Message();
        MarketDataRequest req = new MarketDataRequest();
        ArrayList<InstrmtMDReq> list = new ArrayList<InstrmtMDReq>();
        InstrmtMDReq ins = new InstrmtMDReq();
        Instrument inst = new Instrument();
        inst.setMarket("XCFE");
        inst.setSecurityType("SBFWD");
        inst.setSecuritySubType("XcfeXSwap");
        inst.setSecurityId(code);
        ins.setInstrument(inst);
        ins.setMdType("BFDDeal");
        list.add(ins);
        req.setInstrmtMdReq(list);
        message.setTopic("ficc.marketdata");
        message.setData((Object)req);
        MEvent event = new MEvent();
        event.setObj((Object)message);
        String json = this.gson.toJson((Object)req);
        this.logger.info("xswap\u6210\u4ea4\u8ba2\u9605" + json);
        this.es.postEvent("subscribe.market.data", event);
    }

    public void mdSubscribe(String code) {
        Message message = new Message();
        MarketDataRequest req = new MarketDataRequest();
        ArrayList<InstrmtMDReq> list = new ArrayList<InstrmtMDReq>();
        InstrmtMDReq ins = new InstrmtMDReq();
        Instrument inst = new Instrument();
        inst.setMarket("XCFE");
        inst.setSecurityType("SBFWD");
        inst.setSecuritySubType("XcfeXSwap");
        inst.setSecurityId(code);
        ins.setInstrument(inst);
        ins.setMdType("BFDDeal");
        list.add(ins);
        req.setInstrmtMdReq(list);
        message.setTopic("ficc.marketdata");
        message.setData((Object)req);
        MEvent event = new MEvent();
        event.setObj((Object)message);
        this.es.postEvent("subscribe.market.data", event);
    }
}

