/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.NewOrdersSingle;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.FundAccName;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IMarketDataMng;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XswapBondForwardTradeModel {
    private static final Logger logger = LogManager.getLogger(XswapBondForwardTradeModel.class);
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty time = new SimpleStringProperty("");
    public BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private IntegerProperty count = new SimpleIntegerProperty();
    private ObjectProperty<MxNode> ocFlag = new SimpleObjectProperty();
    private ObjectProperty<MxNode> orderType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private SimpleStringProperty ocFlagString = new SimpleStringProperty("");
    private SimpleStringProperty orderTypeString = new SimpleStringProperty("");
    public StdBondForward refItem = null;
    private MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private TradeServiceApi api;
    @Inject
    private MConfService cs;
    @Inject
    private MEventService es;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private CcsAccountMap accntMng;
    private ObservableList<CfetsFundAccount> accList = FxUtils.newList();
    @Inject
    private ISecAccountService secAccService;
    @Inject
    private FundAccName fundName;
    @Inject
    protected CcsEntrustFactory ef;

    @PostConstruct
    public void init() throws MException {
        this.mktItem = this.mktMng.createItem(5);
        MxNode node = MxNodeFactory.createNew((String)"position_effect", (String)"70");
        this.ocFlag(node);
        this.setOcFlag(node);
        node = MxNodeFactory.createNew((String)"price_type", (String)"50");
        this.initPriceType(node);
        this.setOrderType(node);
        this.orderType.addListener(ob -> this.onPriceStgChange());
    }

    public void submit() throws MException {
        NewOrdersSingle order = new NewOrdersSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = new Instrument();
        if (this.refItem != null) {
            security.setSecurityId(this.refItem.getCode());
            security.setMarket(this.refItem.getMarket());
            security.setSymbol(this.refItem.getName());
            security.setMarketGroup(MarketUtils.getMarketGroup((String)this.refItem.getMarket()));
            security.setSecurityType("FORWARD");
            security.setMarketIndicator("SBFWD");
            security.setSecuritySubType("XcfeXSwap");
        }
        order.setInstrument(security);
        order.setOrdType(this.getOrderType().getRaw());
        this.accList.setAll(this.accntMng.getCfetsAccountMap().values());
        if (this.accList.isEmpty()) {
            throw new MException(999, "\u8d44\u91d1\u8d26\u53f7\u67e5\u8be2\u5931\u8d25");
        }
        Map mapAccount = this.secAccService.getAllSecAccountMap();
        List list = (List)mapAccount.get(this.accList.get(0));
        order.setExtSecAccntId(((SecAccount)list.get(0)).getExtSecAccntId());
        order.setExtCashAccntId(((CfetsFundAccount)this.accList.get(0)).getNewCashAccntId());
        order.setSide((Object)(this.isBuy() ? Side.SIDE_BID.getValue() : Side.SIDE_OFFER.getValue()));
        order.setPrice(this.getPrice());
        order.setOrderQty((double)(this.getCount() * 10000000));
        order.setCfetsUserId(TraderModel.traderId);
        switch (this.getOcFlag().getRaw()) {
            case "67": {
                order.setPositionEffect("PE_CLOSE");
                break;
            }
            case "79": {
                order.setPositionEffect("PE_OPEN");
                break;
            }
            case "70": {
                order.setPositionEffect("PE_FIFO");
                break;
            }
        }
        String time = String.valueOf(new SimpleDateFormat("yyyyMMdd-").format(new Date())) + this.getTime();
        order.setExpireTime(time);
        this.api.newOrdersSingle(order);
    }

    public boolean isSame(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < 5) {
            if (listHandicap.get(i).getPrice() != listInfo.get(i).getPrice()) {
                logger.error("old: " + listHandicap.get(i).getPrice() + "new: " + listInfo.get(i).getPrice());
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<CcsSingleEntrust> getEntrustList() throws MException {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        this.accList.setAll(this.accntMng.getCfetsAccountMap().values());
        if (this.accList.isEmpty()) {
            throw new MException(999, "\u8d44\u91d1\u8d26\u53f7\u67e5\u8be2\u4e3a\u7a7a");
        }
        CcsSingleEntrust en = this.ef.createCcsSingle(((CfetsFundAccount)this.accList.get(0)).getExtAccntId(), ((CfetsFundAccount)this.accList.get(0)).getNewCashAccntId());
        en.setInvestorId(((CfetsFundAccount)this.accList.get(0)).toString());
        Map mapAccount = this.secAccService.getAllSecAccountMap();
        List list = (List)mapAccount.get(this.accList.get(0));
        en.setInvestorSecId(((SecAccount)list.get(0)).getInverstorSecId());
        en.setSide(this.buy.get() ? 49 : 50);
        en.setQuantity((long)(this.getCount() * 10000000));
        en.setMarket(this.refItem.getMarket());
        en.setSecType("FORWARD");
        en.setPrice(this.getPrice());
        en.setOrderType(50);
        en.setAmt(en.getAmt() / 100.0);
        en.setSec(this.refItem.getCode());
        en.setSecName(this.refItem.getName());
        en.setAppID("010");
        enList.add(en);
        return enList;
    }

    public void updateHandicapInfo(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < 5) {
            if (listInfo.size() <= i) {
                listHandicap.get(i).clear();
            }
            listHandicap.get(i).update((Object)listInfo.get(i));
            ++i;
        }
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }

    public final ObjectProperty<MxNode> ocFlagProperty() {
        return this.ocFlag;
    }

    public final MxNode getOcFlag() {
        return (MxNode)this.ocFlagProperty().get();
    }

    public final void setOcFlag(MxNode ocFlag) {
        this.ocFlagProperty().set((Object)ocFlag);
    }

    public final ObjectProperty<MxNode> orderTypeProperty() {
        return this.orderType;
    }

    public final MxNode getOrderType() {
        return (MxNode)this.orderTypeProperty().get();
    }

    public final void setOrderType(MxNode orderType) {
        this.orderTypeProperty().set((Object)orderType);
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("50");
        node.addNode("98");
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    private void ocFlag(MxNode node) {
        node.addNode("70");
        node.addNode("79");
        node.addNode("67");
    }

    private void onPriceStgChange() {
        this.setPrice(this.getHandicapPrice());
    }

    public double getHandicapPrice() {
        if (!this.isBidAskPrice()) {
            return 0.0;
        }
        int raw = 0;
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        return price;
    }

    public boolean isBidAskPrice() {
        return this.getOrderType().is("0");
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getType().equals("FUT");
    }

    public CtpRefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item instanceof CtpRefItem && item.getType().equals("FUT")) {
            return (CtpRefItem)CtpRefItem.class.cast(item);
        }
        return null;
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    public final SimpleStringProperty ocFlagStringProperty() {
        return this.ocFlagString;
    }

    public final String getOcFlagString() {
        return this.ocFlagStringProperty().get();
    }

    public final void setOcFlagString(String ocFlagString) {
        this.ocFlagStringProperty().set(ocFlagString);
    }

    public final SimpleStringProperty orderTypeStringProperty() {
        return this.orderTypeString;
    }

    public final String getOrderTypeString() {
        return this.orderTypeStringProperty().get();
    }

    public final void setOrderTypeString(String orderTypeString) {
        this.orderTypeStringProperty().set(orderTypeString);
    }
}

