/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.PosEvent;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.PosType;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.PositionQty;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CcsAccountMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XswapBondForwardPositionModel
extends MxModel {
    @Inject
    private PositionServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    private List<ObPosition> obList = new ArrayList<ObPosition>();
    @Inject
    private MEventService es;
    private MEventHandler handler = event -> this.onPush(event);
    private List<String> extCashAccntIdList = new ArrayList<String>();
    @Inject
    protected MScheduler sdPushChange;
    private static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    private Gson gson = new Gson();
    private Map<String, Position> map = new HashMap<String, Position>();
    private Map<String, ObPosition> obmap = new HashMap<String, ObPosition>();
    @Inject
    private CcsAccountMap accountMap;

    public List<ObPosition> getObList() {
        return this.obList;
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    @PostConstruct
    private void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.PosEvent", this.handler);
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PosEvent posEvent = (PosEvent)this.gson.fromJson((JsonElement)obj, PosEvent.class);
        for (Positions position : posEvent.getPosition()) {
            List posStatistic;
            if (AccntType.ACCNT_TYPE_SEC != position.getAccntType() || !"XCFE".equals(position.getInstrument().getMarket()) || !"FORWARD".equals(position.getInstrument().getSecurityType()) || (posStatistic = position.getPosStatistic()) == null) continue;
            for (PosStatistic stastic : posStatistic) {
                Position realPosition = new Position();
                ObPosition ObrealPosition = new ObPosition();
                realPosition.setPosStatistic(stastic);
                realPosition.update((Object)position);
                this.transformQty(realPosition);
                ObrealPosition.update((Object)realPosition);
                ObrealPosition.setSecAccntId(realPosition.getPosAccnt().getSecAccntId());
                ObrealPosition.setSecurityId(realPosition.getInstrument().getSecurityId());
                ObrealPosition.setDirection(realPosition.getPosStatistic().getDirection());
                if (this.obmap.get(this.key(realPosition)) == null) {
                    this.obmap.put(this.key(realPosition), ObrealPosition);
                    if (realPosition.getPosQty() != null) {
                        if ("PDT_Long".equals(realPosition.getPosStatistic().getDirection())) {
                            ObrealPosition.setSide("\u4e70\u5165");
                        } else {
                            ObrealPosition.setSide("\u5356\u51fa");
                        }
                    }
                    this.obList.add(ObrealPosition);
                    continue;
                }
                ObPosition obOld = this.obmap.get(this.key(realPosition));
                obOld.update((Object)realPosition);
                obOld.setSecAccntId(realPosition.getPosAccnt().getSecAccntId());
                obOld.setSecurityId(realPosition.getInstrument().getSecurityId());
                obOld.setDirection(realPosition.getPosStatistic().getDirection());
                if ("PDT_Long".equals(realPosition.getPosStatistic().getDirection())) {
                    obOld.setSide("\u4e70\u5165");
                    continue;
                }
                obOld.setSide("\u5356\u51fa");
            }
        }
        this.changed();
    }

    public String key(ObPosition ob) {
        return String.valueOf(ob.getSecAccntId()) + ob.getSecurityId() + ob.getDirection();
    }

    public String key(Position realPosition) {
        return String.valueOf(realPosition.getPosAccnt().getSecAccntId()) + realPosition.getInstrument().getSecurityId() + realPosition.getPosStatistic().getDirection();
    }

    public void query() throws IOException, MException {
        GetPositionsReq req = new GetPositionsReq();
        ArrayList list = new ArrayList();
        Collection values = this.accountMap.getCfetsSecAccountMap().values();
        LinkedList<String> extSecAccntIds = new LinkedList<String>();
        Iterator iterator = values.iterator();
        if (iterator.hasNext()) {
            SecAccount secAccount = (SecAccount)iterator.next();
            extSecAccntIds.add(secAccount.getExtSecAccntId());
        }
        req.setAccntId(extSecAccntIds);
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetExtPositionsResp resp = this.api.getPositions(req);
        list.clear();
        this.obList.clear();
        this.map.clear();
        Page pageResp = resp.getPage();
        list.addAll(resp.getRealPosition());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetExtPositionsResp res = this.api.getPositions(req);
            list.addAll(res.getRealPosition());
        }
        for (Position position : list) {
            if (!"FORWARD".equals(position.getInstrument().getSecurityType())) continue;
            if ("CDB5_2112".equals(position.getSecurityId())) {
                System.out.println();
            }
            this.transformQty(position);
            ObPosition obPosition = new ObPosition();
            obPosition.update((Object)position);
            if ("PDT_Long".equals(position.getPosStatistic().getDirection())) {
                obPosition.setSide("\u4e70\u5165");
            } else {
                obPosition.setSide("\u5356\u51fa");
            }
            if (position.getPosQty() == null) {
                System.out.println();
            }
            this.obmap.put(this.key(position), obPosition);
            this.obList.add(obPosition);
        }
        this.changed();
    }

    public void transformQty(Position pos) {
        if (pos.getPosQty() == null) {
            return;
        }
        if ("PDT_Short".equals(pos.getPosStatistic().getDirection())) {
            System.out.println();
        }
        for (PositionQty position : pos.getPosQty()) {
            if (pos.getPosStatistic() != null && position.getStatus() != pos.getPosStatistic().getStatus()) continue;
            if (position.getType() == PosType.kPosTypeSod) {
                pos.setSodQty(position.getLongQty());
                pos.setSodQty(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypeIntraday) {
                pos.setIntraDayQty(position.getLongQty());
                pos.setIntraDayQty(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypeFrozen) {
                pos.setFrozenQty(position.getLongQty());
                pos.setFrozenQty(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypeMargin) {
                pos.setMarginQty(position.getLongQty());
                pos.setMarginQty(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypeReceivable) {
                pos.setReceivable(position.getLongQty());
                pos.setReceivable(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypePayable) {
                pos.setPayable(position.getLongQty());
                pos.setPayable(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypeBalance) {
                if (pos.getAccntType() == AccntType.ACCNT_TYPE_SEC) {
                    pos.setSecBalance(position.getLongQty());
                    pos.setSecBalance(position.getShortQty());
                    continue;
                }
                if (pos.getAccntType() != AccntType.ACCNT_TYPE_CASH) continue;
                pos.setCashBalance(position.getLongQty());
                pos.setCashBalance(position.getShortQty());
                continue;
            }
            if (position.getType() == PosType.kPosTypeAvail) {
                if (pos.getAccntType() == AccntType.ACCNT_TYPE_SEC) {
                    pos.setSecAvail(position.getLongQty());
                    pos.setSecAvail(position.getShortQty());
                    continue;
                }
                if (pos.getAccntType() != AccntType.ACCNT_TYPE_CASH) continue;
                pos.setCashAvail(position.getLongQty());
                pos.setCashAvail(position.getShortQty());
                continue;
            }
            if (position.getType() != PosType.kPosTypeSyncWithDraw) continue;
            if (pos.getAccntType() == AccntType.ACCNT_TYPE_SEC) {
                pos.setSecWithDraw(position.getLongQty());
                pos.setSecWithDraw(position.getShortQty());
                continue;
            }
            if (pos.getAccntType() != AccntType.ACCNT_TYPE_CASH) continue;
            pos.setCashWithDraw(position.getLongQty());
            pos.setCashWithDraw(position.getShortQty());
        }
    }
}

