/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.trade.ObSingleOrderXswapBond;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.trade.message.MessagePromptMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XswapBondForwardOrderModel
extends MxModel {
    @Inject
    private OrderServiceNewApi newApi;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    private MessagePromptMng mp;
    protected MxList<Order> ordList = new MxList();
    protected MxList<ObSingleOrderXswapBond> oblist = new MxList();
    @Inject
    protected IUserService userService;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    private TradeServiceApi tradeApi;
    private MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = GsonFactory.getInstance();
    private Map<String, Order> ordMap = new HashMap<String, Order>();
    private ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    protected boolean isUnfinishedOrder = false;
    List<String> extCashAccntIdList = new ArrayList<String>();
    private ObservableList<CfetsFundAccount> accList = FxUtils.newList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!order.getInstrument().getMarket().equals("XCFE") || !order.getInstrument().getMarketIndicator().equals("SBFWD")) continue;
            order.setExtraFields();
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210+++" : "\u59d4\u6258+++") + " (sysOrderId:" + order.getOrderId() + ", orderId:" + order.getOrderId() + ", price:" + order.getPrice() + ", status:" + order.getOrdStatus() + ", qty:" + order.getOrderQty() + ", dealQty:" + order.getCumQty() + ", isactive:" + order.isInactive() + ")" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                Order ord;
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210---" : "\u59d4\u6258---") + ", sysOrderId:" + sysOrderId + ", statusOld:" + statusOld + ", statusNow:" + statusNow + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId() + ", isactive:" + order.isInactive());
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    if (order.isCanCancel()) {
                        ObSingleOrderXswapBond obBond = new ObSingleOrderXswapBond();
                        obBond.update(order);
                        obBond.setLeavesQty(order.getLeavesQty() / 1.0E7);
                        obBond.setOrderQty(order.getOrderQty() / 1.0E7);
                        this.oblist.updatePart((MxObject)obBond);
                        Order ord2 = new Order();
                        this.afterUpdate(order);
                        ord2.update(order);
                        ord2.setLeavesQty(order.getLeavesQty() / 1.0E7);
                        ord2.setOrderQty(order.getOrderQty() / 1.0E7);
                        this.ordMap.put(ord2.getOrderId(), ord2);
                        this.ordList.updatePart((MxObject)ord2);
                    } else {
                        ord = new Order();
                        ord.update(order);
                        if (this.ordList.getListMap().get(ord) != null) {
                            ObSingleOrderXswapBond obBond = new ObSingleOrderXswapBond();
                            obBond.update(order);
                            this.oblist.remove((MxObject)obBond);
                            this.ordMap.remove(ord.getOrderId());
                            this.ordList.remove((MxObject)ord);
                        }
                    }
                } else {
                    ord = new Order();
                    this.afterUpdate(order);
                    ord.update(order);
                    ord.setLeavesQty(order.getLeavesQty() / 1.0E7);
                    ord.setOrderQty(order.getOrderQty() / 1.0E7);
                    this.ordMap.put(ord.getOrderId(), ord);
                    this.ordList.updatePart((MxObject)ord);
                }
            }
        }
        this.changed();
    }

    private void afterUpdate(Order order) {
        if (order.isInactive() && ("48".equals(order.getOrdStatus().getValue()) || "49".equals(order.getOrdStatus().getValue()))) {
            order.setOrdStatus(OrdStatus.ORD_STATUS_INACTIVE);
        }
        if (!order.isInactive() && ("48".equals(order.getOrdStatus().getValue()) || "49".equals(order.getOrdStatus().getValue()))) {
            order.setOrdStatus(order.getOrdStatus());
        }
    }

    private void afterUpdate(SingleOrder order) {
        if (order.isInactive() && ("48".equals(order.getOrdStatus().getValue()) || "49".equals(order.getOrdStatus().getValue()))) {
            order.setOrdStatus(OrdStatus.ORD_STATUS_INACTIVE);
        }
        if (!order.isInactive() && ("48".equals(order.getOrdStatus().getValue()) || "49".equals(order.getOrdStatus().getValue()))) {
            order.setOrdStatus(order.getOrdStatus());
        }
    }

    @PostConstruct
    protected void init() {
        this.es.subscribe("uap.push.OrdEvent", this.handler);
        this.sdFullQuery.setInterval(3000);
        this.sdPushChange.setInterval(3000);
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("order query failed", e);
            }
        });
    }

    public void fullQuery() throws IOException, MException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        this.extCashAccntIdList.clear();
        Instrument security = new Instrument();
        security.setMarketIndicator("SBFWD");
        req.setInstrument(security);
        this.accList.clear();
        this.accList.setAll(this.accntMng.getCfetsAccountMap().values());
        if (this.accList.isEmpty()) {
            this.mp.logger("\u7cfb\u7edf\u5f02\u5e38 ", "\u8d44\u91d1\u8d26\u53f7\u67e5\u8be2\u5931\u8d25");
            return;
        }
        this.extCashAccntIdList.add(((CfetsFundAccount)this.accList.get(0)).getNewCashAccntId());
        req.setExtCashAccntId(this.extCashAccntIdList);
        if (this.isUnfinishedOrder) {
            req.setCanCancelFlag(1);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        this.ordList.clear();
        this.oblist.clear();
        GetOrdersResp resp = this.newApi.getOrders(req);
        this.ordList.addAll(resp.getData());
        int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
        while (--queryTimes > 0) {
            fragment.setOffset(fragment.getSize() + fragment.getOffset());
            req.setFragment(fragment);
            GetOrdersResp res = this.newApi.getOrders(req);
            this.ordList.addAll(res.getData());
        }
        for (Order order : this.ordList.getList()) {
            order.setExtraFields();
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            order.setExtCashAccntId(this.extCashAccntIdList.get(0));
            this.afterUpdate(order);
            order.setLeavesQty(order.getLeavesQty() / 1.0E7);
            order.setOrderQty(order.getOrderQty() / 1.0E7);
            this.ordMap.put(order.getOrderId(), order);
            this.ordList.updatePart((MxObject)order);
            ObSingleOrderXswapBond obBond = new ObSingleOrderXswapBond();
            obBond.update(order);
            obBond.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.oblist.add((MxObject)obBond);
        }
        this.changed();
    }

    public void afterUpdate() {
    }

    public MxList<ObSingleOrderXswapBond> getObList() {
        return this.oblist;
    }

    public boolean isUnfinishedOrder() {
        return this.isUnfinishedOrder;
    }

    public void setUnfinishedOrder(boolean isUnfinishedOrder) {
        this.isUnfinishedOrder = isUnfinishedOrder;
    }

    private Integer getStatusNo(SingleOrder order) {
        if (!order.isCanCancel()) {
            return 99999999;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            int qty = (int)order.getCumQty();
            if (order.getInstrument().getSecurityType().equals("BOND") && "XcfeXBond".equals(order.getInstrument().getSecuritySubType())) {
                qty /= 1000;
            }
            return 1000 + qty;
        }
        return -1;
    }

    public boolean orderCancel(ObSingleOrderXswapBond ord) throws MException {
        OrderCancelRequest req = new OrderCancelRequest();
        req.setOpUser(this.baseApi.getHttpOpUser());
        Order order = new Order();
        if (!this.ordMap.containsKey(ord.getOrderId())) {
            return false;
        }
        order = this.ordMap.get(ord.getOrderId());
        Instrument sec = new Instrument();
        sec.setSecurityId(order.getSecurityId());
        sec.setMarketGroup(order.getInstrument().getMarketGroup());
        sec.setMarket(order.getInstrument().getMarket());
        sec.setSecurityType("FORWARD");
        sec.setSecuritySubType(order.getSecuritySubType());
        sec.setMarketIndicator("SBFWD");
        req.setInstrument(sec);
        req.setExtSecAccntId(order.getExtAccntId().getSecAccntId());
        req.setExtSecAccntId(order.getExtSecAccntId());
        req.setExtCashAccntId(order.getExtCashAccntId());
        req.setOrderId(order.getOrderId());
        OpStatus status = this.tradeApi.orderCancel(req);
        return status.getStatus() == 1;
    }

    public MxList<Order> getOrdList() {
        return this.ordList;
    }

    public void setOrdList(MxList<Order> ordList) {
        this.ordList = ordList;
    }
}

