/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecution;
import cms.tmx.http.data.GetExecutionsReq;
import cms.tmx.http.data.GetExecutionsResp;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.trade.message.MessagePromptMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XswapBondForwardDealModel
extends MxModel {
    @Inject
    private OrderServiceNewApi api;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected MScheduler sdFullChange;
    @Inject
    protected IUserService userService;
    @Inject
    private MEventService es;
    @Inject
    private MessagePromptMng mp;
    private static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    private Gson gson = GsonFactory.getInstance();
    private Map<String, ObExecution> map = new HashMap<String, ObExecution>();
    private List<Execution> list = new ArrayList<Execution>();
    private List<ObExecution> obList = new ArrayList<ObExecution>();
    private ObservableList<CfetsFundAccount> accList = FxUtils.newList();
    @Inject
    private CcsAccountMap accntMng;
    List<String> extCashAccntIdList = new ArrayList<String>();
    private MEventHandler handler = event -> this.onPush(event);

    public List<ObExecution> getObList() {
        return this.obList;
    }

    public List<Execution> getList() {
        return this.list;
    }

    @PostConstruct
    private void init() throws MException {
        this.sdPushChange.setInterval(1000);
        this.sdFullChange.setInterval(1000);
        this.es.subscribe("uap.push.ExecEvent", this.handler);
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    public void query() {
        this.sdFullChange.schedule(e -> {
            try {
                this.fullQuery();
            }
            catch (MException | IOException e1) {
                e1.printStackTrace();
                this.logger.error(e1.getMessage(), e1);
            }
        });
    }

    public void fullQuery() throws IOException, MException {
        GetExecutionsReq req = new GetExecutionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        this.extCashAccntIdList.clear();
        this.accList.setAll(this.accntMng.getCfetsAccountMap().values());
        if (this.accList.isEmpty()) {
            this.mp.logger("\u7cfb\u7edf\u5f02\u5e38 ", "\u8d44\u91d1\u8d26\u53f7\u67e5\u8be2\u5931\u8d25");
            return;
        }
        this.extCashAccntIdList.add(((CfetsFundAccount)this.accList.get(0)).getNewCashAccntId());
        req.setExtCashAccntId(this.extCashAccntIdList);
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator("SBFWD");
        req.setInstrument(instrument);
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        GetExecutionsResp resp = this.api.getNewDeals(req);
        this.list.clear();
        this.obList.clear();
        this.list.addAll(resp.getData());
        int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
        while (--queryTimes > 0) {
            fragment.setOffset(fragment.getSize() + fragment.getOffset());
            req.setFragment(fragment);
            GetExecutionsResp res = this.api.getNewDeals(req);
            this.list.addAll(res.getData());
        }
        for (Execution deal : this.list) {
            deal.setExtraFields();
            this.afterUpdate(deal);
            ObExecution obDeal = new ObExecution();
            obDeal.update((Object)deal);
            obDeal.setAuthorizer((String)this.userService.getUserName(obDeal.getUserId()).get());
            this.map.put(obDeal.getExecId(), obDeal);
            this.obList.add(obDeal);
        }
        this.changed();
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)this.gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution exec : execEvent.getExecution()) {
            if (!exec.getInstrument().getMarket().equals("XCFE") || !exec.getInstrument().getMarketIndicator().equals("SBFWD")) continue;
            this.afterUpdate(exec);
            if (exec.getSelfparty() == null) {
                exec.setSelfparty(exec.getSelfParty());
            }
            exec.setExtraFields();
            ObExecution obDeal = new ObExecution();
            obDeal.update((Object)exec);
            obDeal.setAuthorizer((String)this.userService.getUserName(obDeal.getUserId()).get());
            this.map.put(obDeal.getExecId(), obDeal);
            this.obList.add(obDeal);
            this.list.add(exec);
            this.logger.info("\u59d4\u6258\u7f16\u53f7\uff1a" + exec.getSysOrderId() + ", \u6210\u4ea4\u7f16\u53f7\uff1a" + exec.getExecId() + ",\u4ef7\u683c\uff1a" + exec.getLastPx() + ",\u6570\u91cf\uff1a" + exec.getLastQty());
        }
        this.changed();
    }

    private void afterUpdate(Execution exec) {
        exec.setLastQty(exec.getLastQty() / 1.0E7);
        exec.setUnit(QueryUtils.getUnit((String)exec.getInstrument().getSecurityType(), (String)exec.getInstrument().getMarket()));
        exec.setUserName((String)this.userService.getUserName(exec.getUserId()).get());
    }
}

