/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.define.IErrorMsg;
import cms.tmx.entity.trade.XSwapStrategy;
import cms.tmx.entity.trade.XSwapStrategySerialize;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.StrategyServiceApi;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.AccountSettings;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.CtxResp;
import cms.tmx.http.api.strategy.dto.DeleteCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.EventType;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsResp;
import cms.tmx.http.api.strategy.dto.HedgeSettings;
import cms.tmx.http.api.strategy.dto.NewCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.OrderMassCancelRequest;
import cms.tmx.http.api.strategy.dto.SecuritySettings;
import cms.tmx.http.api.strategy.dto.StartContextReq;
import cms.tmx.http.api.strategy.dto.StartContextResp;
import cms.tmx.http.api.strategy.dto.StopContextReq;
import cms.tmx.http.api.strategy.dto.StopContextResp;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.api.strategy.dto.UpdateCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.XSwapContextSettings;
import cms.tmx.http.query.PositionEffect;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.utils.MarketUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XSwapStrategyModel
extends MxModel {
    @Inject
    private StrategyServiceApi api;
    @Inject
    private HttpBaseApi httpBaseApi;
    @Inject
    private TradeServiceNewApi tradeApi;
    public BooleanProperty statusChanged = new SimpleBooleanProperty();
    @Inject
    protected IBaseApi iba;
    @Inject
    protected MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private MxAlert alert;
    private static final int FULL_QUERY_INTERVAL = 1000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    public Map<XSwapStrategy, List<String>> strategySecurities = new HashMap<XSwapStrategy, List<String>>();
    public Map<String, List<XSwapStrategy>> securityStrategies = new HashMap<String, List<XSwapStrategy>>();
    public static StringProperty refreshTime = new SimpleStringProperty("");
    private MxList<XSwapStrategy> list = new MxList();
    private XSwapStrategy copyStrategy;
    protected Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);
    @Inject
    private IErrorMsg msg;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(1000);
        this.sdSpecQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.StrategyEvent", this.handler);
    }

    public void query(boolean all) {
        MScheduler sdQuery = all ? this.sdFullQuery : this.sdSpecQuery;
        sdQuery.schedule(event -> {
            try {
                this.fullQuery(all);
            }
            catch (MException | IOException e) {
                this.logger.error("xbond strategy query faild", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public synchronized void fullQuery(boolean all) throws IOException, MException {
        GetCtxSettingsReq req = new GetCtxSettingsReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setServiceType("SBF_MARKET_MAKING");
        req.setTemplate(all);
        req.setPage(this.httpBaseApi.getHttpDefPage());
        GetCtxSettingsResp resp = this.api.getStrategy(req);
        this.updateData(resp.getSettings());
        this.changed();
    }

    protected void onPush(MEvent event) {
        JsonElement obj = (JsonElement)event.getObj();
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson(String.valueOf(obj), StrategyEvent.class);
        if (strategyEvent.getType().equals((Object)EventType.NOTICE)) {
            return;
        }
        ContextSettings context = (ContextSettings)this.gson.fromJson(strategyEvent.getDetails(), ContextSettings.class);
        if (!"200,201,202".contains(String.valueOf(context.getExecModeType()))) {
            return;
        }
        XSwapStrategy strategy = new XSwapStrategy();
        strategy.update((Object)context);
        if (strategyEvent.getType().equals((Object)EventType.ADD)) {
            this.list.add((MxObject)strategy);
        } else if (strategyEvent.getType().equals((Object)EventType.UPDATE)) {
            XSwapStrategy old = (XSwapStrategy)this.list.get((MxObject)strategy);
            old.update((Object)strategy);
        } else if (strategyEvent.getType().equals((Object)EventType.DELETE)) {
            this.list.remove((MxObject)strategy);
        }
        this.changed();
    }

    private void updateData(List<ContextSettings> listInfo) throws InvalidProtocolBufferException {
        if (listInfo == null) {
            this.list.clear();
            return;
        }
        ArrayList<XSwapStrategy> listTmp = new ArrayList<XSwapStrategy>();
        for (ContextSettings info : listInfo) {
            XSwapStrategy strategy = new XSwapStrategy();
            try {
                strategy.update((Object)info);
            }
            catch (Exception e) {
                this.logger.error("xswap strategy parse faild", (Throwable)e);
            }
            listTmp.add(strategy);
        }
        this.list.update(listTmp);
    }

    public ContextSettings getSettingsByStrategy(XSwapStrategy strategy) throws MException {
        AccountSettings builderAcct = new AccountSettings();
        builderAcct.setParentExtAccntId(strategy.getParentExtAccntId());
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        Instrument builderInst = new Instrument();
        builderInst.setSecurityId(strategy.getSecurityId());
        builderInst.setSymbol(strategy.getSecurityName());
        builderInst.setSecurityType("FORWARD");
        builderInst.setSecuritySubType("XcfeXSwap");
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        ContextSettings builderCt = new ContextSettings();
        builderCt.setName(strategy.getName());
        builderCt.setAlgoId(strategy.getContextId());
        builderCt.setOpUser(this.httpBaseApi.getHttpOpUser());
        switch (strategy.getType().getRaw()) {
            case "200201202": 
            case "200": 
            case "201": 
            case "202": {
                builderCt.setExecModeType(Integer.parseInt(strategy.getCustomBs()));
                builderCt.setDetails((Object)this.packDetails(builderAcct, strategy, builderInst));
            }
        }
        builderCt.setTemplate(strategy.isTemplate());
        return builderCt;
    }

    private XSwapContextSettings packDetails(AccountSettings builderAcct, XSwapStrategy strategy, Instrument builderInst) {
        SecuritySettings builderSec = new SecuritySettings();
        builderSec.setPositionEffect(PositionEffect.deserialize((String)strategy.getPositionEffect().getRaw()));
        builderSec.setInstrument(builderInst);
        strategy.getActiveBenchmark().setInstrument(builderInst);
        builderSec.setPricSetting(strategy.getActiveBenchmark());
        if (!"201".equals(strategy.getCustomBs())) {
            String bifRefPriceFormula = strategy.getBidRefPriceFormula();
            BigDecimal bidSpdBig = new BigDecimal(strategy.getBidSpread()).setScale(4, 4);
            String bidSpread = bidSpdBig.toString();
            String opBid = strategy.isAttackBuy() ? "+" : "-";
            builderSec.setBidRefPriceFormula(String.valueOf(bifRefPriceFormula) + opBid + bidSpread);
            builderSec.setBidUpLimit(strategy.getBidUpLimit());
            builderSec.setBidFloorLimit(strategy.getBidFloorLimit());
            builderSec.setBidQty(Integer.valueOf((int)(strategy.getBidQty() * 1000.0 * 10000.0)));
        }
        if (!"200".equals(strategy.getCustomBs())) {
            String offerRefPriceFormula = strategy.getOfferRefPriceFormula();
            BigDecimal askSpdBig = new BigDecimal(strategy.getAskSpread()).setScale(4, 4);
            String askSpread = askSpdBig.toString();
            String opOffer = strategy.isAttackSell() ? "-" : "+";
            builderSec.setOfferRefPriceFormula(String.valueOf(offerRefPriceFormula) + opOffer + askSpread);
            builderSec.setOfferUpLimit(strategy.getOfferUpLimit());
            builderSec.setOfferFloorLimit(strategy.getOfferFloorLimit());
            builderSec.setOfferQty(Integer.valueOf((int)(strategy.getOfferQty() * 1000.0 * 10000.0)));
        }
        builderSec.setFullFilledCancel(Boolean.valueOf(strategy.getCancelType().getRaw()).booleanValue());
        builderSec.setBidPriceSlip(Double.valueOf(strategy.getBidPriceSlip()));
        builderSec.setOfferPriceSlip(Double.valueOf(strategy.getBidPriceSlip()));
        builderSec.setMaxAllowFilledQty(Integer.valueOf((int)(strategy.getMaxDeal() * 1000.0 * 10000.0)));
        builderSec.setCfetsTraderId(TraderModel.traderId);
        HedgeSettings builderHedge = new HedgeSettings();
        strategy.getHedgeBenchmark().setInstrument(builderInst);
        builderHedge.setPricSetting(strategy.getHedgeBenchmark());
        builderHedge.setBid1HedgePriceFormula(strategy.getBid1HedgePriceFormula());
        builderHedge.setBid2HedgePriceFormula(strategy.getBid2HedgePriceFormula());
        builderHedge.setOffer1HedgePriceFormula(strategy.getOffer1HedgePriceFormula());
        builderHedge.setOffer2HedgePriceFormula(strategy.getOffer2HedgePriceFormula());
        XSwapContextSettings builderCtx = new XSwapContextSettings();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        builderCtx.setHedge(builderHedge);
        return builderCtx;
    }

    public void addStrategy(XSwapStrategy strategy) throws MException {
        NewCtxSettingsReq builder = new NewCtxSettingsReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("SBF_MARKET_MAKING");
        this.api.addStrategy(builder);
    }

    public void addStrategy(XSwapStrategySerialize strategySlize) throws MException {
        NewCtxSettingsReq builder = new NewCtxSettingsReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        XSwapStrategy strategy = new XSwapStrategy();
        strategy.update((Object)strategySlize);
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("SBF_MARKET_MAKING");
        this.api.addStrategy(builder);
    }

    public void updateStrategy(XSwapStrategy strategy) throws MException {
        UpdateCtxSettingsReq builder = new UpdateCtxSettingsReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("SBF_MARKET_MAKING");
        this.api.updateStrategy(builder);
    }

    public void delStrategy(String market, String contextId) throws MException {
        DeleteCtxSettingsReq req = new DeleteCtxSettingsReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setAlgoId(contextId);
        req.setServiceType("SBF_MARKET_MAKING");
        this.api.deleteStrategy(req);
    }

    public Map<String, String> startStrategy(List<String> listId) throws MException {
        StartContextReq req = new StartContextReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setServiceType("SBF_MARKET_MAKING");
        req.getAlgoId().addAll(listId);
        StartContextResp resp = this.api.startStrategy(req);
        HashMap<String, String> map = new HashMap<String, String>();
        if (resp.getCtxResp() == null) {
            return map;
        }
        for (CtxResp ctx : resp.getCtxResp()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getContextId(), errorInfo);
        }
        return map;
    }

    public Map<String, String> stopStrategy(String market, List<String> listId) throws MException {
        if (market.isEmpty()) {
            return null;
        }
        StopContextReq req = new StopContextReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setServiceType("SBF_MARKET_MAKING");
        req.setAlgoId(listId);
        StopContextResp resp = this.api.stopStrategy(req);
        HashMap<String, String> map = new HashMap<String, String>();
        if (resp.getCtxResp() == null) {
            return map;
        }
        for (CtxResp ctx : resp.getCtxResp()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getContextId(), errorInfo);
        }
        return map;
    }

    public void stopAll() throws MException {
        OrderMassCancelRequest req = new OrderMassCancelRequest();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator("SBFWD");
        req.setInstrument(instrument);
        req.setUserId(this.httpBaseApi.getHttpOpUser().getUserId());
        req.setTraderId(TraderModel.traderId);
        req.setPartyId(this.httpBaseApi.getHttpOpUser().getPartyId());
        this.tradeApi.orderMassCancel(req);
    }

    public XSwapStrategy getXSwapStrategy(String contextId) {
        for (XSwapStrategy strategy : this.list.getList()) {
            if (!strategy.getContextId().equals(contextId)) continue;
            return strategy;
        }
        return null;
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public ObservableList<XSwapStrategy> getList() {
        return this.list.getList();
    }

    public final BooleanProperty statusChangedProperty() {
        return this.statusChanged;
    }

    public void statusChanged() {
        this.statusChanged.set(!this.statusChanged.get());
    }

    public XSwapStrategy getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(XSwapStrategy copyStrategy) {
        this.copyStrategy = copyStrategy;
    }
}

