/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.views.ICallBack;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.RepoRefItem;
import cms.tmx.entity.trade.XRepoStrategy;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.CalculateServiceApi;
import cms.tmx.http.api.strategy.api.NewStrategyServiceApi;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.AccountSettings;
import cms.tmx.http.api.strategy.dto.CalcAccruedInterestReq;
import cms.tmx.http.api.strategy.dto.CalcAccruedInterestResp;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.ExecModeType;
import cms.tmx.http.api.strategy.dto.NewCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.OrderMassCancelRequest;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.PartySub;
import cms.tmx.http.api.strategy.dto.RepoContextSettings;
import cms.tmx.http.api.strategy.dto.SecuritySettings;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.utils.MarketUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XRepoTradeModel {
    private static final Logger logger = LogManager.getLogger(XRepoTradeModel.class);
    private StringProperty extFundAccntId = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorsecId = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    public BooleanProperty offer = new SimpleBooleanProperty(true);
    private ObjectProperty<MxNode> ordType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> settlType = new SimpleObjectProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty count = new SimpleDoubleProperty();
    public RefItem refItem = null;
    private AtomicLong lastTime = new AtomicLong(0L);
    @Inject
    private TradeServiceApi tradeApi;
    @Inject
    private TradeServiceNewApi tradeNewApi;
    @Inject
    private NewStrategyServiceApi strategyApi;
    @Inject
    private MConfService cs;
    @Inject
    private MEventService es;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    protected ExecutorService exe;
    @Inject
    private CalculateServiceApi calcApi;
    private MEventHandler cancelOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        int countSuc = 0;
        int countFailed = 0;
        StringBuilder str = new StringBuilder();
        for (Object obj : list) {
            if (!(obj instanceof SingleOrder)) continue;
            SingleOrder ctpOrder = (SingleOrder)SingleOrder.class.cast(obj);
            try {
                this.cancel(ctpOrder);
                ++countSuc;
            }
            catch (MException e) {
                ++countFailed;
                logger.error("\u64a4\u5355\u5931\u8d25", (Throwable)e);
                str.append(String.valueOf(ctpOrder.getOrderId()) + e.getMessage() + "\n");
            }
            event.put((Object)"suc.count", (Object)countSuc);
            event.put((Object)"fail.count", (Object)countFailed);
            event.put((Object)"fail.message", (Object)str);
        }
    };
    @Inject
    protected CcsEntrustFactory ef;
    private boolean lock = false;
    private CalcAccruedInterestReq req = null;
    private CalcAccruedInterestResp resp = null;

    @PostConstruct
    public void init() {
        this.es.subscribe("xbond.cancel.order", this.cancelOrder);
    }

    public void submit() throws MException {
        NewOrderSingle order = new NewOrderSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = new Instrument();
        instrument.setSecurityId(this.refItem.getCode());
        instrument.setSymbol(this.refItem.getName());
        instrument.setMarket(this.refItem.getMarket());
        instrument.setMarketGroup(MarketUtils.getMarketGroup((String)this.refItem.getMarket()));
        instrument.setSecurityType(this.refItem.getType());
        instrument.setMarketIndicator("COLLATERAL_REPO");
        instrument.setSecuritySubType("XcfeXRepo");
        order.setInstrument(instrument);
        order.setOrdType(OrdType.ORD_TYPE_LIMIT);
        order.setExtCashAccntId((String)this.extFundAccntId.get());
        order.setExtSecAccntId((String)this.extSecAccntId.get());
        order.setSettlType(SettlType.getSettlType((String)this.getSettlType().getRaw()));
        order.setCfetsUserId(TraderModel.traderId);
        order.setSide(this.isOffer() ? Side.SIDE_OFFER : Side.SIDE_BID);
        order.setPrice(this.getPrice());
        order.setOrderQty(this.getOrderQty());
        this.tradeApi.newOrderSingle(order);
    }

    public double getOrderQty() {
        int unit = this.refItem.getCode().contains("mini") ? 10000000 : 100000000;
        return this.getCount() * (double)unit;
    }

    public void addStrategy(XRepoStrategy strategy) throws MException {
        NewCtxSettingsReq builder = new NewCtxSettingsReq();
        builder.setOpUser(this.baseApi.getHttpOpUser());
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("XREPO_MARKET_MAKING");
        this.strategyApi.addStrategy(builder);
    }

    public ContextSettings getSettingsByStrategy(XRepoStrategy strategy) throws MException {
        AccountSettings builderAcct = new AccountSettings();
        builderAcct.setParentExtAccntId(strategy.getParentExtAccntId());
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        Instrument builderInst = new Instrument();
        builderInst.setSecurityId(this.refItem.getCode());
        builderInst.setSymbol(this.refItem.getName());
        builderInst.setMarket(this.refItem.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)this.refItem.getMarket()));
        builderInst.setSecurityType(this.refItem.getType());
        builderInst.setApplId("010");
        ContextSettings builderCt = new ContextSettings();
        builderCt.setName(strategy.getName());
        builderCt.setAlgoId(strategy.getContextId());
        builderCt.setOpUser(this.baseApi.getHttpOpUser());
        builderCt.setDetails((Object)this.packDetails(builderAcct, strategy, builderInst));
        builderCt.setExecModeType(ExecModeType.EXEC_MODE_TYPE_REPO_ALGO.getValue());
        return builderCt;
    }

    private RepoContextSettings packDetails(AccountSettings builderAcct, XRepoStrategy strategy, Instrument builderInst) {
        RepoContextSettings builderSec = new RepoContextSettings();
        SecuritySettings security = new SecuritySettings();
        security.setCfetsTraderId(TraderModel.traderId);
        security.setInstrument(builderInst);
        security.setSide(this.isOffer() ? Side.SIDE_OFFER : Side.SIDE_BID);
        if (this.isOffer()) {
            security.setUpLimit(Double.valueOf(this.getPrice()));
        } else {
            security.setFloorLimit(Double.valueOf(this.getPrice()));
        }
        security.setTotalQty(Double.valueOf(this.getOrderQty()));
        security.setStartTime(strategy.getStartTime());
        security.setEndTime(strategy.getEndTime());
        builderSec.setAccount(builderAcct);
        builderSec.setSecurity(security);
        return builderSec;
    }

    public void cancel(SingleOrder singleOrder) throws MException {
        OrderCancelRequest order = new OrderCancelRequest();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = singleOrder.getInstrument();
        instrument.setMarketGroup(MarketUtils.getMarketGroup((String)instrument.getMarket()));
        order.setInstrument(instrument);
        order.setOrderId(singleOrder.getOrderId());
        Party party = new Party();
        party.setPartyId(this.cs.getValue("partyId"));
        party.setPartyRole("EXECUTING_FIRM");
        PartySub sub = new PartySub();
        sub.setPartySubId(TraderModel.traderId);
        sub.setPartySubIdType("PERSON");
        party.getPartySub().add(sub);
        order.getParty().add(party);
        this.tradeApi.orderCancel(order);
    }

    public void stopAll() throws MException {
        OrderMassCancelRequest req = new OrderMassCancelRequest();
        req.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator("COLLATERAL_REPO");
        req.setInstrument(instrument);
        req.setUserId(this.baseApi.getHttpOpUser().getUserId());
        req.setTraderId(TraderModel.traderId);
        req.setPartyId(this.baseApi.getHttpOpUser().getPartyId());
        this.tradeNewApi.orderMassCancel(req);
    }

    public void calcAccruedInterest(ICallBack call) {
        if (this.lock) {
            return;
        }
        if (this.refItem == null || this.getPrice() == 0.0 || this.getCount() == 0.0) {
            this.setReq(null);
            this.setResp(null);
            Platform.runLater(() -> call.resetExtraInfo());
            return;
        }
        long nowTime = System.currentTimeMillis();
        this.lastTime.set(nowTime);
        CalcAccruedInterestReq request = new CalcAccruedInterestReq();
        Instrument instrument = new Instrument();
        instrument.setMarket(this.refItem.getMarket());
        instrument.setSecurityId(this.refItem.getCode());
        instrument.setSecurityType(this.refItem.getType());
        request.setInstrument(instrument);
        request.setRate(this.getPrice());
        request.setQty(this.getOrderQty());
        request.setSettlDate(LocalDate.now().toString().replace("-", ""));
        request.setRepoDays((int)((RepoRefItem)this.refItem).getExpireDay());
        this.exe.execute(() -> {
            CalcAccruedInterestResp resp;
            block5: {
                this.lock = true;
                resp = this.calcApi.getCalcAccruedInterest(request);
                if (this.lastTime.get() == nowTime) break block5;
                Platform.runLater(() -> call.resetExtraInfo());
                return;
            }
            try {
                try {
                    this.lock = false;
                    this.req = request;
                    this.resp = resp;
                }
                catch (MException | Exception e) {
                    this.lock = false;
                    this.setResp(null);
                    logger.error("xrepo\u8ba1\u7b97\u7ed3\u7b97\u4fe1\u606f\u62a5\u9519\uff1a" + e.getMessage(), e);
                    Platform.runLater(() -> call.resetExtraInfo());
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> call.resetExtraInfo());
                throw throwable;
            }
            Platform.runLater(() -> call.resetExtraInfo());
        });
    }

    public CalcAccruedInterestReq getReq() {
        return this.req;
    }

    public void setReq(CalcAccruedInterestReq req) {
        this.req = req;
    }

    public CalcAccruedInterestResp getResp() {
        return this.resp;
    }

    public void setResp(CalcAccruedInterestResp resp) {
        this.resp = resp;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty countProperty() {
        return this.count;
    }

    public final double getCount() {
        return this.countProperty().get();
    }

    public final void setCount(double count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> settlTypeProperty() {
        return this.settlType;
    }

    public final MxNode getSettlType() {
        return (MxNode)this.settlTypeProperty().get();
    }

    public final void setSettlType(MxNode settlType) {
        this.settlTypeProperty().set((Object)settlType);
    }

    public final StringProperty extFundAccntIdProperty() {
        return this.extFundAccntId;
    }

    public final String getExtFundAccntId() {
        return (String)this.extFundAccntIdProperty().get();
    }

    public final void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntIdProperty().set((Object)extFundAccntId);
    }

    public final StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorsecIdProperty() {
        return this.investorsecId;
    }

    public final String getInvestorsecId() {
        return (String)this.investorsecIdProperty().get();
    }

    public final void setInvestorsecId(String investorsecId) {
        this.investorsecIdProperty().set((Object)investorsecId);
    }

    public final ObjectProperty<MxNode> ordTypeProperty() {
        return this.ordType;
    }

    public final MxNode getOrdType() {
        return (MxNode)this.ordTypeProperty().get();
    }

    public final void setOrdType(MxNode ordType) {
        this.ordTypeProperty().set((Object)ordType);
    }

    public final BooleanProperty offerProperty() {
        return this.offer;
    }

    public final boolean isOffer() {
        return this.offerProperty().get();
    }

    public final void setOffer(boolean offer) {
        this.offerProperty().set(offer);
    }
}

