/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.define.IErrorMsg;
import cms.tmx.entity.trade.XRepoStrategy;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.NewStrategyServiceApi;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.CtxResp;
import cms.tmx.http.api.strategy.dto.EventType;
import cms.tmx.http.api.strategy.dto.ExecModeType;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsResp;
import cms.tmx.http.api.strategy.dto.StopContextReq;
import cms.tmx.http.api.strategy.dto.StopContextResp;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.trade.message.MessagePromptMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XRepoStrategyModel
extends MxModel {
    @Inject
    private NewStrategyServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    public BooleanProperty statusChanged = new SimpleBooleanProperty();
    @Inject
    protected IBaseApi iba;
    @Inject
    protected MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private MxAlert alert;
    @Inject
    private MessagePromptMng msgMng;
    @Inject
    private IFundAccountService fundService;
    private static final int FULL_QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    public Map<String, XRepoStrategy> map = new HashMap<String, XRepoStrategy>();
    private MxList<XRepoStrategy> list = new MxList();
    private XRepoStrategy copyStrategy;
    protected Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);
    @Inject
    private IErrorMsg msg;

    @PostConstruct
    public void init() {
        this.sdQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.StrategyEvent", this.handler);
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | IOException e) {
                this.logger.error("xbond strategy query faild", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public synchronized void fullQuery() throws IOException, MException {
        GetCtxSettingsReq req = new GetCtxSettingsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setServiceType("XREPO_MARKET_MAKING");
        req.setPage(this.baseApi.getHttpDefPage());
        GetCtxSettingsResp resp = this.api.getStrategy(req);
        this.updateData(resp.getSettings());
        this.changed();
    }

    protected void onPush(MEvent event) {
        JsonElement obj = (JsonElement)event.getObj();
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson(obj.getAsString(), StrategyEvent.class);
        if (strategyEvent.getType().equals((Object)EventType.NOTICE)) {
            return;
        }
        ContextSettings context = (ContextSettings)this.gson.fromJson(strategyEvent.getDetails(), ContextSettings.class);
        if (!ExecModeType.EXEC_MODE_TYPE_REPO_ALGO.strValue().equals(String.valueOf(context.getExecModeType()))) {
            return;
        }
        XRepoStrategy strategy = new XRepoStrategy();
        strategy.update((Object)context);
        if (strategyEvent.getType().equals((Object)EventType.ADD)) {
            this.list.add((MxObject)strategy);
        } else if (strategyEvent.getType().equals((Object)EventType.UPDATE)) {
            XRepoStrategy old = (XRepoStrategy)this.list.get((MxObject)strategy);
            old.update((Object)strategy);
            this.triggerLimitCheck(strategy);
        } else if (strategyEvent.getType().equals((Object)EventType.DELETE)) {
            this.list.remove((MxObject)strategy);
            this.map.remove(strategy.getContextId());
        }
        this.changed();
    }

    private void triggerLimitCheck(XRepoStrategy strategy) {
        String msg = strategy.getErrorMsg();
        if (msg.contains("\u89e6\u53d1BID\u4e0a\u9650") || msg.contains("\u89e6\u53d1BID\u4e0b\u9650") || msg.contains("\u89e6\u53d1OFR\u4e0a\u9650") || msg.contains("\u89e6\u53d1OFR\u4e0b\u9650")) {
            String invesId = this.fundService.getCcsInvesId(strategy.getParentExtAccntId());
            this.msgMng.logger(invesId, "\u7b56\u7565\u5f02\u5e38 ", strategy.getErrorMsg());
        }
    }

    private void updateData(List<ContextSettings> listInfo) throws InvalidProtocolBufferException {
        if (listInfo == null) {
            this.list.clear();
            this.map.clear();
            return;
        }
        ArrayList<XRepoStrategy> listTmp = new ArrayList<XRepoStrategy>();
        for (ContextSettings info : listInfo) {
            XRepoStrategy strategy = new XRepoStrategy();
            strategy.update((Object)info);
            listTmp.add(strategy);
        }
        this.list.update(listTmp);
    }

    public RespResult stopStrategy(String market, List<String> listId) throws MException {
        if (market.isEmpty()) {
            return null;
        }
        StopContextReq req = new StopContextReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setServiceType("XBOND_MARKET_MAKING");
        req.setAlgoId(listId);
        StopContextResp resp = this.api.stopStrategy(req);
        RespResult result = new RespResult();
        if (resp.getCtxResp() == null) {
            return result;
        }
        for (CtxResp ctx : resp.getCtxResp()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            result.incrementFailed(errorInfo);
        }
        return result;
    }

    public XRepoStrategy getXRepoStrategy(String contextId) {
        for (XRepoStrategy strategy : this.list.getList()) {
            if (!strategy.getContextId().equals(contextId)) continue;
            return strategy;
        }
        return null;
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public ObservableList<XRepoStrategy> getList() {
        return this.list.getList();
    }

    public final BooleanProperty statusChangedProperty() {
        return this.statusChanged;
    }

    public void statusChanged() {
        this.statusChanged.set(!this.statusChanged.get());
    }

    public XRepoStrategy getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(XRepoStrategy copyStrategy) {
        this.copyStrategy = copyStrategy;
    }
}

