/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.marketdata.dto.YieldData;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.OrderCancelReplaceRequest;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IUserService;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.MarketUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XRepoOrderModel
extends MxModel {
    @Inject
    private OrderServiceNewApi newApi;
    @Inject
    private TradeServiceApi tradeApi;
    @Inject
    protected MScheduler sdQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    private MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    private MxAlert alert;
    private static final int QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    protected MxList<Order> list = new MxList();
    protected Map<String, Order> mapUnfinish = new HashMap<String, Order>();
    private ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    protected Gson gson = GsonFactory.getInstance();
    protected boolean isUnfinishedOrder = false;
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    protected void init() {
        this.sdQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | IOException e) {
                String type = this.isUnfinishedOrder ? "\u672a\u5b8c\u6210" : "\u59d4\u6258";
                this.logger.error("xbond " + type + " query faild", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public void fullQuery() throws IOException, MException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        Instrument security = new Instrument();
        security.setMarketIndicator("COLLATERAL_REPO");
        req.setInstrument(security);
        ArrayList<String> extCashAccntIdList = new ArrayList<String>();
        Map cfetsAccountMap = this.accntMng.getCfetsAccountMap();
        for (CfetsFundAccount account : cfetsAccountMap.values()) {
            extCashAccntIdList.add(account.getNewCashAccntId());
        }
        if (extCashAccntIdList.isEmpty()) {
            return;
        }
        req.setExtCashAccntId(extCashAccntIdList);
        if (this.isUnfinishedOrder) {
            req.setCanCancelFlag(1);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        this.list.clear();
        this.mapUnfinish.clear();
        GetOrdersResp resp = this.newApi.getOrders(req);
        this.list.addAll(resp.getData());
        int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
        while (--queryTimes > 0) {
            fragment.setOffset(fragment.getSize() + fragment.getOffset());
            req.setFragment(fragment);
            GetOrdersResp res = this.newApi.getOrders(req);
            this.list.addAll(res.getData());
        }
        for (Order order : this.list.getList()) {
            order.setExtraFields();
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            order.setExtCashAccntId((String)extCashAccntIdList.get(0));
            this.afterUpdate(order);
        }
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!order.getInstrument().getMarket().equals("XCFE") || !order.getInstrument().getMarketIndicator().equals("COLLATERAL_REPO")) continue;
            order.setExtraFields();
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            StringBuilder info = new StringBuilder(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210+++" : "\u59d4\u6258+++");
            info.append(" (");
            info.append("sysOrderId:").append(order.getOrderId()).append(", ");
            info.append("orderId:").append(order.getOrderId()).append(", ");
            info.append("price:").append(order.getPrice()).append(", ");
            info.append("status:").append(order.getOrdStatus()).append(", ");
            info.append("qty:").append(order.getOrderQty()).append(", ");
            info.append("dealQty:").append(order.getCumQty()).append(") ");
            info.append("hashCode:").append(System.identityHashCode((Object)this));
            info.append("_").append(order.getOrderId());
            this.logger.info(info.toString());
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                Order ord;
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                info = new StringBuilder(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210---" : "\u59d4\u6258---");
                info.append(", ");
                info.append("sysOrderId:").append(sysOrderId).append(", ");
                info.append("statusOld:").append(statusOld).append(", ");
                info.append("statusNow:").append(statusNow).append(", ");
                info.append("hashCode:").append(System.identityHashCode((Object)this));
                info.append("_").append(order.getOrderId());
                this.logger.info(info.toString());
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else if (order.isInactive()) {
                    this.statusMap.put(sysOrderId, -1);
                } else {
                    if (statusNow < statusOld) {
                        info = new StringBuilder(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001");
                        info.append(", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:");
                        info.append("hashCode:").append(System.identityHashCode((Object)this));
                        info.append("_").append(order.getOrderId());
                        this.logger.info(info.toString());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    ord = new Order();
                    ord.update(order);
                    if (order.isCanCancel()) {
                        this.afterUpdate(order);
                        this.list.updatePart((MxObject)ord);
                    } else if (this.list.getListMap().get(ord) != null) {
                        this.list.remove((MxObject)ord);
                    }
                } else {
                    ord = new Order();
                    this.afterUpdate(order);
                    ord.update(order);
                    this.list.updatePart((MxObject)ord);
                }
            }
        }
        this.changed();
    }

    private void afterUpdate(Order order) {
        if (order.isInactive() && ("48".equals(order.getOrdStatus().getValue()) || "49".equals(order.getOrdStatus().getValue()))) {
            order.setOrdStatus(OrdStatus.ORD_STATUS_INACTIVE);
        }
    }

    protected void afterUpdate(SingleOrder order) {
        if (order.isInactive() && ("48".equals(order.getOrdStatus().getValue()) || "49".equals(order.getOrdStatus().getValue()))) {
            order.setOrdStatus(OrdStatus.ORD_STATUS_INACTIVE);
        }
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    private Integer getStatusNo(SingleOrder order) {
        if (!order.isCanCancel()) {
            return 99999999;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            int qty = (int)order.getCumQty();
            if (order.getInstrument().getSecurityType().equals("BOND") && "XcfeXBond".equals(order.getInstrument().getSecuritySubType())) {
                qty /= 1000;
            }
            return 1000 + qty;
        }
        return -1;
    }

    public void orderCancelReplace(SingleOrder order, double price, double yield) throws MException {
        OrderCancelReplaceRequest req = new OrderCancelReplaceRequest();
        req.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = order.getInstrument();
        instrument.setMarketGroup(MarketUtils.getMarketGroup((String)instrument.getMarket()));
        req.setInstrument(instrument);
        req.setOrderId(order.getOrderId());
        req.setExtCashAccntId(order.getExtCashAccntId());
        req.setPrice(price);
        req.setOrdType(order.getOrdType());
        req.setTraderId(TraderModel.traderId);
        req.setYieldData(new YieldData(1, yield));
        this.tradeApi.orderCancelReplace(req);
    }

    public RespResult orderCancel(List<Order> list) {
        RespResult result = new RespResult();
        for (Order order : list) {
            try {
                this.orderCancel(order);
                result.incrementSuccessed();
            }
            catch (MException e) {
                result.incrementFailed(e.getMessage());
            }
        }
        return result;
    }

    public boolean orderCancel(Order order) throws MException {
        OrderCancelRequest req = new OrderCancelRequest();
        req.setOpUser(this.baseApi.getHttpOpUser());
        Instrument sec = new Instrument();
        sec.setSecurityId(order.getSecurityId());
        sec.setMarketGroup(order.getInstrument().getMarketGroup());
        sec.setMarket(order.getInstrument().getMarket());
        sec.setSecurityType(order.getInstrument().getSecurityType());
        sec.setSecuritySubType(order.getSecuritySubType());
        sec.setMarketIndicator("SBFWD");
        req.setInstrument(sec);
        req.setExtSecAccntId(order.getExtSecAccntId());
        req.setExtCashAccntId(order.getExtCashAccntId());
        req.setOrderId(order.getOrderId());
        OpStatus status = this.tradeApi.orderCancel(req);
        return status.getStatus() == 1;
    }

    public ObservableList<Order> getList() {
        return this.list.getList();
    }

    public Map<String, Order> getMapUnfinish() {
        return this.mapUnfinish;
    }
}

