/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.views.ICallBack;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.XBond;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.dto.YieldData;
import cms.tmx.http.api.strategy.api.CalculateServiceApi;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.CalcYieldReq;
import cms.tmx.http.api.strategy.dto.CalcYieldResp;
import cms.tmx.http.api.strategy.dto.ClearingMethod;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.PartySub;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.manage.api.CounterPartyServiceApi;
import cms.tmx.javafx.MxNode;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.utils.MarketUtils;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XBondTradeModel {
    private static final Logger logger = LogManager.getLogger(XBondTradeModel.class);
    private StringProperty extFundAccntId = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorsecId = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    public BooleanProperty buy = new SimpleBooleanProperty(true);
    public BooleanProperty sell = new SimpleBooleanProperty(false);
    private ObjectProperty<MxNode> matchTypeBuy = new SimpleObjectProperty();
    private ObjectProperty<MxNode> matchTypeSell = new SimpleObjectProperty();
    private ObjectProperty<MxNode> settlTypeBuy = new SimpleObjectProperty();
    private ObjectProperty<MxNode> settlTypeSell = new SimpleObjectProperty();
    private DoubleProperty priceBuy = new SimpleDoubleProperty();
    private DoubleProperty priceSell = new SimpleDoubleProperty();
    private DoubleProperty countBuy = new SimpleDoubleProperty();
    private DoubleProperty countSell = new SimpleDoubleProperty();
    private DoubleProperty yieldBuy = new SimpleDoubleProperty();
    private DoubleProperty yieldSell = new SimpleDoubleProperty();
    public XBond refItem = null;
    @Inject
    private TradeServiceApi api;
    @Inject
    private CounterPartyServiceApi api2;
    @Inject
    private CalculateServiceApi calcApi;
    @Inject
    private MConfService cs;
    @Inject
    private MEventService es;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    protected ExecutorService exe;
    private AtomicLong lastTimeBuy = new AtomicLong(0L);
    private AtomicLong lastTimeSell = new AtomicLong(0L);
    private MEventHandler cancelOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        int countSuc = 0;
        int countFailed = 0;
        StringBuilder str = new StringBuilder();
        for (Object obj : list) {
            if (!(obj instanceof SingleOrder)) continue;
            SingleOrder ctpOrder = (SingleOrder)SingleOrder.class.cast(obj);
            try {
                this.cancel(ctpOrder);
                ++countSuc;
            }
            catch (MException e) {
                ++countFailed;
                logger.error("\u64a4\u5355\u5931\u8d25", (Throwable)e);
                str.append(String.valueOf(ctpOrder.getOrderId()) + e.getMessage() + "\n");
            }
            event.put((Object)"suc.count", (Object)countSuc);
            event.put((Object)"fail.count", (Object)countFailed);
            event.put((Object)"fail.message", (Object)str);
        }
    };
    @Inject
    protected CcsEntrustFactory ef;
    private DecimalFormat decimalFormat = new DecimalFormat(",##0.0000");
    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
    public static final String PRICE = "PRICE";
    public static final String YIELD = "YIELD";
    private boolean lock = false;
    private CalcYieldResp resp = null;

    @PostConstruct
    public void init() {
        this.es.subscribe("xbond.cancel.order", this.cancelOrder);
    }

    public void submit() throws MException {
        NewOrderSingle order = new NewOrderSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = new Instrument();
        if (this.refItem != null) {
            security.setSecurityId(this.refItem.getCode());
            security.setMarket(this.refItem.getMarket());
            security.setMarketGroup(MarketUtils.getMarketGroup((String)this.refItem.getMarket()));
            security.setSecurityType(this.refItem.getType());
            security.setMarketIndicator("CBT");
            security.setSecuritySubType("XcfeXBond");
        }
        order.setInstrument(security);
        order.setOrdType(OrdType.ORD_TYPE_LIMIT);
        order.setExtCashAccntId((String)this.extFundAccntId.get());
        order.setExtSecAccntId((String)this.extSecAccntId.get());
        if (this.isBuy()) {
            order.setMatchType(MatchType.getMatchType((String)this.getMatchTypeBuy().getRaw()));
            order.setSettlType(SettlType.getSettlType((String)this.getSettlTypeBuy().getRaw()));
        } else {
            order.setMatchType(MatchType.getMatchType((String)this.getMatchTypeSell().getRaw()));
            order.setSettlType(SettlType.getSettlType((String)this.getSettlTypeSell().getRaw()));
        }
        order.setPreMarketBondIndicator("N");
        order.setCfetsUserId(TraderModel.traderId);
        Party party = new Party();
        party.setPartyId(this.cs.getValue("partyId"));
        party.setPartyRole("EXECUTING_FIRM");
        PartySub sub = new PartySub();
        sub.setPartySubId(TraderModel.traderId);
        sub.setPartySubIdType("PERSON");
        party.getPartySub().add(sub);
        order.getParty().add(party);
        order.setSide(this.isBuy() ? Side.SIDE_BID : Side.SIDE_OFFER);
        order.setPrice(this.isBuy() ? this.getPriceBuy() : this.getPriceSell());
        order.setYieldData(new YieldData(1, this.isBuy() ? this.getYieldBuy() : this.getYieldSell()));
        order.setOrderQty(this.isBuy() ? this.getCountBuy() * 1.0E7 : this.getCountSell() * 1.0E7);
        order.setClearingMethod(ClearingMethod.CLEARINGMETHOD_SELF_CLEARING);
        this.api.newOrderSingle(order);
    }

    public void cancel(SingleOrder singleOrder) throws MException {
        OrderCancelRequest order = new OrderCancelRequest();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument instrument = singleOrder.getInstrument();
        instrument.setMarketGroup(MarketUtils.getMarketGroup((String)instrument.getMarket()));
        order.setInstrument(instrument);
        order.setOrderId(singleOrder.getOrderId());
        Party party = new Party();
        party.setPartyId(this.cs.getValue("partyId"));
        party.setPartyRole("EXECUTING_FIRM");
        PartySub sub = new PartySub();
        sub.setPartySubId(TraderModel.traderId);
        sub.setPartySubIdType("PERSON");
        party.getPartySub().add(sub);
        order.getParty().add(party);
        this.api.orderCancel(order);
    }

    public List<CcsSingleEntrust> getEntrustList() {
        CcsSingleEntrust en;
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        if (this.isBuy()) {
            en = this.ef.createCcsSingle((String)this.extFundAccntId.get(), (String)this.extSecAccntId.get());
            en.setInvestorId((String)this.investorId.get());
            en.setInvestorSecId((String)this.investorsecId.get());
            en.setSide(49);
            en.setQuantity((long)(this.getCountBuy() * 1000.0));
            en.setMarket(this.refItem.getMarket());
            en.setSecType(this.refItem.getType());
            en.setPrice(this.getPriceBuy());
            en.setOrderType(50);
            en.setSec(this.refItem.getCode());
            en.setSecName(this.refItem.getName());
            en.setAppID("010");
            en.setInstructionId(this.getMatchTypeBuy().getValue());
            en.setResourceId(this.getSettlTypeBuy().getValue());
            en.setTip(String.valueOf(this.decimalFormat.format(this.getYieldBuy())) + "%");
            enList.add(en);
        }
        if (this.isSell()) {
            en = this.ef.createCcsSingle((String)this.extFundAccntId.get(), (String)this.extSecAccntId.get());
            en.setInvestorId((String)this.investorId.get());
            en.setInvestorSecId((String)this.investorsecId.get());
            en.setSide(50);
            en.setQuantity((long)(this.getCountSell() * 1000.0));
            en.setMarket(this.refItem.getMarket());
            en.setSecType(this.refItem.getType());
            en.setPrice(this.getPriceSell());
            en.setOrderType(50);
            en.setSec(this.refItem.getCode());
            en.setSecName(this.refItem.getName());
            en.setAppID("010");
            en.setInstructionId(this.getMatchTypeSell().getValue());
            en.setResourceId(this.getSettlTypeSell().getValue());
            en.setTip(String.valueOf(this.decimalFormat.format(this.getYieldSell())) + "%");
            enList.add(en);
        }
        return enList;
    }

    public CalcYieldResp getResp() {
        return this.resp;
    }

    public void setResp(CalcYieldResp resp) {
        this.resp = resp;
    }

    public void calcYieldResp(String change, ICallBack call) {
        double yield;
        if (this.lock) {
            return;
        }
        if (this.refItem == null) {
            this.setResp(null);
            return;
        }
        boolean isBuy = this.isBuy();
        long nowTime = System.currentTimeMillis();
        AtomicLong lastTime = isBuy ? this.lastTimeBuy : this.lastTimeSell;
        lastTime.set(nowTime);
        double price = isBuy ? this.getPriceBuy() : this.getPriceSell();
        double d = yield = isBuy ? this.getYieldBuy() : this.getYieldSell();
        if (change.equals(PRICE) && price == 0.0) {
            if (this.isBuy()) {
                this.setYieldBuy(0.0);
            } else {
                this.setYieldSell(0.0);
            }
            this.setResp(null);
            return;
        }
        if (change.equals(YIELD) && yield == 0.0) {
            if (isBuy) {
                this.setPriceBuy(0.0);
            } else {
                this.setPriceSell(0.0);
            }
            this.setResp(null);
            return;
        }
        CalcYieldReq req = new CalcYieldReq();
        Instrument ins = new Instrument();
        ins.setSecurityId(this.refItem.getCode());
        ins.setMarket(this.refItem.getMarket());
        ins.setMarketGroup(MarketUtils.getMarketGroup((String)this.refItem.getMarket()));
        ins.setSecurityType(this.refItem.getType());
        req.setInstrument(ins);
        if (change.equals(PRICE)) {
            req.setCleanPx(price);
        } else {
            req.setYield(yield / 100.0);
        }
        req.setSettlDate(call.getSettlDate());
        this.exe.execute(() -> {
            CalcYieldResp resp;
            block5: {
                resp = this.calcApi.getYield(req);
                if (lastTime.get() == nowTime) break block5;
                Platform.runLater(() -> call.resetExtraInfo());
                return;
            }
            try {
                try {
                    Platform.runLater(() -> {
                        this.lock = true;
                        if (isBuy) {
                            if (change.equals(PRICE)) {
                                this.setYieldBuy((double)(100L * Math.round(resp.getYield() * 1000000.0)) / 1000000.0);
                            } else {
                                this.setPriceBuy((double)Math.round(resp.getCleanPx() * 10000.0) / 10000.0);
                            }
                        } else if (change.equals(PRICE)) {
                            this.setYieldSell((double)(100L * Math.round(resp.getYield() * 1000000.0)) / 1000000.0);
                        } else {
                            this.setPriceSell((double)Math.round(resp.getCleanPx() * 10000.0) / 10000.0);
                        }
                        this.lock = false;
                        this.resp = resp;
                    });
                }
                catch (MException | Exception e) {
                    this.lock = false;
                    this.setResp(null);
                    logger.error("xbond\u8ba1\u7b97\u5230\u671f\u6536\u76ca\u7387\u62a5\u9519\uff1a" + e.getMessage(), e);
                    Platform.runLater(() -> call.resetExtraInfo());
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> call.resetExtraInfo());
                throw throwable;
            }
            Platform.runLater(() -> call.resetExtraInfo());
        });
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final DoubleProperty priceBuyProperty() {
        return this.priceBuy;
    }

    public final double getPriceBuy() {
        return this.priceBuyProperty().get();
    }

    public final void setPriceBuy(double priceBuy) {
        this.priceBuyProperty().set(priceBuy);
    }

    public final DoubleProperty priceSellProperty() {
        return this.priceSell;
    }

    public final double getPriceSell() {
        return this.priceSellProperty().get();
    }

    public final void setPriceSell(double priceSell) {
        this.priceSellProperty().set(priceSell);
    }

    public final DoubleProperty countBuyProperty() {
        return this.countBuy;
    }

    public final double getCountBuy() {
        return this.countBuyProperty().get();
    }

    public final void setCountBuy(double countBuy) {
        this.countBuyProperty().set(countBuy);
    }

    public final DoubleProperty countSellProperty() {
        return this.countSell;
    }

    public final double getCountSell() {
        return this.countSellProperty().get();
    }

    public final void setCountSell(double countSell) {
        this.countSellProperty().set(countSell);
    }

    public final ObjectProperty<MxNode> matchTypeBuyProperty() {
        return this.matchTypeBuy;
    }

    public final MxNode getMatchTypeBuy() {
        return (MxNode)this.matchTypeBuyProperty().get();
    }

    public final void setMatchTypeBuy(MxNode matchTypeBuy) {
        this.matchTypeBuyProperty().set((Object)matchTypeBuy);
    }

    public final ObjectProperty<MxNode> matchTypeSellProperty() {
        return this.matchTypeSell;
    }

    public final MxNode getMatchTypeSell() {
        return (MxNode)this.matchTypeSellProperty().get();
    }

    public final void setMatchTypeSell(MxNode matchTypeSell) {
        this.matchTypeSellProperty().set((Object)matchTypeSell);
    }

    public final ObjectProperty<MxNode> settlTypeBuyProperty() {
        return this.settlTypeBuy;
    }

    public final MxNode getSettlTypeBuy() {
        return (MxNode)this.settlTypeBuyProperty().get();
    }

    public final void setSettlTypeBuy(MxNode settlTypeBuy) {
        this.settlTypeBuyProperty().set((Object)settlTypeBuy);
    }

    public final ObjectProperty<MxNode> settlTypeSellProperty() {
        return this.settlTypeSell;
    }

    public final MxNode getSettlTypeSell() {
        return (MxNode)this.settlTypeSellProperty().get();
    }

    public final void setSettlTypeSell(MxNode settlTypeSell) {
        this.settlTypeSellProperty().set((Object)settlTypeSell);
    }

    public final BooleanProperty sellProperty() {
        return this.sell;
    }

    public final boolean isSell() {
        return this.sellProperty().get();
    }

    public final void setSell(boolean sell) {
        this.sellProperty().set(sell);
    }

    public final DoubleProperty yieldBuyProperty() {
        return this.yieldBuy;
    }

    public final double getYieldBuy() {
        return this.yieldBuyProperty().get();
    }

    public final void setYieldBuy(double yieldBuy) {
        this.yieldBuyProperty().set(yieldBuy);
    }

    public final DoubleProperty yieldSellProperty() {
        return this.yieldSell;
    }

    public final double getYieldSell() {
        return this.yieldSellProperty().get();
    }

    public final void setYieldSell(double yieldSell) {
        this.yieldSellProperty().set(yieldSell);
    }

    public final StringProperty extFundAccntIdProperty() {
        return this.extFundAccntId;
    }

    public final String getExtFundAccntId() {
        return (String)this.extFundAccntIdProperty().get();
    }

    public final void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntIdProperty().set((Object)extFundAccntId);
    }

    public final StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorsecIdProperty() {
        return this.investorsecId;
    }

    public final String getInvestorsecId() {
        return (String)this.investorsecIdProperty().get();
    }

    public final void setInvestorsecId(String investorsecId) {
        this.investorsecIdProperty().set((Object)investorsecId);
    }
}

