/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.define.IErrorMsg;
import cms.tmx.entity.trade.XBondStrategy;
import cms.tmx.entity.trade.XBondStrategySerialize;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.api.MarketDataApi;
import cms.tmx.http.api.marketdata.dto.InstrmtMDReq;
import cms.tmx.http.api.marketdata.dto.MDEntry;
import cms.tmx.http.api.marketdata.dto.MarketDataRequest;
import cms.tmx.http.api.marketdata.dto.MarketDataResponse;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.http.api.marketdata.dto.Message;
import cms.tmx.http.api.strategy.api.StrategyServiceApi;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.AccountSettings;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.CtxResp;
import cms.tmx.http.api.strategy.dto.CustomContextSettings;
import cms.tmx.http.api.strategy.dto.CustomSecuritySettings;
import cms.tmx.http.api.strategy.dto.DeleteCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.EventType;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsResp;
import cms.tmx.http.api.strategy.dto.HedgeSettings;
import cms.tmx.http.api.strategy.dto.NewCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.OrderMassCancelRequest;
import cms.tmx.http.api.strategy.dto.SecuritySettings;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.StartContextReq;
import cms.tmx.http.api.strategy.dto.StartContextResp;
import cms.tmx.http.api.strategy.dto.StopContextReq;
import cms.tmx.http.api.strategy.dto.StopContextResp;
import cms.tmx.http.api.strategy.dto.StrategyCondition;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.api.strategy.dto.UpdateCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.XbondContextSettings;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XBondStrategyModel
extends MxModel {
    @Inject
    private StrategyServiceApi api;
    @Inject
    private HttpBaseApi httpBaseApi;
    @Inject
    private TradeServiceNewApi tradeApi;
    public BooleanProperty statusChanged = new SimpleBooleanProperty();
    @Inject
    protected IBaseApi iba;
    @Inject
    protected MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected MScheduler sdYield;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private MxAlert alert;
    @Inject
    private MessagePromptMng msgMng;
    @Inject
    private IFundAccountService fundService;
    @Inject
    private MarketDataApi mktApi;
    private static final int FULL_QUERY_INTERVAL = 1000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    private static final int YIELD_INTERVAL = 1000;
    public static StringProperty refreshTime = new SimpleStringProperty("");
    public Map<String, XBondStrategy> map = new HashMap<String, XBondStrategy>();
    public BooleanProperty changedYield = new SimpleBooleanProperty();
    private MxList<XBondStrategy> list = new MxList();
    private XBondStrategy copyStrategy;
    protected Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);
    @Inject
    private IErrorMsg msg;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(1000);
        this.sdSpecQuery.setInterval(1000);
        this.sdYield.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.StrategyEvent", this.handler);
        this.es.subscribe("uap.push.ficc.marketdata", event -> this.onYieldPush(event));
        this.es.subscribe("requery_data", event -> this.query(true));
        this.es.subscribe("websocket.connected", event -> this.subYields((List<XBondStrategy>)this.list.getList()));
    }

    public void query(boolean all) {
        MScheduler sdQuery = all ? this.sdFullQuery : this.sdSpecQuery;
        sdQuery.schedule(event -> {
            try {
                this.fullQuery(all);
            }
            catch (MException | IOException e) {
                this.logger.error("xbond strategy query faild", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public synchronized void fullQuery(boolean all) throws IOException, MException {
        GetCtxSettingsReq req = new GetCtxSettingsReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setServiceType("XBOND_MARKET_MAKING");
        req.setTemplate(all);
        req.setPage(this.httpBaseApi.getHttpDefPage());
        GetCtxSettingsResp resp = this.api.getStrategy(req);
        this.updateData(resp.getSettings());
        this.changed();
    }

    protected void onPush(MEvent event) {
        JsonElement obj = (JsonElement)event.getObj();
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson(String.valueOf(obj), StrategyEvent.class);
        if (strategyEvent.getType().equals((Object)EventType.NOTICE)) {
            return;
        }
        ContextSettings context = (ContextSettings)this.gson.fromJson(strategyEvent.getDetails(), ContextSettings.class);
        if ("200,201,202,300".contains(String.valueOf(context.getExecModeType()))) {
            return;
        }
        XBondStrategy strategy = new XBondStrategy();
        try {
            strategy.update((Object)context);
        }
        catch (Exception e) {
            this.logger.error("xbond strategy push parse faild", (Throwable)e);
        }
        if (strategyEvent.getType().equals((Object)EventType.ADD)) {
            this.list.add((MxObject)strategy);
            this.subYields(Arrays.asList(strategy));
        } else if (strategyEvent.getType().equals((Object)EventType.UPDATE)) {
            XBondStrategy old = (XBondStrategy)this.list.get((MxObject)strategy);
            String yieldBid = old.getYieldBid();
            String yieldOffer = old.getYieldOffer();
            old.update((Object)strategy);
            old.setYieldBid(yieldBid);
            old.setYieldOffer(yieldOffer);
            this.triggerLimitCheck(strategy);
        } else if (strategyEvent.getType().equals((Object)EventType.DELETE)) {
            this.list.remove((MxObject)strategy);
            this.map.remove(strategy.getContextId());
        }
        this.changed();
    }

    private void onYieldPush(MEvent event) {
        if (event.getObj() instanceof MarketDataSnapshot) {
            this.updateMarketItems((MarketDataSnapshot)MarketDataSnapshot.class.cast(event.getObj()));
        }
    }

    private void updateMarketItems(MarketDataSnapshot snap) {
        Platform.runLater(() -> {
            if ("xbond_pricing".equals(snap.getMdType())) {
                String strategyId = snap.getInstrument().getSecurityId();
                XBondStrategy strategy = this.map.get(strategyId);
                strategy.setYieldBid("");
                strategy.setPriceBid("");
                strategy.setYieldOffer("");
                strategy.setPriceOffer("");
                if (snap.getEntry() == null) {
                    return;
                }
                for (MDEntry entry : snap.getEntry()) {
                    String yield;
                    Double yieldVal = entry.getYieldData().getYield();
                    String string = yield = yieldVal == null ? "" : StringUtils.toStr((double)yieldVal, (int)4);
                    if (entry.getMdEntryType() == 0) {
                        if (entry.getMdPriceLevel() == 1) {
                            strategy.setYieldBid(yield);
                            continue;
                        }
                        strategy.setPriceBid(yield);
                        continue;
                    }
                    if (entry.getMdPriceLevel() == 1) {
                        strategy.setYieldOffer(yield);
                        continue;
                    }
                    strategy.setPriceOffer(yield);
                }
                this.sdYield.schedule(event -> this.changedYield());
            }
        });
    }

    public void subYields(List<XBondStrategy> list) {
        ArrayList<InstrmtMDReq> listMdReq = new ArrayList<InstrmtMDReq>();
        for (XBondStrategy strategy : list) {
            this.map.put(strategy.getContextId(), strategy);
            Instrument inst = new Instrument();
            inst.setMarket(strategy.getMarket());
            inst.setSecurityId(strategy.getContextId());
            InstrmtMDReq mdReq = new InstrmtMDReq();
            mdReq.setInstrument(inst);
            mdReq.setMdType("xbond_pricing");
            listMdReq.add(mdReq);
        }
        MarketDataRequest req = new MarketDataRequest();
        req.setInstrmtMdReq(listMdReq);
        Message message = new Message();
        message.setTopic("ficc.marketdata");
        message.setData((Object)req);
        MEvent event = new MEvent();
        event.setObj((Object)message);
        try {
            MarketDataResponse resp = this.mktApi.queryMarketData(req);
            if (resp.getSnapshot() == null) {
                return;
            }
            for (MarketDataSnapshot snap : resp.getSnapshot()) {
                this.updateMarketItems(snap);
            }
        }
        catch (MException e) {
            this.logger.error("xbond strategy yield query", (Throwable)e);
        }
        req.setType(new MarketDataRequest().getType());
        this.es.postEvent("subscribe.market.data", event);
    }

    private void triggerLimitCheck(XBondStrategy strategy) {
        String msg = strategy.getErrorMsg();
        if (msg.contains("\u89e6\u53d1BID\u4e0a\u9650") || msg.contains("\u89e6\u53d1BID\u4e0b\u9650") || msg.contains("\u89e6\u53d1OFR\u4e0a\u9650") || msg.contains("\u89e6\u53d1OFR\u4e0b\u9650")) {
            String invesId = this.fundService.getCcsInvesId(strategy.getParentExtAccntId());
            this.msgMng.logger(invesId, "\u7b56\u7565\u5f02\u5e38 ", strategy.getErrorMsg());
        }
    }

    private void updateData(List<ContextSettings> listInfo) throws InvalidProtocolBufferException {
        if (listInfo == null) {
            this.list.clear();
            this.map.clear();
            return;
        }
        ArrayList<XBondStrategy> listTmp = new ArrayList<XBondStrategy>();
        for (ContextSettings info : listInfo) {
            XBondStrategy strategy = new XBondStrategy();
            try {
                strategy.update((Object)info);
            }
            catch (Exception e) {
                this.logger.error("xbond strategy query parse faild", (Throwable)e);
            }
            listTmp.add(strategy);
        }
        this.list.update(listTmp);
        this.subYields((List<XBondStrategy>)this.list.getList());
    }

    public ContextSettings getSettingsByStrategy(XBondStrategy strategy) throws MException {
        AccountSettings builderAcct = new AccountSettings();
        builderAcct.setParentExtAccntId(strategy.getParentExtAccntId());
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        Instrument builderInst = new Instrument();
        builderInst.setSecurityId(strategy.getSecurityId());
        builderInst.setSymbol(strategy.getSecurityName());
        builderInst.setSecurityType(strategy.getSecurityType());
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        ContextSettings builderCt = new ContextSettings();
        builderCt.setName(strategy.getName());
        builderCt.setAlgoId(strategy.getContextId());
        builderCt.setOpUser(this.httpBaseApi.getHttpOpUser());
        switch (strategy.getType().getRaw()) {
            case "11": 
            case "12": 
            case "13": {
                builderCt.setDetails((Object)this.packXbondDetails(builderAcct, strategy, builderInst));
                builderCt.setExecModeType(Integer.parseInt(strategy.getType().getRaw()));
                break;
            }
            case "16": 
            case "17": 
            case "18": 
            case "161718": {
                builderCt.setExecModeType(Integer.parseInt(strategy.getCustomBs()));
                builderCt.setDetails((Object)this.packCustomDetails(builderAcct, strategy, builderInst));
            }
        }
        builderCt.setTemplate(strategy.isTemplate());
        return builderCt;
    }

    private XbondContextSettings packXbondDetails(AccountSettings builderAcct, XBondStrategy strategy, Instrument builderInst) {
        BigDecimal bigDecimal;
        SecuritySettings builderSec = new SecuritySettings();
        builderSec.setInstrument(builderInst);
        int base = 10000000;
        String code = strategy.getSecurityId();
        LinkedList<StrategyCondition> conds = new LinkedList<StrategyCondition>();
        if (!strategy.getType().getRaw().equals("13")) {
            String ask1MinusBid1 = "[" + code + "]." + "ASK_1-" + "[" + code + "]." + "BID_1";
            conds.add(new StrategyCondition(ask1MinusBid1, strategy.getAsk1MinusBid1()));
            String ask2MinusBid2 = "[" + code + "]." + "ASK_2-" + "[" + code + "]." + "BID_2";
            conds.add(new StrategyCondition(ask2MinusBid2, strategy.getAsk2MinusBid2()));
            String askQty1 = "[" + code + "]." + "ASK_QTY_1";
            conds.add(new StrategyCondition(askQty1, strategy.getAskQty1() * (double)base));
            String bidQty1 = "[" + code + "]." + "BID_QTY_1";
            conds.add(new StrategyCondition(bidQty1, strategy.getAskQty1() * (double)base));
        } else if (strategy.getAskQty1() > 0.0) {
            String askQty1 = "[" + code + "]." + "ASK_QTY_1";
            conds.add(new StrategyCondition(askQty1, strategy.getAskQty1() * (double)base));
        } else {
            String bidQty1 = "[" + code + "]." + "BID_QTY_1";
            conds.add(new StrategyCondition(bidQty1, strategy.getBidQty1() * (double)base));
        }
        builderSec.setStrategyCondition(conds);
        if (strategy.getType().getRaw().equals("12")) {
            String askQty1PlusAskQty2 = "[" + code + "]." + "ASK_QTY_1+" + "[" + code + "]." + "ASK_QTY_2";
            conds.add(new StrategyCondition(askQty1PlusAskQty2, strategy.getAskQty1PlusAskQty2() * (double)base));
            String bidQty1PlusBidQty2 = "[" + code + "]." + "BID_QTY_1+" + "[" + code + "]." + "BID_QTY_2";
            conds.add(new StrategyCondition(bidQty1PlusBidQty2, strategy.getAskQty1PlusAskQty2() * (double)base));
        }
        String formula = "[" + code + "]." + strategy.getBasePrice().getRaw();
        if (strategy.getSpread() != 0.0) {
            bigDecimal = new BigDecimal((double)Math.round(strategy.getSpread() * 10000.0) / 10000.0);
            formula = String.valueOf(formula) + "+" + String.format("%.4f", bigDecimal);
        }
        builderSec.setBidRefPriceFormula(formula);
        if (formula.contains("BID")) {
            builderSec.setOfferRefPriceFormula(formula.replace("BID", "ASK").replace("+", "-"));
        } else {
            builderSec.setOfferRefPriceFormula(formula.replace("ASK", "BID").replace("+", "-"));
        }
        builderSec.setQty(Integer.valueOf(strategy.getQty() * base));
        builderSec.setMaxAllowFilledQty(Integer.valueOf((int)(strategy.getDealLimit() * (double)base)));
        builderSec.setSettlType(SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1);
        builderSec.setHedgeSettlType(SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1);
        if (StringUtils.belongto((String)strategy.getType().getRaw(), (String[])new String[]{"11", "13"})) {
            formula = "[" + code + "]." + strategy.getBasePriceHedge().getRaw();
            if (strategy.getSpreadHedge() != 0.0) {
                bigDecimal = new BigDecimal((double)Math.round(strategy.getSpreadHedge() * 10000.0) / 10000.0);
                formula = String.valueOf(formula) + "+" + String.format("%.4f", bigDecimal);
            }
            builderSec.setOfferHedgePriceFormula(formula);
            if (formula.contains("BID")) {
                builderSec.setBidHedgePriceFormula(formula.replace("BID", "ASK").replace("+", "-"));
            } else {
                builderSec.setBidHedgePriceFormula(formula.replace("ASK", "BID").replace("+", "-"));
            }
            builderSec.setHedgeInstrument(builderInst);
        }
        if (strategy.getType().getRaw().equals("13")) {
            if (strategy.getAskQty1() > 0.0) {
                builderSec.setBidRefPriceFormula("");
                builderSec.setBidHedgePriceFormula("");
            } else {
                builderSec.setOfferRefPriceFormula("");
                builderSec.setOfferHedgePriceFormula("");
            }
        }
        builderSec.setCfetsTraderId(TraderModel.traderId);
        XbondContextSettings builderCtx = new XbondContextSettings();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        return builderCtx;
    }

    private CustomContextSettings packCustomDetails(AccountSettings builderAcct, XBondStrategy strategy, Instrument builderInst) {
        CustomSecuritySettings builderSec = new CustomSecuritySettings();
        builderSec.setInstrument(builderInst);
        if (!"17".equals(strategy.getCustomBs())) {
            String bifRefPriceFormula = strategy.getBidRefPriceFormula();
            BigDecimal bidSpdBig = new BigDecimal(strategy.getBidSpread() / 100.0).setScale(4, 4);
            String bidSpread = bidSpdBig.toString();
            String opBid = strategy.isAttackBuy() ? "-" : "+";
            builderSec.setBidRefPriceFormula(String.valueOf(bifRefPriceFormula) + opBid + bidSpread);
            builderSec.setBidUpLimit(strategy.getBidUpLimit());
            builderSec.setBidFloorLimit(strategy.getBidFloorLimit());
        }
        if (!"16".equals(strategy.getCustomBs())) {
            String offerRefPriceFormula = strategy.getOfferRefPriceFormula();
            BigDecimal askSpdBig = new BigDecimal(strategy.getAskSpread() / 100.0).setScale(4, 4);
            String askSpread = askSpdBig.toString();
            String opOffer = strategy.isAttackSell() ? "+" : "-";
            builderSec.setOfferRefPriceFormula(String.valueOf(offerRefPriceFormula) + opOffer + askSpread);
            builderSec.setOfferUpLimit(strategy.getOfferUpLimit());
            builderSec.setOfferFloorLimit(strategy.getOfferFloorLimit());
        }
        builderSec.setFullFilledCancel(Boolean.valueOf(strategy.getCancelType().getRaw()).booleanValue());
        builderSec.setBidPriceSlip(strategy.getBidPriceSlip() / 100.0);
        builderSec.setOfferPriceSlip(strategy.getBidPriceSlip() / 100.0);
        builderSec.setBidQty((int)(strategy.getBidQty() * 1000.0 * 10000.0));
        builderSec.setOfferQty((int)(strategy.getAskQty() * 1000.0 * 10000.0));
        builderSec.setMaxAllowFilledQty((int)(strategy.getMaxDeal() * 1000.0 * 10000.0));
        builderSec.setSettlType(SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1);
        builderSec.setCfetsTraderId(TraderModel.traderId);
        builderSec.setExposureEnable(false);
        builderSec.setDelay(true);
        HedgeSettings builderHedge = new HedgeSettings();
        Instrument HedgeInst = new Instrument();
        HedgeInst.setSecurityId(strategy.getHedgeContract().getCode());
        HedgeInst.setSymbol(strategy.getHedgeContract().getName());
        HedgeInst.setSecurityType(strategy.getHedgeContract().getType());
        HedgeInst.setMarket(strategy.getHedgeContract().getMarket());
        HedgeInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getHedgeContract().getMarket()));
        HedgeInst.setApplId("010");
        builderHedge.setHedgeInstrument(HedgeInst);
        if (!strategy.getBidHedgePriceFormula().isEmpty() || !strategy.getOfferHedgePriceFormula().isEmpty()) {
            builderHedge.setBidHedgePriceFormula(strategy.getBidHedgePriceFormula());
            builderHedge.setOfferHedgePriceFormula(strategy.getOfferHedgePriceFormula());
            builderHedge.setAlgoContractQtyScale(strategy.getMarketMakingCount());
            builderHedge.setHedgeContractQtyScale(strategy.getHedgeCount());
            builderHedge.setTimeoutFill(strategy.getTimeoutFill() * 1000);
            builderHedge.setStoplossFill(strategy.getStoplossFill() / 100.0);
            builderHedge.setHedgeSettlType(SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1);
        }
        CustomContextSettings builderCtx = new CustomContextSettings();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        builderCtx.setHedge(builderHedge);
        return builderCtx;
    }

    public void addStrategy(XBondStrategy strategy) throws MException {
        NewCtxSettingsReq builder = new NewCtxSettingsReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("XBOND_MARKET_MAKING");
        this.api.addStrategy(builder);
    }

    public void addStrategy(XBondStrategySerialize strategySlize) throws MException {
        NewCtxSettingsReq builder = new NewCtxSettingsReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        XBondStrategy strategy = new XBondStrategy();
        strategy.update((Object)strategySlize);
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("XBOND_MARKET_MAKING");
        this.api.addStrategy(builder);
    }

    public void updateStrategy(XBondStrategy strategy) throws MException {
        UpdateCtxSettingsReq builder = new UpdateCtxSettingsReq();
        builder.setOpUser(this.httpBaseApi.getHttpOpUser());
        builder.setSettings(this.getSettingsByStrategy(strategy));
        builder.setServiceType("XBOND_MARKET_MAKING");
        this.api.updateStrategy(builder);
    }

    public void delStrategy(String market, String contextId) throws MException {
        DeleteCtxSettingsReq req = new DeleteCtxSettingsReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setAlgoId(contextId);
        req.setServiceType("XBOND_MARKET_MAKING");
        this.api.deleteStrategy(req);
    }

    public Map<String, String> startStrategy(List<String> listId) throws MException {
        StartContextReq req = new StartContextReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setServiceType("XBOND_MARKET_MAKING");
        req.getAlgoId().addAll(listId);
        StartContextResp resp = this.api.startStrategy(req);
        HashMap<String, String> map = new HashMap<String, String>();
        if (resp.getCtxResp() == null) {
            return map;
        }
        for (CtxResp ctx : resp.getCtxResp()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getAlgoId(), errorInfo);
        }
        return map;
    }

    public Map<String, String> stopStrategy(String market, List<String> listId) throws MException {
        if (market.isEmpty()) {
            return null;
        }
        StopContextReq req = new StopContextReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setServiceType("XBOND_MARKET_MAKING");
        req.setAlgoId(listId);
        StopContextResp resp = this.api.stopStrategy(req);
        HashMap<String, String> map = new HashMap<String, String>();
        if (resp.getCtxResp() == null) {
            return map;
        }
        for (CtxResp ctx : resp.getCtxResp()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getAlgoId(), errorInfo);
        }
        return map;
    }

    public void stopAll() throws MException {
        OrderMassCancelRequest req = new OrderMassCancelRequest();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        Instrument instrument = new Instrument();
        instrument.setMarketIndicator("CBT");
        req.setInstrument(instrument);
        req.setUserId(this.httpBaseApi.getHttpOpUser().getUserId());
        req.setTraderId(TraderModel.traderId);
        req.setPartyId(this.httpBaseApi.getHttpOpUser().getPartyId());
        this.tradeApi.orderMassCancel(req);
    }

    public XBondStrategy getXBondStrategy(String contextId) {
        for (XBondStrategy strategy : this.list.getList()) {
            if (!strategy.getContextId().equals(contextId)) continue;
            return strategy;
        }
        return null;
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public ObservableList<XBondStrategy> getList() {
        return this.list.getList();
    }

    public final BooleanProperty statusChangedProperty() {
        return this.statusChanged;
    }

    public void statusChanged() {
        this.statusChanged.set(!this.statusChanged.get());
    }

    public XBondStrategy getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(XBondStrategy copyStrategy) {
        this.copyStrategy = copyStrategy;
    }

    public BooleanProperty changedYieldProperty() {
        return this.changedYield;
    }

    public void changedYield() {
        this.changedYield.set(!this.changedYield.get());
    }
}

