/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.web.resp.Bond;
import cms.tmx.entity.web.resp.BondClassify;
import cms.tmx.entity.web.resp.ResponseData;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.ContractServiceApi;
import cms.tmx.http.api.strategy.dto.GetXbondSubContractsReq;
import cms.tmx.http.api.strategy.dto.GetXbondSubContractsResp;
import cms.tmx.http.api.strategy.dto.XbondSubContractSetting;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.web.api.core.HttpClientService;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XBondQuoteMktModel
extends MxModel {
    private ObservableList<MarketItem> marketContinueList = FxUtils.newList();
    private ObservableList<MarketItem> marketCentralList = FxUtils.newList();
    @Inject
    private MarketDataModel marketMng;
    @Inject
    private ExecutorService exe;
    @Inject
    private HttpClientService httpClient;
    @Inject
    private MarketDataModel marketDataModel;
    @Inject
    protected IRefDataMng ref;
    @Inject
    private ContractServiceApi contractApi;
    @Inject
    private HttpBaseApi baseApi;
    private Gson gson = new Gson();
    private Map<String, String> map = new HashMap<String, String>();
    @Inject
    private MEventService es;
    private List<String> preferList = new ArrayList<String>();

    @PostConstruct
    public void init() {
        this.es.subscribe("requery_data", event -> this.querySubscribedContract());
    }

    public void querySubscribedContract() {
        this.exe.execute(() -> {
            GetXbondSubContractsReq request = new GetXbondSubContractsReq();
            request.setOpUser(this.baseApi.getHttpOpUser());
            GetXbondSubContractsResp xbondSubContracts = null;
            try {
                xbondSubContracts = this.contractApi.getXbondSubContracts(request);
            }
            catch (MException | IOException e) {
                this.logger.error("Get Xbond Sub Contracts faild:", (Object)e.getMessage());
            }
            if (xbondSubContracts == null) {
                return;
            }
            HashSet<RefItem> list = new HashSet<RefItem>();
            this.map.clear();
            for (XbondSubContractSetting bond : xbondSubContracts.getSetting()) {
                if (bond.getInstrument() == null) continue;
                String key = String.valueOf(bond.getInstrument().getSecurityId()) + "_" + bond.getSettlType();
                this.map.put(key, key);
                RefItem item = this.ref.getItem("BONDXcfeXBond", "XCFE", bond.getInstrument().getSecurityId());
                if (item == null) continue;
                list.add(item);
            }
            this.marketDataModel.subMarketItems(new ArrayList(list));
            this.marketContinueList.clear();
            this.marketCentralList.clear();
            for (RefItem item : list) {
                Map itemList = (Map)this.marketMng.getMapInfo().get(item);
                for (MarketItem mktItem : itemList.values()) {
                    if (this.map.get(String.valueOf(item.getCode()) + "_" + mktItem.getSettlType()) == null) continue;
                    if (mktItem.getMdBookType() == 2) {
                        this.marketContinueList.add((Object)mktItem);
                        continue;
                    }
                    this.marketCentralList.add((Object)mktItem);
                }
            }
            this.changed();
        });
    }

    public List<String> getPreferList() {
        return this.preferList;
    }

    public void resetPreferList(BondClassify bondClassify) {
        this.preferList.clear();
        if (bondClassify == null) {
            return;
        }
        this.exe.execute(() -> {
            HashMap<String, String> paramMap2 = new HashMap<String, String>();
            paramMap2.put("id", bondClassify.getId());
            paramMap2.put("needBondList", "true");
            try {
                String json = this.httpClient.doGet("/bond-classify/query", paramMap2, true);
                ResponseData resp = (ResponseData)this.gson.fromJson(json, new TypeToken<ResponseData<BondClassify>>(){}.getType());
                List bondList = ((BondClassify)resp.getRes()).getBondList();
                if (bondList != null) {
                    for (Bond bond : bondList) {
                        this.preferList.add(bond.getSecurityId());
                    }
                }
                this.changed();
            }
            catch (MException e) {
                e.printStackTrace();
            }
        });
    }

    public ObservableList<MarketItem> getContinueList() {
        return this.marketContinueList;
    }

    public ObservableList<MarketItem> getCentralList() {
        return this.marketCentralList;
    }
}

