/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.PosEvent;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.http.api.strategy.dto.ResetPosReq;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CcsAccountMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XBondPositionModel
extends MxModel {
    @Inject
    private PositionServiceApi api;
    @Inject
    protected MScheduler sdQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    private MxAlert alert;
    private static final int QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    private List<Position> list = new ArrayList<Position>();
    private Map<String, Position> map = new HashMap<String, Position>();
    private Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    private void init() {
        this.sdQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.PosEvent", this.handler);
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | IOException e) {
                this.logger.error("xbond position query faild", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    private void fullQuery() throws IOException, MException {
        GetPositionsReq req = new GetPositionsReq();
        Collection values = this.accountMap.getCfetsSecAccountMap().values();
        LinkedList<String> extSecAccntIds = new LinkedList<String>();
        for (SecAccount secAccount : values) {
            extSecAccntIds.add(secAccount.getExtSecAccntId());
        }
        if (extSecAccntIds.isEmpty()) {
            return;
        }
        req.setAccntId(extSecAccntIds);
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetExtPositionsResp resp = this.api.getPositions(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getRealPosition());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetExtPositionsResp res = this.api.getPositions(req);
            this.list.addAll(res.getRealPosition());
        }
        for (Position position : this.list) {
            position.transformQty();
            this.map.put(String.valueOf(position.getPosAccnt().getSecAccntId()) + position.getInstrument().getSecurityId(), position);
        }
        this.changed();
    }

    public void resetPosition(ResetPosReq req) throws IOException, MException {
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        this.api.resetPositions(req);
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PosEvent posEvent = (PosEvent)this.gson.fromJson((JsonElement)obj, PosEvent.class);
        for (Positions position : posEvent.getPosition()) {
            List posStatistic;
            if (AccntType.ACCNT_TYPE_SEC != position.getAccntType() || !"XCFE".equals(position.getInstrument().getMarket()) || (posStatistic = position.getPosStatistic()) == null) continue;
            for (PosStatistic stastic : posStatistic) {
                Position realPosition = new Position();
                realPosition.setPosStatistic(stastic);
                realPosition.update((Object)position);
                realPosition.transformQty();
                if (this.map.get(String.valueOf(realPosition.getPosAccnt().getSecAccntId()) + realPosition.getInstrument().getSecurityId()) == null) {
                    this.map.put(String.valueOf(realPosition.getPosAccnt().getSecAccntId()) + realPosition.getInstrument().getSecurityId(), realPosition);
                    this.list.add(realPosition);
                    continue;
                }
                Position old = this.map.get(String.valueOf(realPosition.getPosAccnt().getSecAccntId()) + realPosition.getInstrument().getSecurityId());
                old.update((Object)realPosition);
            }
        }
        this.changed();
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public List<Position> getList() {
        return this.list;
    }
}

