/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.User;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.GetExecutionsReq;
import cms.tmx.http.api.strategy.dto.GetExecutionsResp;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class XBondDealModel
extends MxModel {
    @Inject
    private OrderServiceApi api;
    @Inject
    protected MScheduler sdQuery;
    @Inject
    protected MScheduler sdPush;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    private MxAlert alert;
    @Inject
    private IUserService userService;
    private static final int QUERY_INTERVAL = 1000;
    private static final int PUSH_INTERVAL = 1000;
    private List<Execution> list = new ArrayList<Execution>();
    private Map<String, Execution> map = new HashMap<String, Execution>();
    private Map<String, User> userMap = FxUtils.newMap();
    private Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    private void init() {
        this.sdQuery.setInterval(1000);
        this.sdPush.setInterval(1000);
        this.es.subscribe("uap.push.ExecEvent", this.handler);
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | IOException e) {
                this.logger.error("xbond deal query faild", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    private void fullQuery() throws IOException, MException {
        GetExecutionsReq req = new GetExecutionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("IB");
        Instrument security = new Instrument();
        security.setMarketIndicator("CBT");
        req.setInstrument(security);
        ArrayList<String> extCashAccntIdList = new ArrayList<String>();
        Map cfetsAccountMap = this.accntMng.getCfetsAccountMap();
        for (CfetsFundAccount account : cfetsAccountMap.values()) {
            extCashAccntIdList.add(account.getNewCashAccntId());
        }
        if (extCashAccntIdList.isEmpty()) {
            return;
        }
        req.setExtCashAccntId(extCashAccntIdList);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetExecutionsResp resp = this.api.getDeals(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getExecution());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetExecutionsResp res = this.api.getDeals(req);
            this.list.addAll(res.getExecution());
        }
        for (Execution exe : this.list) {
            exe.setExtraFields();
            exe.setUserName(this.getUserName(exe.getUserId()));
            this.map.put(exe.getExecId(), exe);
        }
        this.changed();
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)this.gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution exec : execEvent.getExecution()) {
            if (!exec.getInstrument().getMarket().equals("XCFE") || !exec.getInstrument().getMarketIndicator().equals("CBT")) continue;
            exec.setExtraFields();
            exec.setUserName(this.getUserName(exec.getUserId()));
            this.map.put(exec.getExecId(), exec);
            this.list.add(exec);
            StringBuilder info = new StringBuilder();
            info.append("\u59d4\u6258\u7f16\u53f7\uff1a").append(exec.getSysOrderId()).append(", ");
            info.append("\u6210\u4ea4\u7f16\u53f7\uff1a").append(exec.getExecId()).append(", ");
            info.append("\u4ef7\u683c\uff1a").append(exec.getLastPx()).append(", ");
            info.append("\u6570\u91cf\uff1a").append(exec.getLastQty()).append(", ");
            this.logger.info(info.toString());
        }
        this.changed();
    }

    private String getUserName(String userId) {
        String name = "";
        if (StringUtils.isEmpty((String)userId)) {
            return name;
        }
        User user = this.userMap.get(userId);
        try {
            if (user == null) {
                user = this.userService.getUserDetail(userId);
                this.userMap.put(userId, user);
            }
        }
        catch (MException e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u5931\u8d25", (Throwable)e);
        }
        return user == null ? "" : user.getName();
    }

    public void changed() {
        this.sdPush.schedule(e -> super.changed());
    }

    public List<Execution> getList() {
        return this.list;
    }
}

