/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.XBond;
import cms.tmx.entity.data.XBondDealMarketItem;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.dto.InstrmtMDReq;
import cms.tmx.http.api.marketdata.dto.MarketDataRequest;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.http.api.marketdata.dto.Message;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XBondDealMarketModel
extends MxModel {
    private MxList<XBondDealMarketItem> list = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private IRefDataMng refMng;

    public List<XBondDealMarketItem> getList() {
        return this.list.getList();
    }

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.ficc.marketdata", event -> this.onMarketItemPush(event));
        this.es.subscribe("websocket.connected", event -> this.subscribe("*"));
    }

    private void onMarketItemPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof MarketDataSnapshot)) {
            return;
        }
        MarketDataSnapshot snap = (MarketDataSnapshot)obj;
        if ("CBDeal".equals(snap.getMdType())) {
            this.updateMarketItems(snap);
        }
    }

    private void updateMarketItems(MarketDataSnapshot snap) {
        String code;
        String market = snap.getInstrument().getMarket();
        RefItem refItem = this.refMng.getItem(market, code = snap.getInstrument().getSecurityId());
        if (refItem == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[market]: no ref item " + code);
            }
            return;
        }
        XBondDealMarketItem mktItem = new XBondDealMarketItem(market, code);
        mktItem.setName(refItem.getName());
        if (refItem instanceof XBond) {
            XBond bond = (XBond)refItem;
            mktItem.setTermToMaturityString(bond.getTermToMaturityString());
            mktItem.setRating(bond.getRatLvl());
        }
        mktItem.update((Object)snap);
        if (this.list.getListMap().get(mktItem) == null) {
            this.list.add((MxObject)mktItem);
        } else {
            ((XBondDealMarketItem)this.list.get((MxObject)mktItem)).update((Object)mktItem);
        }
        this.changed();
    }

    public void subscribe(String code) {
        Message message = new Message();
        MarketDataRequest req = new MarketDataRequest();
        ArrayList<InstrmtMDReq> list = new ArrayList<InstrmtMDReq>();
        InstrmtMDReq ins = new InstrmtMDReq();
        Instrument inst = new Instrument();
        inst.setMarket("XCFE");
        inst.setSecurityType("BOND");
        inst.setSecuritySubType("XcfeXBond");
        inst.setSecurityId(code);
        ins.setInstrument(inst);
        ins.setMdType("CBDeal");
        list.add(ins);
        req.setInstrmtMdReq(list);
        message.setTopic("ficc.marketdata");
        message.setData((Object)req);
        MEvent event = new MEvent();
        event.setObj((Object)message);
        this.es.postEvent("subscribe.market.data", event);
    }
}

