/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.ClearingMethod;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.PartySub;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.utils.MarketUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StdBondForwardTradeModel {
    private static final Logger logger = LogManager.getLogger(StdBondForwardTradeModel.class);
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty time = new SimpleStringProperty("");
    public BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty count = new SimpleDoubleProperty();
    public StdBondForward refItem = null;
    @Inject
    private TradeServiceApi api;
    @Inject
    private MConfService cs;
    @Inject
    private MEventService es;
    @Inject
    private HttpBaseApi baseApi;
    private MEventHandler cancelOrder = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        int countSuc = 0;
        int countFailed = 0;
        StringBuilder str = new StringBuilder();
        for (Object obj : list) {
            if (!(obj instanceof SingleOrder)) continue;
            SingleOrder ctpOrder = (SingleOrder)SingleOrder.class.cast(obj);
            try {
                this.cancel(ctpOrder);
                ++countSuc;
            }
            catch (MException e) {
                ++countFailed;
                logger.error("\u64a4\u5355\u5931\u8d25", (Throwable)e);
                str.append(String.valueOf(ctpOrder.getOrderId()) + e.getMessage() + "\n");
            }
            event.put((Object)"suc.count", (Object)countSuc);
            event.put((Object)"fail.count", (Object)countFailed);
            event.put((Object)"fail.message", (Object)str);
        }
    };
    @Inject
    protected CcsEntrustFactory ef;

    @PostConstruct
    public void init() {
        this.es.subscribe("stdbond.cancel.order", this.cancelOrder);
    }

    public void submit() throws MException {
        NewOrderSingle order = new NewOrderSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = new Instrument();
        if (this.refItem != null) {
            security.setSecurityId(this.refItem.getCode());
            security.setMarket(this.refItem.getMarket());
            security.setMarketGroup(MarketUtils.getMarketGroup((String)this.refItem.getMarket()));
            security.setSecurityType(this.refItem.getType());
            security.setMarketIndicator("SBFWD");
            security.setSecuritySubType("CfetsXSwap");
        }
        order.setInstrument(security);
        order.setOrdType(OrdType.ORD_TYPE_LIMIT);
        order.setExtCashAccntId(this.cs.getValue("extFundAccntId"));
        order.setExtSecAccntId(this.cs.getValue("extSecAccntId"));
        order.setCfetsUserId(TraderModel.traderId);
        Party party = new Party();
        party.setPartyId(this.cs.getValue("partyId"));
        party.setPartyRole("EXECUTING_FIRM");
        PartySub sub = new PartySub();
        sub.setPartySubId(TraderModel.traderId);
        sub.setPartySubIdType("PERSON");
        party.getPartySub().add(sub);
        order.getParty().add(party);
        order.setSide(this.isBuy() ? Side.SIDE_BID : Side.SIDE_OFFER);
        order.setPrice(this.getPrice());
        order.setOrderQty(this.getCount() * 1.0E7);
        order.setClearingMethod(ClearingMethod.CLEARINGMETHOD_CLEAR_AGAINST_CENTRAL_COUNTERPARTY);
        String time = String.valueOf(new SimpleDateFormat("yyyyMMdd-").format(new Date())) + this.getTime() + ":00";
        order.setExpireTime(time);
        this.api.newOrderSingle(order);
    }

    public void cancel(SingleOrder singleOrder) throws MException {
        OrderCancelRequest order = new OrderCancelRequest();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = singleOrder.getInstrument();
        security.setMarketGroup(MarketUtils.getMarketGroup((String)security.getMarket()));
        order.setInstrument(security);
        order.setOrderId(singleOrder.getOrderId());
        Party party = new Party();
        party.setPartyId(this.cs.getValue("partyId"));
        party.setPartyRole("EXECUTING_FIRM");
        PartySub sub = new PartySub();
        sub.setPartySubId(TraderModel.traderId);
        sub.setPartySubIdType("PERSON");
        party.getPartySub().add(sub);
        order.getParty().add(party);
        this.api.orderCancel(order);
    }

    public List<CcsSingleEntrust> getEntrustList() {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        CcsSingleEntrust en = this.ef.createCcsSingle(this.cs.getValue("extFundAccntId"), this.cs.getValue("extSecAccntId"));
        en.setInvestorId(this.cs.getValue("extFundAccntId"));
        en.setInvestorSecId(this.cs.getValue("extSecAccntId"));
        en.setSide(this.buy.get() ? 49 : 50);
        en.setQuantity((long)(this.getCount() * 1.0E7));
        en.setMarket(this.refItem.getMarket());
        en.setSecType(this.refItem.getType());
        en.setPrice(this.getPrice());
        en.setOrderType(50);
        en.setSec(this.refItem.getCode());
        en.setSecName(this.refItem.getName());
        en.setAppID("010");
        enList.add(en);
        return enList;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }

    public final DoubleProperty countProperty() {
        return this.count;
    }

    public final double getCount() {
        return this.countProperty().get();
    }

    public final void setCount(double count) {
        this.countProperty().set(count);
    }
}

