/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.javafx.MxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StdBondForwardPositionModel
extends MxModel {
    @Inject
    private PositionServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    private List<Position> list = new ArrayList<Position>();

    public List<Position> getList() {
        return this.list;
    }

    public void query() throws IOException, MException {
        GetPositionsReq req = new GetPositionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("IB");
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetExtPositionsResp resp = this.api.getPositions(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getRealPosition());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetExtPositionsResp res = this.api.getPositions(req);
            this.list.addAll(res.getRealPosition());
        }
        for (Position position : this.list) {
            position.transformQty();
        }
        this.changed();
    }
}

