/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersReq;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StdBondForwardOrderModel
extends MxModel {
    @Inject
    private OrderServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    private List<SingleOrder> list = new CopyOnWriteArrayList<SingleOrder>();
    @Inject
    private MEventService es;
    private MEventHandler handler = event -> this.onPush(event);
    private Gson gson = new Gson();
    private Map<String, SingleOrder> map = new HashMap<String, SingleOrder>();

    public List<SingleOrder> getList() {
        return this.list;
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (this.map.get(order.getOrderId()) == null) {
                this.map.put(order.getOrderId(), order);
                this.list.add(order);
                continue;
            }
            SingleOrder old = this.map.get(order.getOrderId());
            old.update((Object)order);
        }
        this.changed();
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("uap.push.OrdEvent", this.handler);
    }

    public static void main(String[] args) {
        String json = "{\"aaa\":\"bbb\"}";
        Gson gson = new Gson();
        JsonElement cfr_ignored_0 = (JsonElement)gson.fromJson(json, JsonElement.class);
        JsonElement abc = new JsonParser().parse(json).getAsJsonObject().get("aaa");
        String cfr_ignored_1 = ":" + abc.getAsString();
    }

    public void query() throws IOException, MException {
        GetSingleOrdersReq req = new GetSingleOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("IB");
        Instrument instrument = new Instrument();
        instrument.setSecurityType("FORWARD");
        req.setInstrument(instrument);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetSingleOrdersResp resp = this.api.getOrders(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getOrder());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetSingleOrdersResp res = this.api.getOrders(req);
            this.list.addAll(res.getOrder());
        }
        for (SingleOrder order : this.list) {
            order.setExtraFields();
            this.map.put(order.getOrderId(), order);
        }
        this.changed();
    }
}

