/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.bond.models.BondForwardPricingModel;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.strategy.StdBondForward;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.pricingit.FeederServiceApi;
import cms.tmx.http.api.pricingit.ListQuoteSnapshotsReq;
import cms.tmx.http.api.pricingit.ListQuoteSnapshotsResp;
import cms.tmx.http.api.pricingit.Quote;
import cms.tmx.http.api.pricingit.QuoteSnapshot;
import cms.tmx.http.api.strategy.api.StrategyServiceApi;
import cms.tmx.http.api.strategy.dto.AccountSettings;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.DeleteCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.ExecMode;
import cms.tmx.http.api.strategy.dto.ExecModeType;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsResp;
import cms.tmx.http.api.strategy.dto.LegParams;
import cms.tmx.http.api.strategy.dto.NewCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.PartySub;
import cms.tmx.http.api.strategy.dto.SdfArbitrageContextSetting;
import cms.tmx.http.api.strategy.dto.StartContextReq;
import cms.tmx.http.api.strategy.dto.StartContextResp;
import cms.tmx.http.api.strategy.dto.StopContextReq;
import cms.tmx.http.api.strategy.dto.StopContextResp;
import cms.tmx.http.api.strategy.dto.UpdateCtxSettingsReq;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.utils.MarketUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StdBondForwardModel
extends MxModel {
    public static boolean isEditting = false;
    private static final Logger logger = LogManager.getLogger(BondForwardPricingModel.class);
    @Inject
    private StrategyServiceApi api;
    @Inject
    private FeederServiceApi feederService;
    private ObservableList<TreeItem<StdBondForward>> list = FxUtils.newList();
    @Inject
    protected HttpBaseApi iba;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private MObjFactory of;
    @Inject
    private MConfService cs;
    StdBondForward auto;
    TreeItem<StdBondForward> autoItem;
    StdBondForward manual;
    TreeItem<StdBondForward> manualItem;

    public ObservableList<TreeItem<StdBondForward>> getList() {
        return this.list;
    }

    @PostConstruct
    private void init() {
        this.ses.scheduleAtFixedRate(() -> {
            if (!isEditting) {
                try {
                    this.queryQuotes();
                }
                catch (MException e) {
                    e.printStackTrace();
                }
                this.changed();
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        this.auto = (StdBondForward)this.of.create(StdBondForward.class);
        this.autoItem = new TreeItem((Object)this.auto);
        this.manual = (StdBondForward)this.of.create(StdBondForward.class);
        this.manualItem = new TreeItem((Object)this.manual);
    }

    public void get() throws MException, IOException {
        GetCtxSettingsReq builder = new GetCtxSettingsReq();
        builder.setOpUser(this.iba.getHttpOpUser());
        builder.setMarket("XCFE");
        builder.setMarketGroup("IB");
        builder.setExecModeType(ExecModeType.EXEC_MODE_TYPE_SDF_ARBITRAGE.getValue());
        builder.setTemplate(true);
        GetCtxSettingsResp resp = this.api.getStrategy(builder);
        List jobs = resp.getSettings();
        if (jobs == null) {
            this.autoItem.getChildren().clear();
            this.manualItem.getChildren().clear();
            this.changed();
            return;
        }
        this.autoItem.getChildren().clear();
        this.manualItem.getChildren().clear();
        for (ContextSettings job : jobs) {
            StdBondForward strategy = (StdBondForward)this.of.create(StdBondForward.class);
            strategy.update(job);
            if (strategy.getExecMode() == ExecMode.kAutoMaticExecMode) {
                this.autoItem.getChildren().add((Object)new TreeItem((Object)strategy));
                continue;
            }
            if (strategy.getExecMode() != ExecMode.kManualExecMode) continue;
            this.manualItem.getChildren().add((Object)new TreeItem((Object)strategy));
        }
        this.autoItem.getChildren().sort((o1, o2) -> ((StdBondForward)o2.getValue()).getContextId().compareTo(((StdBondForward)o1.getValue()).getContextId()));
        this.manualItem.getChildren().sort((o1, o2) -> ((StdBondForward)o2.getValue()).getContextId().compareTo(((StdBondForward)o1.getValue()).getContextId()));
        this.queryQuotes();
        this.changed();
    }

    public ContextSettings getContextSettings(StdBondForward params) {
        Instrument security = new Instrument();
        security.setSecurityId(params.getInstSecId());
        security.setMarket(params.getMarket());
        security.setMarketGroup(MarketUtils.getMarketGroup((String)params.getMarket()));
        SdfArbitrageContextSetting bondForward = new SdfArbitrageContextSetting();
        bondForward.setPricingJobId(params.getPricingJobId());
        AccountSettings account = new AccountSettings();
        account.setExtFundAccntId(this.cs.getValue("extFundAccntId"));
        account.setExtSecAccntId(this.cs.getValue("extSecAccntId"));
        bondForward.setAccount(account);
        Party party = new Party();
        party.setPartyId(this.cs.getValue("partyId"));
        party.setPartyRole("EXECUTING_FIRM");
        PartySub sub = new PartySub();
        sub.setPartySubId(TraderModel.traderId);
        sub.setPartySubIdType("PERSON");
        party.getPartySub().add(sub);
        bondForward.getParty().add(party);
        bondForward.setInstrument(security);
        bondForward.setBidPrice(params.getCleanBid());
        bondForward.setOfferPrice(params.getCleanOfr());
        bondForward.setBidIrr(params.getIrr());
        bondForward.setOfferIrr(params.getIrr());
        bondForward.setBidSlip(params.getSlip());
        bondForward.setOfferSlip(params.getSlip());
        bondForward.setBidQty(params.getQtyBid());
        bondForward.setOfferQty(params.getQtyOfr());
        bondForward.setBidMaxAllowFilledQty(params.getQtyBidMax());
        bondForward.setOfferMaxAllowFilledQty(params.getQtyOfrMax());
        bondForward.setBidSpread(params.getSpread());
        bondForward.setOfferSpread(params.getSpread());
        if (ExecMode.kAutoMaticExecMode == params.getExecMode()) {
            bondForward.setExecMode(ExecMode.kAutoMaticExecMode);
        } else {
            bondForward.setExecMode(ExecMode.kManualExecMode);
        }
        LegParams legActive = new LegParams();
        Instrument securityAct = new Instrument();
        securityAct.setSecurityId(params.getActiveSecId());
        securityAct.setMarket(params.getActiveMarket());
        securityAct.setMarketGroup(MarketUtils.getMarketGroup((String)params.getActiveMarket()));
        legActive.setInstrument(securityAct);
        securityAct.setSecurityId(params.getActiveSecId());
        legActive.setBidYtm(params.getActiveBidYield());
        legActive.setOfferYtm(params.getActiveOfferYield());
        legActive.setBidSource(params.getActiveBidSource());
        legActive.setOfferSource(params.getActiveOfferSource());
        LegParams legInactive = new LegParams();
        Instrument securityInact = new Instrument();
        securityInact.setSecurityId(params.getInactiveSecId());
        securityInact.setMarket(params.getInactiveMarket());
        securityInact.setMarketGroup(MarketUtils.getMarketGroup((String)params.getInactiveMarket()));
        legInactive.setInstrument(securityInact);
        legInactive.setBidYtm(params.getInactiveBidYield());
        legInactive.setOfferYtm(params.getInactiveOfferYield());
        legInactive.setBidSource(params.getInactiveBidSource());
        legInactive.setOfferSource(params.getInactiveOfferSource());
        bondForward.getLeg().add(legActive);
        bondForward.getLeg().add(legInactive);
        ContextSettings builderCt = new ContextSettings();
        builderCt.setDetails((Object)bondForward);
        builderCt.setOpUser(this.iba.getHttpOpUser());
        builderCt.setTemplate(true);
        builderCt.setExecModeType(ExecModeType.EXEC_MODE_TYPE_SDF_ARBITRAGE.getValue());
        return builderCt;
    }

    public OpStatus add(StdBondForward params) throws MException {
        ContextSettings builderCt = this.getContextSettings(params);
        NewCtxSettingsReq req = new NewCtxSettingsReq();
        req.setOpUser(this.iba.getHttpOpUser());
        req.setSettings(builderCt);
        req.setMarketGroup(MarketUtils.getMarketGroup((String)params.getMarket()));
        return this.api.addStrategy(req);
    }

    public OpStatus update(StdBondForward params) throws MException {
        ContextSettings builderCt = this.getContextSettings(params);
        builderCt.setAlgoId(params.getContextId());
        UpdateCtxSettingsReq req = new UpdateCtxSettingsReq();
        req.setOpUser(this.iba.getHttpOpUser());
        req.setSettings(builderCt);
        req.setMarketGroup(MarketUtils.getMarketGroup((String)params.getMarket()));
        return this.api.updateStrategy(req);
    }

    public OpStatus delete(StdBondForward params) throws MException {
        DeleteCtxSettingsReq req = new DeleteCtxSettingsReq();
        req.setOpUser(this.iba.getHttpOpUser());
        req.setAlgoId(params.getContextId());
        req.setMarketGroup(MarketUtils.getMarketGroup((String)params.getMarket()));
        OpStatus response = this.api.deleteStrategy(req);
        return response;
    }

    public StartContextResp start(String market, List<String> ids) throws MException {
        if (market.isEmpty()) {
            return null;
        }
        StartContextReq req = new StartContextReq();
        req.setOpUser(this.iba.getHttpOpUser());
        req.setAlgoId(ids);
        req.setMarketGroup(MarketUtils.getMarketGroup((String)market));
        StartContextResp response = this.api.startStrategy(req);
        return response;
    }

    public StopContextResp stop(String market, List<String> ids) throws MException {
        if (market.isEmpty()) {
            return null;
        }
        StopContextReq req = new StopContextReq();
        req.setOpUser(this.iba.getHttpOpUser());
        req.setAlgoId(ids);
        req.setMarketGroup(MarketUtils.getMarketGroup((String)market));
        StopContextResp response = this.api.stopStrategy(req);
        return response;
    }

    public TreeItem<StdBondForward> getRoot() {
        TreeItem root = new TreeItem();
        this.auto.setInstSecId("-\u81ea\u52a8");
        this.manual.setInstSecId("-\u624b\u52a8");
        if (this.autoItem.getChildren().size() > 0) {
            root.getChildren().add(this.autoItem);
        }
        if (this.manualItem.getChildren().size() > 0) {
            root.getChildren().add(this.manualItem);
        }
        return root;
    }

    private void queryQuotes() throws MException {
        ListQuoteSnapshotsReq request = new ListQuoteSnapshotsReq();
        ListQuoteSnapshotsResp response = null;
        response = this.feederService.listQuoteSnapshots(request);
        List quotes = response.getSnapshots();
        for (QuoteSnapshot quote : quotes) {
            this.refreshStrategy(quote);
        }
    }

    private void refreshStrategy(QuoteSnapshot snapshot) {
        Quote quote = snapshot.getQuote();
        if (quote.getInstrument() == null) {
            return;
        }
        ArrayList list = new ArrayList();
        list.addAll(this.autoItem.getChildren());
        list.addAll(this.manualItem.getChildren());
        for (TreeItem item : list) {
            List underlyings;
            StdBondForward strategy = (StdBondForward)item.getValue();
            if (!strategy.getPricingJobId().equals(quote.getQuoteId())) continue;
            strategy.setRefBidPx(Double.valueOf(String.format("%.4f", quote.getBidCleanPx())).doubleValue());
            strategy.setRefOfferPx(Double.valueOf(String.format("%.4f", quote.getOfferCleanPx())).doubleValue());
            if (quote.getQuoteType().equals("A")) {
                strategy.setProjectBid("A");
                strategy.setProjectOffer("B");
            }
            if (quote.getQuoteType().equals("B")) {
                strategy.setProjectBid("B");
                strategy.setProjectOffer("A");
            }
            if ((underlyings = snapshot.getUnderlyings()).size() > 0) {
                strategy.setActiveBidYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getBidYield() * 100.0)).doubleValue());
                strategy.setActiveOfferYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getOfferYield() * 100.0)).doubleValue());
                strategy.setActiveBidCleanPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getBidCleanPx())).doubleValue());
                strategy.setActiveBidDirtyPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getBidDirtyPx())).doubleValue());
                strategy.setActiveOfferCleanPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getOfferCleanPx())).doubleValue());
                strategy.setActiveOfferDirtyPx(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getOfferDirtyPx())).doubleValue());
                strategy.setActiveInterest(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(0)).getAccruedAmt())).doubleValue());
            }
            if (underlyings.size() > 1) {
                strategy.setInactiveBidYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getBidYield() * 100.0)).doubleValue());
                strategy.setInactiveOfferYieldCalc(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getOfferYield() * 100.0)).doubleValue());
                strategy.setInactiveBidCleanPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getBidCleanPx())).doubleValue());
                strategy.setInactiveBidDirtyPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getBidDirtyPx())).doubleValue());
                strategy.setInactiveOfferCleanPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getOfferCleanPx())).doubleValue());
                strategy.setInactiveOfferDirtyPxA(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getOfferDirtyPx())).doubleValue());
                strategy.setInactiveInterest(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(1)).getAccruedAmt())).doubleValue());
            }
            if (underlyings.size() <= 2) continue;
            strategy.setInactiveBidCleanPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getBidCleanPx())).doubleValue());
            strategy.setInactiveBidDirtyPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getBidDirtyPx())).doubleValue());
            strategy.setInactiveOfferCleanPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getOfferCleanPx())).doubleValue());
            strategy.setInactiveOfferDirtyPxB(Double.valueOf(String.format("%.4f", ((Quote)underlyings.get(2)).getOfferDirtyPx())).doubleValue());
        }
    }
}

