/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.models;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.GetExecutionsReq;
import cms.tmx.http.api.strategy.dto.GetExecutionsResp;
import cms.tmx.javafx.MxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StdBondForwardDealModel
extends MxModel {
    @Inject
    private OrderServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    private List<Execution> list = new ArrayList<Execution>();

    public List<Execution> getList() {
        return this.list;
    }

    public void query() throws IOException, MException {
        GetExecutionsReq req = new GetExecutionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("IB");
        Instrument instrument = new Instrument();
        instrument.setSecurityType("BOND");
        req.setInstrument(instrument);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetExecutionsResp resp = this.api.getDeals(req);
        this.list.clear();
        Page pageResp = resp.getPage();
        this.list.addAll(resp.getExecution());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetExecutionsResp res = this.api.getDeals(req);
            this.list.addAll(res.getExecution());
        }
        this.changed();
    }
}

